/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import org.jetbrains.annotations.Nullable;

public final class SafeOwner
implements class_9299 {
    private static final class_5250 BOUND = class_2561.method_43471((String)"message.supplementaries.safe.bound").method_27692(class_124.field_1080);
    private static final class_5250 UNBOUND = class_2561.method_43471((String)"message.supplementaries.safe.unbound").method_27692(class_124.field_1080);
    public static final Codec<SafeOwner> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.optionalFieldOf("owner").forGetter(s -> Optional.ofNullable(s.owner)), (App)Codec.STRING.optionalFieldOf("password").forGetter(s -> Optional.ofNullable(s.password)), (App)Codec.STRING.optionalFieldOf("owner").forGetter(s -> Optional.ofNullable(s.ownerName))).apply((Applicative)instance, SafeOwner::new));
    public static final class_9139<class_9129, SafeOwner> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56382((class_9139)class_4844.field_48453), s -> Optional.ofNullable(s.owner), (class_9139)class_9135.method_56382((class_9139)class_9135.field_48554), s -> Optional.ofNullable(s.ownerName), (class_9139)class_9135.method_56382((class_9139)class_9135.field_48554), s -> Optional.ofNullable(s.password), SafeOwner::new);
    @Nullable
    private final UUID owner;
    @Nullable
    private final String ownerName;
    @Nullable
    private final String password;

    SafeOwner(Optional<UUID> owner, Optional<String> ownerName, Optional<String> password) {
        this.owner = owner.orElse(null);
        this.ownerName = ownerName.orElse(null);
        this.password = password.orElse(null);
    }

    @Nullable
    public static SafeOwner of(@Nullable UUID owner, @Nullable String ownerName, @Nullable String password) {
        if (owner == null && password == null) {
            return null;
        }
        return new SafeOwner(Optional.ofNullable(owner), Optional.ofNullable(ownerName), Optional.ofNullable(password));
    }

    @Nullable
    public String ownerName() {
        return this.ownerName;
    }

    @Nullable
    public UUID owner() {
        return this.owner;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag) {
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.owner != null && !this.owner.equals(class_310.method_1551().field_1724.method_5667())) {
                if (this.ownerName != null) {
                    tooltipAdder.accept((class_2561)class_2561.method_43469((String)"message.supplementaries.safe.owner", (Object[])new Object[]{this.ownerName}).method_27692(class_124.field_1080));
                }
                return;
            }
            return;
        }
        if (this.password != null) {
            tooltipAdder.accept((class_2561)BOUND);
            return;
        }
        tooltipAdder.accept((class_2561)UNBOUND);
    }

    public boolean canPlayerOpen(class_1657 player) {
        if (player == null || player.method_7337()) {
            return true;
        }
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            return !this.isNotOwnedBy(player);
        }
        return ItemsUtil.getPlayerKeyStatus(player, this.password).isCorrect();
    }

    private boolean isNotOwnedBy(class_1657 player) {
        return this.owner != null && !this.owner.equals(player.method_5667());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafeOwner)) {
            return false;
        }
        SafeOwner safeOwner = (SafeOwner)o;
        return Objects.equals(this.owner, safeOwner.owner) && Objects.equals(this.ownerName, safeOwner.ownerName) && Objects.equals(this.password, safeOwner.password);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.ownerName, this.password);
    }
}

