/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.globe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.ByteBuffer;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedData;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedDataType;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeTextureGenerator;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class GlobeData
extends WorldSavedData {
    public static final Codec<GlobeData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BYTE_BUFFER.xmap(ByteBuffer::array, ByteBuffer::wrap).fieldOf("pixels").forGetter(g -> g.globePixels), (App)Codec.LONG.fieldOf("seed").forGetter(g -> g.seed)).apply((Applicative)i, GlobeData::new));
    public static final class_9139<class_9129, GlobeData> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48987, g -> g.globePixels, (class_9139)class_9135.field_48551, g -> g.seed, GlobeData::new);
    private static final int TEXTURE_H = 16;
    private static final int TEXTURE_W = 32;
    private final byte[] globePixels;
    private final long seed;

    private GlobeData(byte[] flattenedPixels, long seed) {
        this.globePixels = flattenedPixels;
        this.seed = seed;
    }

    public static GlobeData createFromLevel(class_3218 level) {
        return GlobeData.createFromSeed(level.method_8412());
    }

    public static GlobeData createFromSeed(long seed) {
        byte[][] generate = GlobeTextureGenerator.generate(seed);
        byte[] flattened = new byte[512];
        for (int x = 0; x < 32; ++x) {
            System.arraycopy(generate[x], 0, flattened, x * 16, 16);
        }
        return new GlobeData(flattened, seed);
    }

    public byte getPixel(int x, int y) {
        if (x < 0 || x >= 32 || y < 0 || y >= 16) {
            return 0;
        }
        return this.globePixels[x * 16 + y];
    }

    public int getTextureHeight() {
        return 16;
    }

    public int getTextureWidth() {
        return 32;
    }

    public WorldSavedDataType<GlobeData> getType() {
        return ModRegistry.GLOBE_DATA;
    }

    public void onReassigned(class_1937 level) {
        if (level.field_9236) {
            GlobeManager.refreshTextures();
        }
    }

    public static void recreateAndAssignFromSeed(class_3218 level, long seed) {
        GlobeData generate = GlobeData.createFromSeed(seed);
        ModRegistry.GLOBE_DATA.setData((class_1937)level, (WorldSavedData)generate);
        generate.sync();
    }
}

