/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.fabric;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_9322;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCCompatImpl {
    public static void setup() {
        PeripheralLookup.get().registerForBlocks((world, pos, state, blockEntity, context) -> {
            if (blockEntity instanceof SpeakerBlockTile) {
                SpeakerBlockTile t = (SpeakerBlockTile)blockEntity;
                if (t.ccHack == null) {
                    t.ccHack = new SpeakerPeripheral(t);
                }
                return (IPeripheral)t.ccHack;
            }
            return null;
        }, new class_2248[]{ModRegistry.SPEAKER_BLOCK.get()});
        PeripheralLookup.get().registerForBlocks((world, pos, state, blockEntity, context) -> {
            if (blockEntity instanceof CannonBlockTile) {
                CannonBlockTile t = (CannonBlockTile)blockEntity;
                if (t.ccHack == null) {
                    t.ccHack = new CannonPeripheral(t);
                }
                return (IPeripheral)t.ccHack;
            }
            return null;
        }, new class_2248[]{ModRegistry.CANNON.get()});
    }

    public static int getPages(class_1799 itemstack) {
        return PrintoutData.getOrEmpty((class_9322)itemstack).pages();
    }

    public static String[] getText(class_1799 itemstack) {
        return (String[])PrintoutData.getOrEmpty((class_9322)itemstack).lines().stream().map(PrintoutData.Line::text).toArray(String[]::new);
    }

    public static boolean isPrintedBook(class_1792 item) {
        return item instanceof PrintoutItem;
    }

    public static void init() {
    }

    public static final class CannonPeripheral
    implements IPeripheral {
        private final CannonBlockTile tile;
        private final CannonAccess acc;

        public CannonPeripheral(CannonBlockTile tile) {
            this.tile = tile;
            this.acc = CannonAccess.find(tile.method_10997(), TileOrEntityTarget.of((class_2586)tile));
        }

        @LuaFunction
        public void setYaw(double value) {
            this.tile.setYaw(this.acc, (float)value);
            this.acc.updateClients();
        }

        @LuaFunction
        public float getYaw() {
            return this.tile.getYaw();
        }

        @LuaFunction
        public void setPitch(double value) {
            this.tile.setPitch(this.acc, (float)value);
            this.acc.updateClients();
        }

        @LuaFunction
        public float getPitch() {
            return this.tile.getPitch();
        }

        @LuaFunction
        public void setPower(int inPower) {
            byte power = (byte)Math.min(Math.max(inPower, 1), 4);
            this.tile.setPowerLevel(power);
            this.acc.updateClients();
        }

        @LuaFunction
        public byte getPower() {
            return this.tile.getPowerLevel();
        }

        @LuaFunction
        public void ignite() {
            this.tile.ignite(null, this.acc);
        }

        public String getType() {
            return "cannon";
        }

        public boolean equals(@Nullable IPeripheral obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CannonPeripheral that = (CannonPeripheral)obj;
            return Objects.equals((Object)this.tile, (Object)that.tile);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.tile});
        }

        public String toString() {
            return "CannonPeripheral[tile=" + String.valueOf((Object)this.tile) + "]";
        }
    }

    public static final class SpeakerPeripheral
    implements IPeripheral {
        private final SpeakerBlockTile tile;

        public SpeakerPeripheral(SpeakerBlockTile tile) {
            this.tile = tile;
        }

        @LuaFunction
        public void setNarrator(SpeakerBlockTile.Mode mode) {
            this.tile.setMode(mode);
            this.tile.method_5431();
        }

        @LuaFunction
        public SpeakerBlockTile.Mode getMode() {
            return this.tile.getMode();
        }

        @LuaFunction
        public void setMessage(String message) {
            this.tile.setMessage((class_2561)class_2561.method_43470((String)message));
            this.tile.method_5431();
        }

        @LuaFunction
        public String getMessage() {
            return this.tile.getMessage(false).getString();
        }

        @LuaFunction
        public void setName(String name) {
            this.tile.setCustomName((class_2561)class_2561.method_43470((String)name));
            this.tile.method_5431();
        }

        @LuaFunction
        public String getName() {
            return this.tile.method_5477().getString();
        }

        @LuaFunction
        public double getVolume() {
            return this.tile.getVolume();
        }

        @LuaFunction
        public void setVolume(double volume) {
            this.tile.setVolume(volume);
            this.tile.method_5431();
        }

        @LuaFunction
        public void activate() {
            this.tile.sendMessage();
        }

        @NotNull
        public String getType() {
            return "speaker_block";
        }

        public boolean equals(@Nullable IPeripheral other) {
            return Objects.equals(this, other);
        }

        public SpeakerBlockTile tile() {
            return this.tile;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SpeakerPeripheral that = (SpeakerPeripheral)obj;
            return Objects.equals((Object)this.tile, (Object)that.tile);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.tile});
        }

        public String toString() {
            return "SpeakerPeripheral[tile=" + String.valueOf((Object)this.tile) + "]";
        }
    }
}

