/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.FluidsUtil;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5253;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class FaucetBlock
extends WaterBlock
implements class_2343 {
    protected static final class_265 SHAPE_NORTH = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)15.0, (double)16.0);
    protected static final class_265 SHAPE_SOUTH = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH, (class_2350)class_2350.field_11035);
    protected static final class_265 SHAPE_WEST = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH, (class_2350)class_2350.field_11039);
    protected static final class_265 SHAPE_EAST = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH, (class_2350)class_2350.field_11034);
    protected static final class_265 SHAPE_NORTH_JAR = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final class_265 SHAPE_SOUTH_JAR = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH_JAR, (class_2350)class_2350.field_11035);
    protected static final class_265 SHAPE_WEST_JAR = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH_JAR, (class_2350)class_2350.field_11039);
    protected static final class_265 SHAPE_EAST_JAR = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH_JAR, (class_2350)class_2350.field_11034);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 HAS_WATER = ModBlockProperties.HAS_WATER;
    public static final class_2758 LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL_0_7;
    public static final class_2746 CONNECTED = ModBlockProperties.CONNECTED;

    public FaucetBlock(class_4970.class_2251 properties) {
        super(properties.method_9631(s -> (Integer)s.method_11654((class_2769)LIGHT_LEVEL)));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)CONNECTED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_WATER, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (((Boolean)state.method_11654((class_2769)CONNECTED)).booleanValue()) {
            return switch ((class_2350)state.method_11654((class_2769)FACING)) {
                case class_2350.field_11035 -> SHAPE_SOUTH_JAR;
                case class_2350.field_11034 -> SHAPE_EAST_JAR;
                case class_2350.field_11039 -> SHAPE_WEST_JAR;
                default -> SHAPE_NORTH_JAR;
            };
        }
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11034 -> SHAPE_EAST;
            case class_2350.field_11039 -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        boolean enabled = (Boolean)state.method_11654((class_2769)ENABLED);
        float f = enabled ? 1.0f : 1.2f;
        level.method_8396(null, pos, ModSounds.FAUCET.get(), class_3419.field_15245, 1.0f, f);
        level.method_33596((class_1297)player, (class_6880)(enabled ? class_5712.field_28174 : class_5712.field_28175), pos);
        this.updateBlock(state, level, pos, true);
        return class_1269.field_5812;
    }

    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        boolean hasWater = this.updateTileFluid(state, pos, (class_1936)worldIn);
        if (hasWater != (Boolean)state.method_11654((class_2769)HAS_WATER)) {
            worldIn.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_WATER, (Comparable)Boolean.valueOf(hasWater)));
        }
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)stateIn.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            worldIn.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)worldIn));
        }
        if (facing == class_2350.field_11033) {
            boolean canConnectDown = this.canConnect(facingState, worldIn, facingPos, facing.method_10153());
            return (class_2680)stateIn.method_11657((class_2769)CONNECTED, (Comparable)Boolean.valueOf(canConnectDown));
        }
        if (facing == ((class_2350)stateIn.method_11654((class_2769)FACING)).method_10153()) {
            boolean hasWater = this.updateTileFluid(stateIn, currentPos, worldIn);
            return (class_2680)stateIn.method_11657((class_2769)HAS_WATER, (Comparable)Boolean.valueOf(hasWater));
        }
        return stateIn;
    }

    public boolean updateTileFluid(class_2680 state, class_2338 pos, class_1936 world) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FaucetBlockTile) {
            FaucetBlockTile tile = (FaucetBlockTile)class_25862;
            if (world instanceof class_1937) {
                class_1937 level = (class_1937)world;
                return tile.updateContainedFluidVisuals(level, pos, state);
            }
        }
        return false;
    }

    public void onNeighborChange(class_2680 state, class_4538 world, class_2338 pos, class_2338 neighbor) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FaucetBlockTile) {
            FaucetBlockTile tile = (FaucetBlockTile)class_25862;
            if (world instanceof class_1937) {
                class_1937 level = (class_1937)world;
                boolean water = tile.updateContainedFluidVisuals(level, pos, state);
                if ((Boolean)state.method_11654((class_2769)HAS_WATER) != water) {
                    level.method_8652(pos, (class_2680)state.method_11657((class_2769)HAS_WATER, (Comparable)Boolean.valueOf(water)), 2);
                }
            }
        }
    }

    private boolean canConnect(class_2680 downState, class_1936 world, class_2338 pos, class_2350 dir) {
        class_1937 level;
        if (downState.method_26204() instanceof JarBlock) {
            return true;
        }
        if (downState.method_26204() instanceof class_2275) {
            return false;
        }
        if (downState.method_26164(ModTags.FAUCET_CONNECTION_BLACKLIST)) {
            return false;
        }
        if (downState.method_26164(ModTags.FAUCET_CONNECTION_WHITELIST)) {
            return false;
        }
        if (downState.method_28498((class_2769)class_2741.field_20432)) {
            return true;
        }
        return world instanceof class_1937 && FluidsUtil.hasFluidHandler(level = (class_1937)world, pos, dir);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 neighborBlock, class_2338 fromPos, boolean moving) {
        super.method_9612(state, world, pos, neighborBlock, fromPos, moving);
        this.updateBlock(state, world, pos, false);
    }

    public void updateBlock(class_2680 state, class_1937 world, class_2338 pos, boolean toggle) {
        boolean hasWater;
        boolean isPowered = world.method_49803(pos);
        if (isPowered != (Boolean)state.method_11654((class_2769)POWERED) || toggle) {
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(isPowered))).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(toggle ^ (Boolean)state.method_11654((class_2769)ENABLED))), 2);
        }
        if ((hasWater = this.updateTileFluid(state, pos, (class_1936)world)) != (Boolean)state.method_11654((class_2769)HAS_WATER)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_WATER, (Comparable)Boolean.valueOf(hasWater)));
        }
    }

    public boolean isOpen(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12484) ^ (Boolean)state.method_11654((class_2769)class_2741.field_12515);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ENABLED, POWERED, HAS_WATER, CONNECTED, WATERLOGGED, LIGHT_LEVEL});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 dir = context.method_8038().method_10166() == class_2350.class_2351.field_11052 ? class_2350.field_11043 : context.method_8038();
        boolean water = world.method_8316(pos).method_15772() == class_3612.field_15910;
        boolean hasJar = this.canConnect(world.method_8320(pos.method_10074()), (class_1936)world, pos.method_10074(), class_2350.field_11036);
        boolean powered = world.method_49803(pos);
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)dir)).method_11657((class_2769)CONNECTED, (Comparable)Boolean.valueOf(hasJar))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(water))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        boolean flag = this.isOpen(state);
        if (((Boolean)state.method_11654((class_2769)HAS_WATER)).booleanValue() && !((Boolean)state.method_11654((class_2769)CONNECTED)).booleanValue()) {
            double d = random.method_43057();
            double d2 = flag ? 0.0 : 0.06;
            if (d > d2) {
                return;
            }
            float d3 = 0.125f;
            double x = (double)pos.method_10263() + 0.5 + (double)d3 * ((double)random.method_43057() - 0.5);
            double y = (double)pos.method_10264() + 0.25;
            double z = (double)pos.method_10260() + 0.5 + (double)d3 * ((double)random.method_43057() - 0.5);
            int color = this.getTileParticleColor(pos, world);
            float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
            float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
            float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
            world.method_8406((class_2394)ModParticles.DRIPPING_LIQUID.get(), x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public int getTileParticleColor(class_2338 pos, class_1937 world) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FaucetBlockTile) {
            FaucetBlockTile te = (FaucetBlockTile)class_25862;
            return te.tempFluidHolder.getCachedParticleColor((class_1920)world, pos);
        }
        return 4340983;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new FaucetBlockTile(pPos, pState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 pLevel, class_2680 pState, class_2591<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.FAUCET_TILE.get(), (class_5558)(pLevel.field_9236 ? null : FaucetBlockTile::tick));
    }
}

