/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.cauldron.CauldronBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.FireBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.items.loot.RandomArrowFunction;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.common.worldgen.WaySignStructure;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.LootTablesInjects;
import net.mehvahdjukaar.supplementaries.reg.ModCreativeTabs;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.RegUtils;
import net.minecraft.class_1853;
import net.minecraft.class_2248;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9283;
import net.minecraft.server.MinecraftServer;

public class ModSetup {
    private static boolean hasFinishedSetup = false;
    private static int setupStage = 0;
    private static boolean firstTagLoad = false;
    private static final List<Runnable> MOD_SETUP_WORK = List.of(CompatHandler::setup, RegUtils::registerAdditionalPlacements, FlowerPotHandler::setup, ModSetup::registerFlammables, CauldronBehaviorsManager::registerBehaviors, ModCreativeTabs::populateItemsVisibility, () -> class_1853.field_9013.put(ModRegistry.ENDERMAN_SKULL_ITEM.get(), class_9283.class_1782.field_7974));

    public static void init() {
        PlatHelper.addCommonSetup(ModSetup::setup);
        PlatHelper.addCommonSetup(ModSetup::asyncSetup);
        PlatHelper.addReloadableCommonSetup(ModSetup::tagDependantSetup);
    }

    public static void asyncSetup() {
        RandomArrowFunction.setup();
        LootTablesInjects.setup();
        ModSetup.registerFrameBlocks();
        PlaceableBookManager.setup();
    }

    public static void setup() {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            Stopwatch watch = Stopwatch.createStarted();
            for (int i = 0; i < MOD_SETUP_WORK.size(); ++i) {
                setupStage = i;
                MOD_SETUP_WORK.get(i).run();
                list.add(watch.elapsed().toMillis());
                watch.reset();
                watch.start();
            }
            hasFinishedSetup = true;
            Supplementaries.LOGGER.info("Finished mod setup in: {} ms", list);
        }
        catch (Exception e) {
            ModSetup.terminateWhenSetupFails(e);
        }
    }

    private static void terminateWhenSetupFails(Exception e) {
        throw new IllegalStateException("Mod setup has failed to complete (" + setupStage + ").\n This might be due to some mod incompatibility or outdated dependencies (check if everything is up to date).\n Refusing to continue loading with a broken modstate. Next step: crashing this game, no survivors", e);
    }

    private static void registerFlammables() {
        RegHelper.registerBlockFlammability((class_2248)((class_2248)ModRegistry.ROPE.get()), (int)60, (int)100);
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.FINE_WOOD.get(), (int)5, (int)20);
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.FINE_WOOD_SLAB.get(), (int)5, (int)20);
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.FINE_WOOD_STAIRS.get(), (int)5, (int)20);
        RegHelper.registerBlockFlammability((class_2248)((class_2248)ModRegistry.TIMBER_FRAME.get()), (int)5, (int)20);
        RegHelper.registerBlockFlammability((class_2248)((class_2248)ModRegistry.TIMBER_BRACE.get()), (int)5, (int)20);
        RegHelper.registerBlockFlammability((class_2248)((class_2248)ModRegistry.TIMBER_CROSS_BRACE.get()), (int)5, (int)20);
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.STICK_BLOCK.get(), (int)30, (int)60);
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.FLAX_BLOCK.get(), (int)60, (int)20);
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.FLAX_WILD.get(), (int)60, (int)100);
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.FEATHER_BLOCK.get(), (int)30, (int)60);
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.GUNPOWDER_BLOCK.get(), (int)200, (int)0);
        RegHelper.registerBlockFlammability((class_2248)((class_2248)ModFluids.LUMISENE_BLOCK.get()), (int)200, (int)0);
        RegHelper.registerBlockFlammability((class_2248)ModRegistry.WICKER_FENCE.get(), (int)30, (int)60);
        for (Supplier<class_2248> f : ModRegistry.FLAGS.values()) {
            RegHelper.registerBlockFlammability((class_2248)f.get(), (int)60, (int)60);
        }
        for (Supplier<class_2248> b : ModRegistry.BUNTING_BLOCKS.values()) {
            RegHelper.registerBlockFlammability((class_2248)b.get(), (int)60, (int)100);
        }
        for (Supplier<class_2248> b : ModRegistry.BUNTING_WALL_BLOCKS.values()) {
            RegHelper.registerBlockFlammability((class_2248)b.get(), (int)60, (int)100);
        }
        for (Supplier<class_2248> a : ModRegistry.AWNINGS.values()) {
            RegHelper.registerBlockFlammability((class_2248)a.get(), (int)60, (int)20);
        }
    }

    private static void registerFrameBlocks() {
        ((FrameBlock)ModRegistry.TIMBER_FRAME.get()).registerFilledBlock((class_2248)ModRegistry.DAUB.get(), (class_2248)ModRegistry.DAUB_FRAME.get());
        ModRegistry.TIMBER_BRACE.get().registerFilledBlock((class_2248)ModRegistry.DAUB.get(), (class_2248)ModRegistry.DAUB_BRACE.get());
        ModRegistry.TIMBER_CROSS_BRACE.get().registerFilledBlock((class_2248)ModRegistry.DAUB.get(), (class_2248)ModRegistry.DAUB_CROSS_BRACE.get());
    }

    public static void tagDependantSetup(class_5455 registryAccess, boolean client) {
        if (!firstTagLoad) {
            firstTagLoad = true;
            if (!hasFinishedSetup) {
                try {
                    Supplementaries.LOGGER.error("Something went wrong during mod setup, exiting");
                    MOD_SETUP_WORK.get(setupStage).run();
                    Supplementaries.LOGGER.error("No error found. Weird");
                }
                catch (Exception e) {
                    ModSetup.terminateWhenSetupFails(e);
                }
            }
        }
        InteractEventsHandler.registerOverrides((class_7225.class_7874)registryAccess);
        FireBehaviorsManager.registerBehaviors(registryAccess);
        if (!client) {
            WaySignStructure.recomputeValidStructureCache(registryAccess);
            try {
                SoftFluidRegistry.get((class_5455)registryAccess).method_10223(MLBuiltinSoftFluids.EMPTY.getID());
                SoftFluidRegistry.get((class_5455)registryAccess).method_10223(MLBuiltinSoftFluids.WATER.getID());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get empty soft fluid from datapack. How?", e);
            }
            MinecraftServer server = PlatHelper.getCurrentServer();
            if (server != null) {
                FaucetBehaviorsManager.reloadWithLevel(server.method_30002());
            }
        }
    }
}

