/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeData;
import net.mehvahdjukaar.supplementaries.common.utils.Credits;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GlobeManager {
    private static final Map<String, TextureInstance> TEXTURE_CACHE = Maps.newHashMap();
    private static final HashMap<ResourceLocation, IntList> DIMENSION_COLOR_MAP = new HashMap();
    private static final IntList SEPIA_COLORS = new IntArrayList();
    private static final Map<String, Pair<Model, ResourceLocation>> NAME_CACHE = new HashMap<String, Pair<Model, ResourceLocation>>();
    private static final Map<String, Float> MODEL_ID_MAP = new HashMap<String, Float>();
    public static final List<ResourceLocation> TEXTURES = new ArrayList<ResourceLocation>();

    public static void refreshTextures() {
        TEXTURE_CACHE.clear();
    }

    public static RenderType getRenderType(Level world, boolean sepia) {
        return GlobeManager.getTextureInstance((Level)world, (boolean)sepia).renderType;
    }

    private static TextureInstance getTextureInstance(Level world, boolean sepia) {
        return TEXTURE_CACHE.computeIfAbsent(GlobeManager.getTextureId(world, sepia), i -> new TextureInstance(world, sepia));
    }

    private static String getTextureId(Level level, boolean sepia) {
        Object id = level.dimension().location().getPath();
        if (sepia) {
            id = (String)id + "_sepia";
        }
        return id;
    }

    public static void refreshColorsAndTextures(ResourceManager manager) {
        GlobeManager.recomputeCache();
        DIMENSION_COLOR_MAP.clear();
        int targetColors = 13;
        for (ResourceLocation res : manager.listResources("textures/entity/globes/palettes", r -> r.getPath().endsWith(".png")).keySet()) {
            List l = SpriteUtils.parsePaletteStrip((ResourceManager)manager, (ResourceLocation)res, (int)targetColors);
            String name = res.getPath();
            if ((name = name.substring(name.lastIndexOf("/") + 1).replace(".png", "")).equals("sepia")) {
                SEPIA_COLORS.clear();
                SEPIA_COLORS.addAll((Collection)l);
                continue;
            }
            DIMENSION_COLOR_MAP.put(ResourceLocation.tryParse((String)name.replace(".", ":")), (IntList)new IntArrayList((Collection)l));
        }
        if (DIMENSION_COLOR_MAP.isEmpty()) {
            Supplementaries.LOGGER.error("Could not find any globe palette in textures/entity/globes/palettes");
        }
        GlobeManager.refreshTextures();
    }

    public static void recomputeCache() {
        NAME_CACHE.clear();
        for (Type type : Type.values()) {
            Model model = type == Type.FLAT ? Model.FLAT : Model.GLOBE;
            Pair pair = Pair.of((Object)((Object)model), (Object)type.texture);
            if (type.transKeyWord != null && !type.transKeyWord.getString().equals("")) {
                NAME_CACHE.put(type.transKeyWord.getString().toLowerCase(Locale.ROOT), (Pair<Model, ResourceLocation>)pair);
            }
            for (String s : type.keyWords) {
                if (s.equals("")) continue;
                NAME_CACHE.put(s, (Pair<Model, ResourceLocation>)pair);
            }
        }
        for (Map.Entry entry : Credits.INSTANCE.globes().entrySet()) {
            ResourceLocation path = (ResourceLocation)entry.getValue();
            Model model = Model.GLOBE;
            if (path.getPath().contains("globe_wais")) {
                model = Model.SNOW;
            }
            NAME_CACHE.put((String)entry.getKey(), (Pair<Model, ResourceLocation>)Pair.of((Object)((Object)model), (Object)path));
        }
        TEXTURES.clear();
        NAME_CACHE.values().forEach(o -> {
            if (!TEXTURES.contains(o.getSecond())) {
                TEXTURES.add((ResourceLocation)o.getSecond());
            }
        });
        Collections.sort(TEXTURES);
        MODEL_ID_MAP.clear();
        NAME_CACHE.forEach((key, value) -> MODEL_ID_MAP.put((String)key, Float.valueOf(TEXTURES.indexOf(value.getSecond()))));
    }

    @Nullable
    public static Pair<Model, ResourceLocation> getModelAndTexture(String text) {
        return NAME_CACHE.get(text.toLowerCase(Locale.ROOT));
    }

    public static Float getTextureID(String text) {
        return MODEL_ID_MAP.getOrDefault(text.toLowerCase(Locale.ROOT), Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    private static class TextureInstance
    implements AutoCloseable {
        private final ResourceLocation textureLocation;
        private final DynamicTexture texture;
        private final RenderType renderType;
        private final ResourceLocation dimensionId;
        private final boolean sepia;

        private TextureInstance(Level world, boolean sepia) {
            this.sepia = sepia;
            this.dimensionId = world.dimension().location();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture = new DynamicTexture(32, 16, false);
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
            this.updateTexture(world);
            this.textureLocation = Minecraft.getInstance().getTextureManager().register("globe/" + this.dimensionId.toString().replace(":", "_"), this.texture);
            this.renderType = RenderUtil.getEntitySolidMipmapRenderType((ResourceLocation)this.textureLocation);
        }

        private void updateTexture(Level world) {
            GlobeData data = GlobeData.get(world);
            if (data == null) {
                return;
            }
            byte[][] pixels = data.getPixels();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.texture.getPixels().setPixelRGBA(j, i, -13061505);
                }
            }
            for (int y = 0; y < pixels.length; ++y) {
                for (int x = 0; x < pixels[y].length; ++x) {
                    this.texture.getPixels().setPixelRGBA(y, x, TextureInstance.getRGBA(pixels[y][x], this.dimensionId, this.sepia));
                }
            }
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture.upload();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
        }

        @Override
        public void close() {
            this.texture.close();
            Minecraft.getInstance().getTextureManager().release(this.textureLocation);
        }

        private static int getRGBA(byte b, ResourceLocation dimension, boolean sepia) {
            if (sepia) {
                return SEPIA_COLORS.getInt((int)b);
            }
            IntList l = DIMENSION_COLOR_MAP.getOrDefault(dimension, DIMENSION_COLOR_MAP.get(ResourceLocation.withDefaultNamespace((String)"overworld")));
            if (l != null) {
                return l.getInt((int)b);
            }
            return 1;
        }
    }

    public static enum Type {
        FLAT(new String[]{"flat", "flat earth"}, (Component)Component.translatable((String)"globe.supplementaries.flat"), ModTextures.GLOBE_FLAT_TEXTURE),
        MOON(new String[]{"moon", "luna", "selene", "cynthia"}, (Component)Component.translatable((String)"globe.supplementaries.moon"), ModTextures.GLOBE_MOON_TEXTURE),
        EARTH(new String[]{"earth", "terra", "gaia", "gaea", "tierra", "tellus", "terre"}, (Component)Component.translatable((String)"globe.supplementaries.earth"), ModTextures.GLOBE_TEXTURE),
        SUN(new String[]{"sun", "sol", "helios"}, (Component)Component.translatable((String)"globe.supplementaries.sun"), ModTextures.GLOBE_SUN_TEXTURE);

        private final String[] keyWords;
        private final Component transKeyWord;
        private final ResourceLocation texture;

        private Type(String[] key, Component tr, ResourceLocation res) {
            this.keyWords = key;
            this.transKeyWord = tr;
            this.texture = res;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }

    public static enum Model {
        GLOBE,
        FLAT,
        SNOW,
        SHEARED;

    }
}

