/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class FeatherParticle
extends TextureSheetParticle {
    private final float rotSpeed;
    private boolean fallingAnim = false;
    private int animationOffset;
    private float rotOffset = 0.0f;
    private int groundTime = 0;

    private FeatherParticle(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double speedX, double speedY, double speedZ) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.quadSize *= (float)(1.3125 + (double)this.random.nextFloat() * 0.15);
        this.lifetime = 360 + this.random.nextInt(60);
        this.rotSpeed = 2.0f * (0.045f + this.random.nextFloat() * 0.08f) + ((float)speedY - 0.03f);
        this.animationOffset = (int)(this.random.nextFloat() * ((float)Math.PI * 2) / this.rotSpeed);
        this.xd = speedX + ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.008f;
        this.yd = speedY;
        this.zd = speedZ + ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.008f;
        this.gravity = 0.007f;
    }

    public void setRotOffset(int spriteIndex) {
        int[] offsets = new int[]{43, 0, -16};
        this.rotOffset = (float)offsets[spriteIndex] * ((float)Math.PI / 180);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (++this.age >= this.lifetime || this.groundTime > 20) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)this.friction;
            this.yd *= (double)this.friction;
            this.zd *= (double)this.friction;
            if (this.onGround && this.yd > 0.0) {
                this.onGround = false;
            }
            if (!this.onGround) {
                if (!this.fallingAnim) {
                    float rot = (float)((double)((float)(this.age + this.animationOffset) * this.rotSpeed) % (Math.PI * 2));
                    if (this.yd <= 0.0 && rot > 0.0f && (double)rot < 0.01 + (double)(this.rotSpeed * 2.0f)) {
                        this.fallingAnim = true;
                        if (this.oRoll > 6.0f) {
                            // empty if block
                        }
                        this.animationOffset = this.age;
                    }
                    this.oRoll = this.roll;
                    this.roll = rot;
                } else {
                    int t = this.age - this.animationOffset;
                    double freq = 1.0f - this.rotSpeed;
                    double k = 20.0;
                    float min = (float)(freq / 2.0);
                    float amp = (float)((freq - (double)min) * Math.exp((double)(-t) / k)) + min;
                    float w = (float)((double)this.rotSpeed / freq);
                    this.oRoll = this.roll;
                    this.roll = Mth.sin((float)((float)t * w)) * amp;
                }
            } else {
                ++this.groundTime;
                this.oRoll = this.roll;
                this.yd = 0.0;
            }
        }
    }

    public void render(VertexConsumer builder, Camera info, float partialTicks) {
        Quaternionf quaternion;
        if (this.roll == 0.0f) {
            quaternion = info.rotation();
        } else {
            quaternion = new Quaternionf((Quaternionfc)info.rotation());
            float p = 57.295776f;
            float f3 = Mth.rotLerp((float)partialTicks, (float)((this.rotOffset + this.oRoll) * p), (float)((this.rotOffset + this.roll) * p));
            quaternion.mul((Quaternionfc)Axis.ZP.rotation(f3 / p));
        }
        this.renderRotatedQuad(builder, info, quaternion, partialTicks);
    }

    protected void renderRotatedQuad(VertexConsumer vertexConsumer, Camera camera, Quaternionf quaternionf, float f) {
        Vec3 vec3 = camera.getPosition();
        float offset = 0.125f;
        float g = (float)(Mth.lerp((double)f, (double)this.xo, (double)this.x) - vec3.x());
        float h = (float)(Mth.lerp((double)f, (double)this.yo, (double)this.y) - vec3.y()) + offset;
        float i = (float)(Mth.lerp((double)f, (double)this.zo, (double)this.z) - vec3.z());
        this.renderRotatedQuad(vertexConsumer, quaternionf, g, h, i, f);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FeatherParticle particle = new FeatherParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.setColor(1.0f, 1.0f, 1.0f);
            int i = particle.random.nextInt(3);
            particle.setRotOffset(i);
            particle.setSprite(this.spriteSet.get(i, 2));
            return particle;
        }
    }
}

