/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.EnumMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.NoiseRenderType;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class GlobeBlockTileRenderer
implements BlockEntityRenderer<GlobeBlockTile> {
    private final Map<GlobeManager.Model, ModelPart> models = new EnumMap<GlobeManager.Model, ModelPart>(GlobeManager.Model.class);
    private final boolean noise;
    public static GlobeBlockTileRenderer INSTANCE = null;

    public static LayerDefinition createBaseMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("globe", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)16);
    }

    public static LayerDefinition createSpecialMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("flat", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -28.0f, -4.0f, 8.0f, 4.0f, 8.0f).texOffs(0, 13).addBox(-4.0f, -24.0f, -4.0f, 8.0f, 2.0f, 8.0f).texOffs(4, 23).addBox(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f).texOffs(8, 24).addBox(-2.0f, -21.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        root.addOrReplaceChild("sheared", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 4.0f).texOffs(0, 12).addBox(0.0f, -28.0f, 0.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition snow = root.addOrReplaceChild("snow", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -28.0f, -4.0f, 8.0f, 5.0f, 8.0f).texOffs(0, 14).addBox(-4.0f, -23.0f, -4.0f, 8.0f, 1.0f, 8.0f).texOffs(4, 16).addBox(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f).texOffs(0, 17).addBox(-2.0f, -24.0f, -2.0f, 4.0f, 1.0f, 4.0f).texOffs(0, 28).addBox(-1.0f, -25.975f, -1.0f, 2.0f, 2.0f, 2.0f).texOffs(12, 20).addBox(-1.0f, -21.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        snow.addOrReplaceChild("roof_l", CubeListBuilder.create().texOffs(11, 27).addBox(0.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-25.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        snow.addOrReplaceChild("roof_r", CubeListBuilder.create().texOffs(0, 27).addBox(-2.0f, -1.0f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-25.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public GlobeBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.bakeLayer(ClientRegistry.GLOBE_BASE_MODEL);
        this.models.put(GlobeManager.Model.GLOBE, model.getChild("globe"));
        ModelPart special = context.bakeLayer(ClientRegistry.GLOBE_SPECIAL_MODEL);
        this.models.put(GlobeManager.Model.FLAT, special.getChild("flat"));
        this.models.put(GlobeManager.Model.SNOW, special.getChild("snow"));
        this.models.put(GlobeManager.Model.SHEARED, special.getChild("sheared"));
        INSTANCE = this;
        this.noise = MiscUtils.FESTIVITY.isAprilsFool();
    }

    public void render(GlobeBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 0.5, 0.5);
        matrixStackIn.mulPose(RotHlpr.rot((Direction)tile.getDirection()));
        matrixStackIn.translate(0.0, 0.0625, 0.0);
        matrixStackIn.mulPose(RotHlpr.X22);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(-tile.getRotation(partialTicks)));
        this.renderGlobe(tile.getRenderData(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, tile.isSepia(), tile.getLevel());
        matrixStackIn.popPose();
    }

    public void renderGlobe(Pair<GlobeManager.Model, ResourceLocation> data, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, boolean isSepia, Level level) {
        VertexConsumer builder;
        if (data == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.mulPose(RotHlpr.X180);
        ResourceLocation texture = ClientConfigs.Blocks.GLOBE_RANDOM.get() != false ? (ResourceLocation)data.getSecond() : GlobeManager.Type.EARTH.getTexture();
        ModelPart model = this.models.get(data.getFirst());
        if (texture == null) {
            if (this.noise) {
                double si = Math.sin((double)System.currentTimeMillis() / 8000.0) * 30.0;
                float v = (float)Mth.clamp((double)si, (double)-0.5, (double)0.5);
                float c = (float)Mth.clamp((double)si, (double)-2.0, (double)2.0);
                Uniform intensity = ClientRegistry.NOISE_SHADER.get().getUniform("Intensity");
                if (intensity != null) {
                    intensity.set(Mth.cos((float)((float)Math.PI * c / 4.0f)));
                }
                poseStack.scale(v + 0.5f + 0.01f, 1.0f, 1.0f);
                builder = buffer.getBuffer(NoiseRenderType.STATIC_NOISE.apply(ModTextures.GLOBE_TEXTURE));
            } else {
                builder = buffer.getBuffer(GlobeManager.getRenderType(level, isSepia));
            }
        } else {
            builder = buffer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)texture));
        }
        model.render(poseStack, builder, light, overlay, -1);
        poseStack.popPose();
    }
}

