/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.block_models.JarBakedModel;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexModels;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CageBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class JarBlockTileRenderer
extends CageBlockTileRenderer<JarBlockTile> {
    private final ItemRenderer itemRenderer;
    private static final boolean USE_MODEL = false;

    public JarBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        Minecraft minecraft = Minecraft.getInstance();
        this.itemRenderer = minecraft.getItemRenderer();
    }

    public static void renderFluid(float percentageFill, int color, int luminosity, ResourceLocation texture, PoseStack poseStack, MultiBufferSource bufferIn, int light, int combinedOverlayIn) {
        poseStack.pushPose();
        if (luminosity != 0) {
            light = light & 0xF00000 | luminosity << 4;
        }
        VertexConsumer builder = ModMaterials.get(texture).buffer(bufferIn, RenderType::entityTranslucentCull);
        Vector3f dimensions = JarBakedModel.getJarLiquidDimensions();
        poseStack.translate(0.5, (double)dimensions.z(), 0.5);
        VertexUtil.addCube((VertexConsumer)builder, (PoseStack)poseStack, (float)dimensions.x(), (float)(percentageFill * dimensions.y()), (int)light, (int)color);
        poseStack.popPose();
    }

    @Override
    public void render(JarBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        SoftFluidTank tank;
        long r = tile.getBlockPos().asLong();
        RandomSource rand = RandomSource.create((long)r);
        AtomicInteger i = new AtomicInteger();
        JarBlockTileRenderer.renderCookies(this.itemRenderer, poseStack, bufferIn, rand, combinedLightIn, combinedOverlayIn, () -> {
            int j = i.getAndIncrement();
            return j < tile.getContainerSize() ? tile.getItem(j) : ItemStack.EMPTY;
        });
        MobContainer.MobData data = tile.mobContainer.getData();
        if (data != null) {
            if (data.is2DFish()) {
                poseStack.pushPose();
                long time = System.currentTimeMillis() + r;
                float angle = (float)(time % 28800L) / 80.0f;
                float angle2 = (float)(time % 1080L) / 3.0f;
                float angle3 = (float)(time % 126000L) / 350.0f;
                float wo = 0.015f * Mth.sin((float)((float)(Math.PI * 2 * (double)angle2 / 360.0)));
                float ho = 0.1f * Mth.sin((float)((float)(Math.PI * 2 * (double)angle3 / 360.0)));
                poseStack.translate(0.5, 0.5, 0.5);
                Quaternionf rotation = Axis.YP.rotationDegrees(-angle);
                poseStack.mulPose(rotation);
                poseStack.scale(0.625f, 0.625f, 0.625f);
                Vector3f dimensions = JarBakedModel.getJarLiquidDimensions();
                poseStack.translate(0.0, -0.2, -0.335 * (double)(dimensions.x() / 0.5f));
                int fishType = data.getFishTexture();
                VertexModels.renderFish(bufferIn, poseStack, wo, ho, fishType, combinedLightIn);
                poseStack.popPose();
            } else {
                super.render(tile, partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            Optional<Holder<SoftFluid>> fluid = tile.mobContainer.shouldRenderWithFluid();
            if (fluid != null && fluid.isPresent()) {
                if (fluid.get().is(MLBuiltinSoftFluids.WATER.getID())) {
                    poseStack.pushPose();
                    Vector3f dimensions = JarBakedModel.getJarLiquidDimensions();
                    poseStack.translate(0.5, 0.0015 + (double)dimensions.z(), 0.5);
                    VertexConsumer builder = ModMaterials.SAND_MATERIAL.buffer(bufferIn, RenderType::entityCutout);
                    VertexUtil.addCube((VertexConsumer)builder, (PoseStack)poseStack, (float)(0.99f * dimensions.x()), (float)(dimensions.y() / 12.0f), (int)combinedLightIn, (int)-1);
                    poseStack.popPose();
                }
                poseStack.pushPose();
                SoftFluid s = (SoftFluid)fluid.get().value();
                JarBlockTileRenderer.renderFluid(0.75f, s.getTintColor(), 0, s.getStillTexture(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
                poseStack.popPose();
            }
        }
        if (!(tank = tile.fluidHolder).isEmpty()) {
            SoftFluid fluid = tank.getFluidValue();
            JarBlockTileRenderer.renderFluid(tank.getHeight(1.0f), tank.getCachedStillColor((BlockAndTintGetter)tile.getLevel(), tile.getBlockPos()), fluid.getEmissivity(), fluid.getStillTexture(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }

    public static void renderCookies(ItemRenderer itemRenderer, PoseStack poseStack, MultiBufferSource buffer, RandomSource rand, int light, int overlay, Supplier<ItemStack> itemIterator) {
        ItemStack cookieStack = itemIterator.get();
        if (!cookieStack.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(RotHlpr.XN90);
            poseStack.translate(0.0, 0.0, -0.5);
            float scale = 0.5714286f;
            poseStack.scale(scale, scale, scale);
            do {
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)rand.nextInt(360)));
                poseStack.translate(0.0f, 0.0f, 1.0f / (16.0f * scale));
                BakedModel model = itemRenderer.getModel(cookieStack, null, null, 0);
                itemRenderer.render(cookieStack, ItemDisplayContext.FIXED, true, poseStack, buffer, light, overlay, model);
            } while (!(cookieStack = itemIterator.get()).isEmpty());
            poseStack.popPose();
        }
    }
}

