/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.DrawableBlackBoardButton;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.DyeBlackBoardButton;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetBlackboardPacket;
import net.mehvahdjukaar.supplementaries.common.utils.CircularList;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.ImmediatelyFastCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public class BlackBoardScreen
extends Screen {
    private static final MutableComponent CLEAR = Component.translatable((String)"gui.supplementaries.blackboard.clear");
    private static final MutableComponent UNDO = Component.translatable((String)"gui.supplementaries.blackboard.undo");
    private static final MutableComponent EDIT = Component.translatable((String)"gui.supplementaries.blackboard.edit");
    private final BlackboardBlockTile tile;
    private final DrawableBlackBoardButton[][] buttons = new DrawableBlackBoardButton[16][16];
    private final Deque<List<Entry>> history = new CircularList<List<Entry>>(20);
    private List<Entry> currentHistoryStep = new ArrayList<Entry>();
    private Button historyButton;
    private byte selectedColor = 1;

    private BlackBoardScreen(BlackboardBlockTile teBoard) {
        super((Component)EDIT);
        this.tile = teBoard;
    }

    public static void open(BlackboardBlockTile sign) {
        Minecraft.getInstance().setScreen((Screen)new BlackBoardScreen(sign));
    }

    public void tick() {
        if (!this.isValid()) {
            this.onClose();
        } else if (!(this.getFocused() instanceof DrawableBlackBoardButton)) {
            this.setFocused(null);
        }
    }

    private boolean isValid() {
        return this.minecraft != null && this.minecraft.player != null && !this.tile.isRemoved() && !this.tile.isEditingPlayer((Player)this.minecraft.player);
    }

    public byte getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(byte color) {
        this.selectedColor = color;
    }

    public void onClose() {
        this.tile.setChanged();
        super.onClose();
    }

    public void removed() {
        byte[][] pixels = new byte[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].getColor();
            }
        }
        NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundSetBlackboardPacket(this.tile.getBlockPos(), pixels));
    }

    public void updateBlackboard(int x, int y, byte newColor) {
        this.tile.setPixel(x, y, newColor);
    }

    public void addHistory(int x, int y, byte oldColor) {
        this.currentHistoryStep.add(new Entry(x, y, oldColor));
    }

    public void saveHistoryStep() {
        if (!this.currentHistoryStep.isEmpty()) {
            this.history.add(this.currentHistoryStep);
            this.currentHistoryStep = new ArrayList<Entry>();
            this.historyButton.active = true;
        }
    }

    public void onButtonDragged(double mx, double my, byte buttonValue) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                DrawableBlackBoardButton b = this.buttons[xx][yy];
                if (!b.isMouseOver(mx, my) || b.getColor() == buttonValue) continue;
                b.setColor(buttonValue);
            }
        }
    }

    private void clearPressed(Button button) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy].setColor((byte)0);
            }
        }
        this.saveHistoryStep();
    }

    private void undoPressed(Button button) {
        if (!this.history.isEmpty()) {
            for (Entry v : this.history.pollLast()) {
                this.buttons[v.x()][v.y()].setColor(v.color());
            }
            this.currentHistoryStep.clear();
        }
        if (this.history.isEmpty()) {
            this.historyButton.active = false;
        }
    }

    protected void init() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                byte pixel = this.tile.getPixel(xx, yy);
                DrawableBlackBoardButton widget = new DrawableBlackBoardButton(this, this.width / 2, 65, xx, yy, pixel);
                this.buttons[xx][yy] = (DrawableBlackBoardButton)this.addRenderableWidget(widget);
            }
        }
        int buttonW = 56;
        int sep = 4;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CLEAR, this::clearPressed).bounds(this.width / 2 - buttonW / 2 - buttonW + sep / 2, this.height / 4 + 120, buttonW - sep, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - buttonW / 2 + sep / 2, this.height / 4 + 120, buttonW - sep, 20).build());
        this.historyButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)UNDO, this::undoPressed).bounds(this.width / 2 + buttonW / 2 + sep / 2, this.height / 4 + 120, buttonW - sep, 20).build());
        if (CommonConfigs.Building.BLACKBOARD_COLOR.get().booleanValue() || PlatHelper.isDev()) {
            for (byte b = 0; b < DyeColor.values().length; b = (byte)(b + 1)) {
                int ox = b / 8;
                int oy = b % 8;
                this.addRenderableWidget(new DyeBlackBoardButton(this, this.width / 2 - 64 + -ox * 10 - ox * 2, 67 + oy * 10 + oy * 2, b));
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        if (CompatHandler.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.startBatching();
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.pose().pushPose();
        block0: for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                DrawableBlackBoardButton button = this.buttons[xx][yy];
                if (!button.isShouldDrawOverlay()) continue;
                button.renderHoverOverlay(graphics);
                break block0;
            }
        }
        graphics.pose().popPose();
        if (CompatHandler.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.endBatching();
        }
    }

    private record Entry(int x, int y, byte color) {
    }
}

