/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobeBlock
extends WaterBlock
implements EntityBlock,
IWashable {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty ROTATION = ModBlockProperties.ROTATION_4;

    public GlobeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static void displayCurrentCoordinates(Level level, Player player, BlockPos pos) {
        Object x = String.valueOf(pos.getX());
        Object z = String.valueOf(pos.getZ());
        if (!level.dimensionType().natural()) {
            x = String.valueOf(ChatFormatting.OBFUSCATED) + (String)x + String.valueOf(ChatFormatting.RESET);
            z = String.valueOf(ChatFormatting.OBFUSCATED) + (String)z + String.valueOf(ChatFormatting.RESET);
        }
        player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.compass", (Object[])new Object[]{x, z}), true);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        this.updatePower(state, worldIn, pos);
        if (stack.has(DataComponents.CUSTOM_NAME) && (blockEntity = worldIn.getBlockEntity(pos)) instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            tile.setCustomName(stack.getHoverName());
        }
    }

    public void updatePower(BlockState state, Level leve, BlockPos pos) {
        boolean powered;
        boolean bl = powered = leve.getBestNeighborSignal(pos) > 0;
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            leve.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 4);
            if (powered) {
                leve.gameEvent(null, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
                leve.blockEvent(pos, state.getBlock(), 1, 0);
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        GlobeBlockTile tile;
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GlobeBlockTile && (tile = (GlobeBlockTile)blockEntity).hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)tile.getCustomName());
        }
        return stack;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            if (!level.isClientSide) {
                if (tile.isSpinningVeryFast() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Utils.awardAdvancement((ServerPlayer)serverPlayer, (ResourceLocation)Supplementaries.res("adventure/globe"));
                }
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
                level.blockEvent(pos, state.getBlock(), 1, 0);
            } else if (ClientConfigs.Blocks.GLOBE_COORDINATES.get().booleanValue()) {
                GlobeBlock.displayCurrentCoordinates(level, player, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (stack.getItem() instanceof ShearsItem && (blockEntity = level.getBlockEntity(pos)) instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            tile.toggleShearing();
            tile.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
            level.playSound(player, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                level.blockEvent(pos, state.getBlock(), 2, 0);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (MiscUtils.FESTIVITY.isEarthDay() && level.isClientSide) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            for (int l = 0; l < 1; ++l) {
                double d0 = (double)x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.625;
                double d1 = (double)y + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.625;
                double d2 = (double)z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.625;
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(state, world, pos, neighborBlock, fromPos, moving);
        this.updatePower(state, world, pos);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !this.canSurvive(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return GlobeBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, POWERED, ROTATION});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new GlobeBlockTile(pPos, pState);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity tile = world.getBlockEntity(pos);
        return tile != null && tile.triggerEvent(eventID, eventParam);
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GlobeBlockTile) {
            GlobeBlockTile tile = (GlobeBlockTile)blockEntity;
            return tile.getSignalPower();
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.GLOBE_TILE.get(), GlobeBlockTile::tick);
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        GlobeBlockTile tile;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GlobeBlockTile && (tile = (GlobeBlockTile)blockEntity).isSepia()) {
            level.setBlockAndUpdate(pos, ModRegistry.GLOBE.get().withPropertiesOf(state));
            return true;
        }
        return false;
    }
}

