/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RelayerBlock
extends DirectionalBlock {
    private static final MapCodec<RelayerBlock> CODEC = RelayerBlock.simpleCodec(RelayerBlock::new);
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public RelayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER, POWERED, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction dir = context.getNearestLookingDirection();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir);
        int p = this.getSignalInFront(context.getLevel(), context.getClickedPos(), dir);
        state = (BlockState)((BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(p))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(p != 0));
        return state;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.isClientSide) {
            this.updatePowerNextTick(state, worldIn, pos);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        this.updatePowerNextTick(state, level, pos);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide() && isMoving) {
            this.updatePowerNextTick(state, level, pos);
        }
    }

    private void updatePowerNextTick(BlockState state, Level level, BlockPos pos) {
        if (!level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    private int getSignalInFront(Level level, BlockPos pos, Direction dir) {
        BlockPos behind = pos.relative(dir);
        int pow = level.getSignal(behind, dir);
        BlockState b = level.getBlockState(behind);
        if (b.getBlock() instanceof RedStoneWireBlock) {
            pow = Math.max((Integer)b.getValue((Property)RedStoneWireBlock.POWER), pow);
        } else if (b.getBlock() instanceof DiodeBlock) {
            pow = Math.max(b.getSignal((BlockGetter)level, behind, (Direction)b.getValue((Property)DiodeBlock.FACING)), pow);
        } else if (b.is((Block)this)) {
            pow = Math.max((Integer)b.getValue((Property)POWER), pow);
        }
        return pow;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        Direction front = (Direction)state.getValue((Property)FACING);
        Direction back = front.getOpposite();
        int pow = this.getSignalInFront((Level)level, pos, front);
        level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(pow != 0))).setValue((Property)POWER, (Comparable)Integer.valueOf(Mth.clamp((int)pow, (int)0, (int)15))), 7);
        BlockPos blockPos = pos.relative(back);
        level.neighborChanged(blockPos, (Block)this, pos);
        level.updateNeighborsAtExceptFromFacing(blockPos, (Block)this, front);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.getSignal(level, pos, direction);
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && state.getValue((Property)FACING) == direction) {
            return (Integer)state.getValue((Property)POWER);
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        if (direction == null) {
            return false;
        }
        return direction == state.getValue((Property)ObserverBlock.FACING);
    }
}

