/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherArmBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpringLauncherArmBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpringLauncherHeadBlock
extends DirectionalBlock {
    public static final MapCodec<SpringLauncherHeadBlock> CODEC = SpringLauncherHeadBlock.simpleCodec(SpringLauncherHeadBlock::new);
    protected static final VoxelShape PISTON_EXTENSION_EAST_AABB = Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape PISTON_EXTENSION_UP_AABB = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_EXTENSION_DOWN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape UP_ARM_AABB = Block.box((double)1.0, (double)-4.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    protected static final VoxelShape DOWN_ARM_AABB = Block.box((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)20.0, (double)15.0);
    protected static final VoxelShape SOUTH_ARM_AABB = Block.box((double)1.0, (double)1.0, (double)-4.0, (double)15.0, (double)15.0, (double)12.0);
    protected static final VoxelShape NORTH_ARM_AABB = Block.box((double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0, (double)20.0);
    protected static final VoxelShape EAST_ARM_AABB = Block.box((double)-4.0, (double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0);
    protected static final VoxelShape WEST_ARM_AABB = Block.box((double)4.0, (double)1.0, (double)1.0, (double)20.0, (double)15.0, (double)15.0);
    protected static final VoxelShape SHORT_UP_ARM_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    protected static final VoxelShape SHORT_DOWN_ARM_AABB = Block.box((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHORT_SOUTH_ARM_AABB = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)12.0);
    protected static final VoxelShape SHORT_NORTH_ARM_AABB = Block.box((double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0, (double)16.0);
    protected static final VoxelShape SHORT_EAST_ARM_AABB = Block.box((double)0.0, (double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0);
    protected static final VoxelShape SHORT_WEST_ARM_AABB = Block.box((double)4.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape[] EXTENDED_SHAPES = SpringLauncherHeadBlock.getShapesForExtension(true);
    private static final VoxelShape[] UNEXTENDED_SHAPES = SpringLauncherHeadBlock.getShapesForExtension(false);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty SHORT = BlockStateProperties.SHORT;

    public SpringLauncherHeadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SHORT, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends SpringLauncherHeadBlock> codec() {
        return CODEC;
    }

    private static VoxelShape[] getShapesForExtension(boolean extended) {
        return (VoxelShape[])Arrays.stream(Direction.values()).map(direction -> SpringLauncherHeadBlock.getShapeForDirection(direction, extended)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape getShapeForDirection(Direction direction, boolean shortArm) {
        return switch (direction) {
            case Direction.UP -> Shapes.or((VoxelShape)PISTON_EXTENSION_UP_AABB, (VoxelShape)(shortArm ? SHORT_UP_ARM_AABB : UP_ARM_AABB));
            case Direction.NORTH -> Shapes.or((VoxelShape)PISTON_EXTENSION_NORTH_AABB, (VoxelShape)(shortArm ? SHORT_NORTH_ARM_AABB : NORTH_ARM_AABB));
            case Direction.SOUTH -> Shapes.or((VoxelShape)PISTON_EXTENSION_SOUTH_AABB, (VoxelShape)(shortArm ? SHORT_SOUTH_ARM_AABB : SOUTH_ARM_AABB));
            case Direction.WEST -> Shapes.or((VoxelShape)PISTON_EXTENSION_WEST_AABB, (VoxelShape)(shortArm ? SHORT_WEST_ARM_AABB : WEST_ARM_AABB));
            case Direction.EAST -> Shapes.or((VoxelShape)PISTON_EXTENSION_EAST_AABB, (VoxelShape)(shortArm ? SHORT_EAST_ARM_AABB : EAST_ARM_AABB));
            default -> Shapes.or((VoxelShape)PISTON_EXTENSION_DOWN_AABB, (VoxelShape)(shortArm ? SHORT_DOWN_ARM_AABB : DOWN_ARM_AABB));
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((Boolean)state.getValue((Property)SHORT) != false ? EXTENDED_SHAPES : UNEXTENDED_SHAPES)[((Direction)state.getValue((Property)FACING)).ordinal()];
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.isSuppressingBounce() || state.getValue((Property)FACING) != Direction.UP) {
            super.fallOn(level, state, pos, entityIn, fallDistance);
        } else {
            entityIn.causeFallDamage(fallDistance, 0.0f, level.damageSources().fall());
            if (entityIn instanceof LivingEntity && !level.isClientSide && fallDistance > (float)CommonConfigs.Redstone.LAUNCHER_HEIGHT.get().intValue()) {
                BlockState state1 = ModRegistry.SPRING_LAUNCHER_ARM.get().defaultBlockState();
                level.setBlock(pos, (BlockState)((BlockState)state1.setValue((Property)SpringLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof SpringLauncherArmBlockTile) {
                    SpringLauncherArmBlockTile tile = (SpringLauncherArmBlockTile)blockEntity;
                    tile.retractOnFallOn();
                }
            }
        }
    }

    private void bounceEntity(Entity entity) {
        Vec3 vector3d = entity.getDeltaMovement();
        if (vector3d.y < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vector3d.x, -vector3d.y * d0, vector3d.z);
        }
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHORT});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModRegistry.SPRING_LAUNCHER.get());
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        Block block;
        if (!worldIn.isClientSide && player.getAbilities().instabuild && (block = worldIn.getBlockState(blockpos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())).getBlock()) instanceof SpringLauncherBlock) {
            worldIn.removeBlock(blockpos, false);
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockState comp = (BlockState)((BlockState)ModRegistry.SPRING_LAUNCHER_ARM.get().defaultBlockState().setValue((Property)SpringLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        if (state.getBlock() != newState.getBlock() && newState != comp) {
            super.onRemove(state, worldIn, pos, newState, isMoving);
            Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
            pos = pos.relative(direction);
            BlockState blockstate = worldIn.getBlockState(pos);
            if (blockstate.getBlock() instanceof SpringLauncherBlock && ((Boolean)blockstate.getValue((Property)BlockStateProperties.EXTENDED)).booleanValue()) {
                SpringLauncherHeadBlock.dropResources((BlockState)blockstate, (Level)worldIn, (BlockPos)pos);
                worldIn.removeBlock(pos, false);
            }
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.getOpposite() == stateIn.getValue((Property)FACING) && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState bs = worldIn.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        return bs == ((BlockState)ModRegistry.SPRING_LAUNCHER.get().defaultBlockState().setValue((Property)BlockStateProperties.EXTENDED, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.canSurvive((LevelReader)worldIn, pos)) {
            BlockPos blockpos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            worldIn.getBlockState(blockpos).handleNeighborChanged(worldIn, blockpos, blockIn, fromPos, false);
        }
    }
}

