/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GlobeBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobeBlockTile
extends BlockEntity
implements Nameable {
    private static final Pair<GlobeManager.Model, @Nullable ResourceLocation> DEFAULT_DATA = Pair.of((Object)((Object)GlobeManager.Model.GLOBE), null);
    private final boolean sepia;
    private boolean sheared = false;
    private Component customName = null;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private Pair<GlobeManager.Model, @Nullable ResourceLocation> renderData = DEFAULT_DATA;

    public GlobeBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.GLOBE_TILE.get(), pos, state);
        this.sepia = state.is(ModRegistry.GLOBE_SEPIA.get());
    }

    public int getFaceRot() {
        return (3 - (Integer)this.getBlockState().getValue((Property)GlobeBlock.ROTATION)) * 90;
    }

    public float getRotation(float partialTicks) {
        int face = this.getFaceRot();
        return Mth.lerp((float)partialTicks, (float)(this.prevYaw + (float)face), (float)(this.yaw + (float)face));
    }

    @NotNull
    public Pair<GlobeManager.Model, ResourceLocation> getRenderData() {
        return this.renderData;
    }

    public boolean isSepia() {
        return this.sepia;
    }

    public void setCustomName(Component name) {
        this.customName = name;
        this.updateRenderData();
    }

    public void toggleShearing() {
        this.sheared = !this.sheared;
        this.updateRenderData();
    }

    private void updateRenderData() {
        Pair<GlobeManager.Model, ResourceLocation> customData;
        this.renderData = this.sheared ? Pair.of((Object)((Object)GlobeManager.Model.SHEARED), (Object)(this.sepia ? ModTextures.GLOBE_SHEARED_SEPIA_TEXTURE : ModTextures.GLOBE_SHEARED_TEXTURE)) : (this.hasCustomName() ? ((customData = GlobeManager.getModelAndTexture(this.getCustomName().getString())) != null ? customData : DEFAULT_DATA) : DEFAULT_DATA);
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getCustomName() {
        return this.customName;
    }

    public Component getDefaultName() {
        return Component.translatable((String)"block.supplementaries.globe");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("CustomName", 8)) {
            this.setCustomName((Component)Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)registries));
        }
        this.yaw = tag.getFloat("Yaw");
        this.sheared = tag.getBoolean("Sheared");
        if (this.level != null && this.level.isClientSide) {
            this.updateRenderData();
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
        tag.putFloat("Yaw", this.yaw);
        tag.putBoolean("Sheared", this.sheared);
    }

    public void spin() {
        int spin = 360;
        int inc = 90;
        int face = (this.getFaceRot() - inc + 360) % 360;
        this.yaw = this.yaw + (float)spin + (float)inc;
        this.prevYaw = this.prevYaw + (float)spin + (float)inc;
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)GlobeBlock.ROTATION, (Comparable)Integer.valueOf(3 - face / 90)));
        this.setChanged();
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.spin();
            this.level.playSound(null, this.worldPosition, ModSounds.GLOBE_SPIN.get(), SoundSource.BLOCKS, 0.65f, MthUtils.nextWeighted((RandomSource)this.level.random, (float)0.2f) + 0.9f);
            return true;
        }
        if (id == 2) {
            this.level.addDestroyBlockEffect(this.worldPosition, this.getBlockState());
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, GlobeBlockTile tile) {
        tile.prevYaw = tile.yaw;
        if (tile.yaw != 0.0f) {
            if (tile.yaw < 0.0f) {
                tile.yaw = 0.0f;
                pLevel.updateNeighbourForOutputSignal(pPos, pState.getBlock());
            } else {
                tile.yaw = tile.yaw * 0.94f - 0.7f;
            }
        }
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)GlobeBlock.FACING);
    }

    public boolean isSpinningVeryFast() {
        return this.yaw > 1500.0f;
    }

    public int getSignalPower() {
        if (this.yaw != 0.0f) {
            return 15;
        }
        return this.getFaceRot() / 90 + 1;
    }
}

