/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PresentItemListing(ModItemListing original) implements ModItemListing
{
    public static final MapCodec<PresentItemListing> CODEC = ModItemListing.CODEC.xmap(PresentItemListing::new, w -> w.original).fieldOf("trade");

    public MerchantOffer getOffer(Entity entity, RandomSource random) {
        MerchantOffer originalOffer = this.original.getOffer(entity, random);
        if (MiscUtils.FESTIVITY.isChristmas()) {
            Block randomPresent = ModRegistry.PRESENTS.get(DyeColor.values()[random.nextInt(DyeColor.values().length)]).get();
            PresentBlockTile dummyTile = new PresentBlockTile(BlockPos.ZERO, randomPresent.defaultBlockState());
            if (originalOffer == null) {
                return null;
            }
            dummyTile.setItem(0, originalOffer.getResult());
            dummyTile.setSender(entity.getName().getString());
            dummyTile.setPublic();
            ItemStack stack = BlockUtil.saveTileToItem((BlockEntity)dummyTile);
            Optional<ItemCost> costB = Optional.ofNullable(this.itemCost(originalOffer.getCostB()));
            return new MerchantOffer(this.itemCost(originalOffer.getBaseCostA()), costB, stack, originalOffer.getUses(), originalOffer.getMaxUses(), originalOffer.getXp(), originalOffer.getPriceMultiplier(), originalOffer.getDemand());
        }
        return originalOffer;
    }

    private ItemCost itemCost(ItemStack baseCostA) {
        return baseCostA.isEmpty() ? null : new ItemCost((ItemLike)baseCostA.getItem(), baseCostA.getCount());
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    public int getLevel() {
        return this.original.getLevel();
    }

    public boolean isValid() {
        return this.original.isValid();
    }
}

