/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.renderers.CapturedMobCache;
import net.mehvahdjukaar.supplementaries.client.screens.ConfigButton;
import net.mehvahdjukaar.supplementaries.client.screens.WelcomeMessageScreen;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.network.SyncEquippedQuiverPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncPartyCreeperPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ClientEvents {
    protected static final MutableComponent PLACEABLE_TOOLTIP = Component.translatable((String)"message.supplementaries.placeable").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC);
    private static String lastAppliedShader = null;
    private static final Supplier<Map<Item, String>> EFFECTS_PER_ITEM = Suppliers.memoize(() -> {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        map.put((Object)Items.CREEPER_HEAD, (Object)"minecraft:shaders/post/creeper.json");
        map.put((Object)Items.SKELETON_SKULL, (Object)ClientRegistry.BLACK_AND_WHITE_SHADER.toString());
        map.put((Object)Items.WITHER_SKELETON_SKULL, (Object)ClientRegistry.BLACK_AND_WHITE_SHADER.toString());
        map.put((Object)Items.ZOMBIE_HEAD, (Object)ClientRegistry.DESATURATE_SHADER.toString());
        map.put((Object)Items.DRAGON_HEAD, (Object)ClientRegistry.FLARE_SHADER.toString());
        map.put((Object)Items.PIGLIN_HEAD, (Object)ClientRegistry.GLITTER_SHADER.toString());
        map.put((Object)ModRegistry.CAGE_ITEM.get(), (Object)ClientRegistry.RAGE_SHADER.toString());
        map.put((Object)ModRegistry.ENDERMAN_SKULL_ITEM.get(), (Object)"minecraft:shaders/post/invert.json");
        return map;
    });
    private static final Supplier<Set<String>> MY_SHADERS = Suppliers.memoize(() -> EFFECTS_PER_ITEM.get().values().stream().collect(Collectors.toUnmodifiableSet()));
    private static boolean isOnRope;

    public static void onItemTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipFlag tooltipFlag, List<Component> components) {
        Item item;
        if (ClientConfigs.General.TOOLTIP_HINTS.get().booleanValue()) {
            InteractEventsHandler.addOverrideTooltips(itemStack, tooltipFlag, components);
        }
        if (ClientConfigs.General.PLACEABLE_TOOLTIP.get().booleanValue() && AdditionalItemPlacementsAPI.getBehavior((Item)itemStack.getItem()) instanceof SuppAdditionalPlacement) {
            components.add((Component)PLACEABLE_TOOLTIP);
        }
        if ((item = itemStack.getItem()) == ModRegistry.ROPE_ARROW_ITEM.get() || item == ModRegistry.BUBBLE_BLOWER.get()) {
            Optional<Component> r = components.stream().filter(t -> {
                TranslatableContents tc;
                ComponentContents patt0$temp = t.getContents();
                return patt0$temp instanceof TranslatableContents && (tc = (TranslatableContents)patt0$temp).getKey().equals("item.durability");
            }).findFirst();
            r.ifPresent(components::remove);
        }
    }

    public static void addConfigButton(Screen screen, List<? extends GuiEventListener> listeners, Consumer<GuiEventListener> adder) {
        if (ClientConfigs.General.CONFIG_BUTTON.get().booleanValue()) {
            ConfigButton.setupConfigButton(screen, listeners, adder);
        }
    }

    public static void onFirstScreen(Screen screen) {
        Screen newScreen = screen;
        if (CompatHandler.OPTIFINE) {
            boolean disabled = ClientConfigs.General.NO_OPTIFINE_WARN.get();
            Random random = new Random();
            if (random.nextFloat() < 0.05f) {
                SuppPlatformStuff.disableOFWarn(false);
                boolean bl = disabled = !disabled;
            }
            if (!disabled) {
                newScreen = WelcomeMessageScreen.createOptifine(newScreen);
            }
        }
        if (!CompatHandler.AMENDMENTS && !ClientConfigs.General.NO_AMENDMENTS_WARN.get().booleanValue()) {
            newScreen = WelcomeMessageScreen.createAmendments(newScreen);
        }
        if (!ClientConfigs.General.NO_INCOMPATIBLE_MODS.get().booleanValue() && WelcomeMessageScreen.hasIncompat() && !PlatHelper.isDev()) {
            newScreen = WelcomeMessageScreen.createIncompatibleMods(newScreen);
        }
        if (newScreen != screen) {
            Minecraft.getInstance().setScreen(newScreen);
        }
    }

    public static void onClientTick(Minecraft minecraft) {
        if (minecraft.isPaused() || minecraft.level == null) {
            return;
        }
        CapturedMobCache.tickCrystal();
        LocalPlayer p = minecraft.player;
        if (p == null) {
            return;
        }
        ClientEvents.checkIfOnRope((Player)p);
        ClientEvents.applyMobHeadShaders((Player)p, minecraft);
        CannonController.onClientTick(minecraft);
    }

    private static void applyMobHeadShaders(Player p, Minecraft mc) {
        if (ClientConfigs.Tweaks.MOB_HEAD_EFFECTS.get().booleanValue()) {
            String rendererShader;
            GameRenderer renderer = Minecraft.getInstance().gameRenderer;
            String string = rendererShader = renderer.postEffect == null ? null : renderer.postEffect.getName();
            if (rendererShader != null && !MY_SHADERS.get().contains(rendererShader)) {
                return;
            }
            if (p.isSpectator()) {
                if (rendererShader != null && lastAppliedShader != null) {
                    renderer.shutdownEffect();
                    lastAppliedShader = null;
                }
                return;
            }
            if (rendererShader == null && lastAppliedShader != null) {
                lastAppliedShader = null;
            }
            ItemStack stack = p.getItemBySlot(EquipmentSlot.HEAD);
            if (CompatHandler.QUARK && QuarkCompat.shouldHideOverlay(stack)) {
                return;
            }
            Item item = stack.getItem();
            String newShader = mc.options.getCameraType() == CameraType.FIRST_PERSON ? EFFECTS_PER_ITEM.get().get(item) : null;
            if (newShader == null && ClientEvents.shouldHaveGoatedEffect(p, item)) {
                newShader = ClientRegistry.BARBARIC_RAGE_SHADER;
            }
            if (!(newShader == null || newShader.equals(rendererShader) && renderer.effectActive)) {
                renderer.loadEffect(ResourceLocation.tryParse((String)newShader));
                lastAppliedShader = newShader;
            } else if (rendererShader != null && newShader == null) {
                renderer.shutdownEffect();
                lastAppliedShader = null;
            }
        }
    }

    private static boolean shouldHaveGoatedEffect(Player p, Item item) {
        return CompatHandler.GOATED && item == CompatObjects.BARBARIC_HELMET.get() && p.getHealth() < 5.0f;
    }

    public static boolean isIsOnRope() {
        return isOnRope;
    }

    private static void checkIfOnRope(Player p) {
        AbstractRopeBlock rb;
        Block block;
        BlockState state = p.getBlockStateOn();
        isOnRope = (p.getX() != p.xOld || p.getZ() != p.zOld) && (block = state.getBlock()) instanceof AbstractRopeBlock && !(rb = (AbstractRopeBlock)block).hasConnection(Direction.UP, state) && (p.getY() + 500.0) % 1.0 >= AbstractRopeBlock.COLLISION_SHAPE.max(Direction.Axis.Y);
    }

    public static void onEntityLoad(Entity entity, Level clientLevel) {
        if (entity instanceof AbstractSkeleton && entity instanceof IQuiverEntity) {
            IQuiverEntity q = (IQuiverEntity)entity;
            NetworkHelper.sendToServer((CustomPacketPayload)new SyncEquippedQuiverPacket(entity, q));
        }
        if (entity instanceof IPartyCreeper && entity instanceof Creeper) {
            Creeper c = (Creeper)entity;
            NetworkHelper.sendToServer((CustomPacketPayload)new SyncPartyCreeperPacket((LivingEntity)c));
        }
    }

    public static void onExplosion(Explosion explosion) {
    }
}

