/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.api;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface ICatchableMob {
    public static final ICatchableMob DEFAULT = new ICatchableMob(){};

    default public boolean canBeCaughtWithItem(Entity self, Item item, Player player) {
        if (item instanceof AbstractMobContainerItem) {
            Slime slime;
            AbstractMobContainerItem containerItem = (AbstractMobContainerItem)item;
            if (self instanceof Slime && (slime = (Slime)self).getSize() != 1) {
                return false;
            }
            return containerItem.canItemCatch(self);
        }
        return false;
    }

    default public int getLightLevel(Level world, BlockPos pos) {
        return 0;
    }

    default public void onCaptured(Entity entity, Player player, ItemStack stack) {
    }

    default public float getHitBoxWidthIncrement(Entity self) {
        return 0.0f;
    }

    default public float getHitBoxHeightIncrement(Entity self) {
        return 0.0f;
    }

    default public boolean shouldHover(Entity self, boolean waterlogged) {
        return self.isNoGravity() || self instanceof FlyingAnimal || self.isIgnoringBlockTriggers() || self instanceof WaterAnimal;
    }

    default public Optional<Holder<SoftFluid>> getForceFluid() {
        return Optional.empty();
    }

    default public int getFishTextureIndex() {
        return 0;
    }

    default public boolean renderAs2DFish() {
        return this.getFishTextureIndex() != 0;
    }

    default public <T extends Entity> CapturedMobInstance<T> createCapturedMobInstance(T self, float containerWidth, float containerHeight) {
        return new CapturedMobInstance<T>(self);
    }
}

