/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.client.screens.BlackBoardScreen;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.BlackboardButton;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

public class DyeBlackBoardButton
extends BlackboardButton {
    public static final int SIZE = 10;

    public DyeBlackBoardButton(BlackBoardScreen screen, int x, int y, byte color) {
        super(screen, x, y, color, 10, ModTextures.BLACKBOARD_DYE_OUTLINE_SPRITE);
    }

    @Override
    protected void onClick() {
        this.parent.setSelectedColor(this.color);
    }

    @Override
    protected void renderButton(GuiGraphics graphics) {
        int rgb = this.color == 0 ? DyeColor.BLACK.getMapColor().col : BlackboardBlock.colorFromByte(this.color);
        float mul = this.shouldDrawOverlay ? 1.2f : 1.0f;
        float b = Mth.clamp((float)((float)FastColor.ARGB32.blue((int)rgb) / 255.0f * mul), (float)0.0f, (float)1.0f);
        float r = Mth.clamp((float)((float)FastColor.ARGB32.red((int)rgb) / 255.0f * mul), (float)0.0f, (float)1.0f);
        float g = Mth.clamp((float)((float)FastColor.ARGB32.green((int)rgb) / 255.0f * mul), (float)0.0f, (float)1.0f);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        graphics.blitSprite(ModTextures.BLACKBOARD_DYE_SPRITE, this.x, this.y, this.size, this.size);
        this.shouldDrawOverlay = this.parent.getSelectedColor() == this.color;
    }
}

