/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class SusRecipe
extends CustomRecipe {
    private final Ingredient ingredient;
    private final ItemStack result;

    public SusRecipe(CraftingBookCategory craftingBookCategory, Ingredient ingredient, ItemStack itemStack) {
        super(craftingBookCategory);
        this.ingredient = ingredient;
        this.result = itemStack;
    }

    public boolean matches(CraftingInput inv, Level level) {
        ItemStack gravel = null;
        ItemStack something = null;
        for (int i = 0; i < inv.size(); ++i) {
            BlockItem blockItem;
            Item item;
            ItemStack stack = inv.getItem(i);
            if (gravel == null && this.ingredient.test(stack)) {
                gravel = stack;
                continue;
            }
            if (stack.isEmpty()) continue;
            if (something != null) {
                return false;
            }
            if (stack.is(ModTags.SUSPICIOUS) || !MiscUtils.isAllowedInShulker(stack, level) || (item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof BrushableBlock) {
                return false;
            }
            something = stack;
        }
        return gravel != null && something != null;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack gravel = null;
        ItemStack something = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (gravel == null && this.ingredient.test(stack)) {
                gravel = stack;
                continue;
            }
            if (stack.isEmpty()) continue;
            something = stack;
        }
        ItemStack result = this.result.copyWithCount(1);
        result.applyComponents(gravel.getComponentsPatch());
        if (BlockEntityType.BRUSHABLE_BLOCK.isValid(((BlockItem)result.getItem()).getBlock().defaultBlockState())) {
            CompoundTag nbt = new CompoundTag();
            BlockEntity.addEntityType((CompoundTag)nbt, (BlockEntityType)BlockEntityType.BRUSHABLE_BLOCK);
            nbt.put("item", something.copyWithCount(1).saveOptional(provider));
            result.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbt));
        } else {
            result.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(List.of(something.copyWithCount(1))));
        }
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput recipeInput) {
        return NonNullList.withSize((int)recipeInput.size(), (Object)ItemStack.EMPTY);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.SUS_CRAFTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<SusRecipe> {
        public static final MapCodec<SusRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CustomRecipe::category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(arg -> arg.ingredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(arg -> arg.result)).apply((Applicative)i, SusRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SusRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CustomRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, i -> i.ingredient, (StreamCodec)ItemStack.STREAM_CODEC, i -> i.result, SusRecipe::new);

        public MapCodec<SusRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SusRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

