/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7079;
import org.jetbrains.annotations.Nullable;

public class RegistryCommand {
    private static final long PAGE_SIZE = 8L;
    private static final class_5321<class_2378<class_2378<?>>> ROOT_REGISTRY_KEY = class_5321.method_29180((class_2960)class_2960.method_60656((String)"root"));
    private static final DynamicCommandExceptionType UNKNOWN_REGISTRY = new DynamicCommandExceptionType(key -> class_2561.method_43469((String)"commands.supplementaries.registry.error.unknown_registry", (Object[])new Object[]{key.toString()}));

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"registry").requires(cs -> cs.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"registry", (ArgumentType)class_7079.method_41224(ROOT_REGISTRY_KEY)).suggests(RegistryCommand::suggestRegistries).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(ctx -> RegistryCommand.listElements((CommandContext<class_2168>)ctx, 1, null))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> RegistryCommand.listElements((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), null))))).then(class_2170.method_9247((String)"search").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"keyword", (ArgumentType)StringArgumentType.string()).executes(ctx -> RegistryCommand.listElements((CommandContext<class_2168>)ctx, 1, StringArgumentType.getString((CommandContext)ctx, (String)"keyword")))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> RegistryCommand.listElements((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), StringArgumentType.getString((CommandContext)ctx, (String)"keyword"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dump").requires(cs -> cs.method_9259(3))).then(class_2170.method_9244((String)"file_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String fileName = StringArgumentType.getString((CommandContext)ctx, (String)"file_name");
            return RegistryCommand.dumpRegistry((CommandContext<class_2168>)ctx, fileName);
        }))));
    }

    private static int dumpRegistry(CommandContext<class_2168> ctx, String fileName) throws CommandSyntaxException {
        class_5321<class_2378<?>> registryKey = RegistryCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        class_2168 source = (class_2168)ctx.getSource();
        class_2378 registry = (class_2378)source.method_9211().method_30611().method_33310(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.method_29177()));
        Path dir = PlatHelper.getGamePath().resolve("registry_dumps");
        if (!dir.toFile().exists()) {
            dir.toFile().mkdirs();
        }
        Path file = dir.resolve(fileName + ".txt");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file.toFile()));){
            for (Object entry : registry) {
                writer.write(entry.toString());
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(() -> "I/O error"), e::getMessage);
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.supplementaries.registry.dump.success", (Object[])new Object[]{file.toString()}), false);
        return 0;
    }

    private static int listElements(CommandContext<class_2168> ctx, int page, @Nullable String search) throws CommandSyntaxException {
        class_5321<class_2378<?>> registryKey = RegistryCommand.getResourceKey(ctx, "registry", ROOT_REGISTRY_KEY).orElseThrow();
        class_2168 source = (class_2168)ctx.getSource();
        class_2378 registry = (class_2378)source.method_9211().method_30611().method_33310(registryKey).orElseThrow(() -> UNKNOWN_REGISTRY.create((Object)registryKey.method_29177()));
        long elementCount = registry.method_10204();
        source.method_9226(() -> RegistryCommand.createMessage(class_2561.method_43469((String)"commands.supplementaries.registry.registry_key", (Object[])new Object[]{class_2561.method_43470((String)registryKey.method_29177().toString()).method_27692(class_124.field_1065)}), page, () -> registry.method_10235().stream().map(class_2960::toString), search), false);
        return (int)elementCount;
    }

    private static class_5250 createMessage(class_5250 header, long currentPage, Supplier<Stream<String>> names, @Nullable String search) {
        List<String> filtered = names.get().filter(s -> search == null || s.contains(search)).toList();
        long count = filtered.size();
        String allElementNames = filtered.stream().sorted().collect(Collectors.joining("\n"));
        long totalPages = (count - 1L) / 8L + 1L;
        long actualPage = (long)class_3532.method_15363((float)currentPage, (float)1.0f, (float)totalPages);
        class_5250 component = class_2561.method_43469((String)"commands.supplementaries.registry.elements_count", (Object[])new Object[]{count});
        if (count > 0L) {
            component = class_2564.method_10885((class_2561)component.method_27694(s -> s.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_21462, allElementNames)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"commands.supplementaries.registry.copy_elements_names")))));
            component = class_2561.method_43469((String)"commands.supplementaries.registry.page_info", (Object[])new Object[]{component, actualPage, totalPages});
        }
        class_5250 tagElements = class_2561.method_43470((String)"").method_10852((class_2561)component);
        Stream<class_5250> stream = filtered.stream().sorted().skip(8L * (actualPage - 1L)).limit(8L).map(class_2561::method_43470).map(t -> t.method_27692(class_124.field_1077)).map(t -> class_2561.method_43470((String)"\n - ").method_10852((class_2561)t));
        Objects.requireNonNull(tagElements);
        stream.forEach(arg_0 -> ((class_5250)tagElements).method_10852(arg_0));
        return header.method_27693("\n").method_10852((class_2561)tagElements);
    }

    private static CompletableFuture<Suggestions> suggestRegistries(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        Stream<String> strings = ((class_2168)ctx.getSource()).method_30497().method_40311().map(class_5455.class_6892::comp_350).map(class_5321::method_29177).map(class_2960::toString);
        Objects.requireNonNull(builder);
        strings.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static <T> Optional<class_5321<T>> getResourceKey(CommandContext<class_2168> ctx, String name, class_5321<class_2378<T>> registryKey) {
        class_5321 key = (class_5321)ctx.getArgument(name, class_5321.class);
        return key.method_39752(registryKey);
    }
}

