/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GunpowderBlock;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteLiquidBlock;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.SoulFiredCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6908;
import net.minecraft.class_7;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FlammableLiquidBlock
extends FiniteLiquidBlock
implements ILightable {
    public static final class_2758 AGE = class_2741.field_12498;
    public final class_265[] interactionShapes = (class_265[])IntStream.range(0, 16).mapToObj(i -> FlammableLiquidBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)Math.max(0.0f, 15.0f * (1.0f - (float)i / (float)this.maxLevel)), (double)16.0)).toArray(class_265[]::new);

    public FlammableLiquidBlock(Supplier<? extends FiniteFluid> supplier, class_4970.class_2251 arg, int baseLight) {
        super(supplier, arg.method_9631(state -> (Integer)state.method_11654((class_2769)AGE) > baseLight ? 15 : 0));
    }

    public int method_9505(class_2680 state, class_1922 level, class_2338 pos) {
        return 0;
    }

    @Override
    public boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return true;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AGE});
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return FireStage.fromAge((Integer)state.method_11654((class_2769)AGE)).isBurning() ? class_2464.field_11458 : class_2464.field_11455;
    }

    public void onCaughtFire(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2350 face, @Nullable class_1309 igniter) {
    }

    @Override
    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.method_9612(state, level, pos, block, fromPos, isMoving);
        if (level instanceof class_3218) {
            class_3218 sl = (class_3218)level;
            MiscUtils.scheduleTickOverridingExisting(sl, pos, this, this.getReactToFireDelay());
        }
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moving) {
        super.method_9615(state, world, pos, oldState, moving);
        if (!oldState.method_27852(state.method_26204()) && world instanceof class_3218) {
            class_3218 sl = (class_3218)world;
            MiscUtils.scheduleTickOverridingExisting(sl, pos, this, this.getReactToFireDelay());
        }
    }

    protected int getReactToFireDelay() {
        return 2;
    }

    protected int getFireTickDelay(class_5819 random) {
        return 30 + random.method_43048(10);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        return this.lightableInteractWithPlayerItem(state, level, pos, player, hand, stack);
    }

    public boolean tryLightUp(@Nullable class_1297 player, class_2680 state, class_2338 pos, class_1936 level, ILightable.FireSoundType fireSourceType) {
        if (FlammableLiquidBlock.shouldNotHaveFire(state, pos, level)) {
            return false;
        }
        boolean success = super.tryLightUp(player, state, pos, level, fireSourceType);
        if (success && level instanceof class_3218) {
            class_3218 sl = (class_3218)level;
            MiscUtils.scheduleTickOverridingExisting(sl, pos, this, this.getReactToFireDelay());
        }
        return success;
    }

    public static boolean shouldNotHaveFire(class_2680 state, class_2338 pos, class_1936 levelAccessor) {
        return levelAccessor.method_8316(pos.method_10084()).method_39360(state.method_26227().method_15772());
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        class_2680 newShape = super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
        if (this.isLitUp(state, (class_1922)level, currentPos) && FlammableLiquidBlock.shouldNotHaveFire(newShape, currentPos, level)) {
            return (class_2680)newShape.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0));
        }
        return newShape;
    }

    public boolean isLitUp(class_2680 state, class_1922 level, class_2338 pos) {
        return FireStage.fromAge((Integer)state.method_11654((class_2769)AGE)).isBurning();
    }

    public void setLitUp(class_2680 state, class_1936 world, class_2338 pos, @Nullable class_1297 e, boolean lit) {
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(lit ? 1 : 0)), 3);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.isLitUp(state, level, pos) ? this.interactionShapes[(Integer)state.method_11654((class_2769)MISSING_LEVELS)] : super.method_9530(state, level, pos, context);
    }

    public class_265 method_9584(class_2680 state, class_1922 level, class_2338 pos) {
        return this.interactionShapes[(Integer)state.method_11654((class_2769)MISSING_LEVELS)];
    }

    public void method_19286(class_1937 level, class_2680 state, class_3965 pHit, class_1676 projectile) {
        class_2338 pos = pHit.method_17777();
        this.lightableInteractWithEntity(level, state, (class_1297)projectile, pos);
    }

    public class_2680 method_9605(class_1750 context) {
        class_2680 state = this.method_9564();
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        boolean shouldBeOnFire = false;
        for (class_2350 direction : context.method_7718()) {
            if (!GunpowderBlock.canBlockLightMeOnFire((class_1936)level, pos.method_10093(direction))) continue;
            shouldBeOnFire = true;
            break;
        }
        return (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(shouldBeOnFire ? 1 : 0));
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1676) {
            class_1676 projectile = (class_1676)entity;
            this.lightableInteractWithEntity(level, state, (class_1297)projectile, pos);
        }
        if (this.isLitUp(state, (class_1922)level, pos)) {
            if (!entity.method_5753()) {
                if (CompatHandler.SOUL_FIRED) {
                    SoulFiredCompat.setOnFire(entity, 8);
                } else {
                    entity.method_20803(entity.method_20802() + 1);
                    if (entity.method_20802() == 0) {
                        entity.method_20803(8);
                    }
                }
            }
            entity.method_5643(level.method_48963().method_48794(), 1.0f);
        } else if (entity.method_5809()) {
            this.tryLightUp(entity, state, pos, (class_1936)level, ILightable.FireSoundType.FLAMING_ARROW);
        }
        Integer duration = CommonConfigs.Functional.FLAMMABLE_FROM_LUMISENE.get();
        if (entity instanceof class_1309) {
            class_1309 le = (class_1309)entity;
            if (duration > 0) {
                le.method_6092(new class_1293(ModRegistry.FLAMMABLE.getHolder(), duration.intValue(), 0, false, false));
            }
        }
        super.method_9548(state, level, pos, entity);
    }

    protected void method_33614(class_1937 level, class_1657 player, class_2338 pos, class_2680 state) {
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!level.method_8608() && this.isLitUp(state, (class_1922)level, pos)) {
            level.method_8444(null, 1009, pos, 0);
        }
        return super.method_9576(level, pos, state, player);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (!this.isLitUp(state, (class_1922)level, pos)) {
            return;
        }
        if (random.method_43048(24) == 0) {
            level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14993, class_3419.field_15245, 1.0f + random.method_43057(), random.method_43057() * 0.7f + 0.3f, false);
        }
        int age = (Integer)state.method_11654((class_2769)AGE);
        double baseY = (float)Math.max((age + 1) / 5, 1) * 0.5f;
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.method_10263() + random.method_43058();
            double y = (double)pos.method_10264() + random.method_43058() * 0.25 + baseY;
            double z = (double)pos.method_10260() + random.method_43058();
            level.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 0.0, 0.0);
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (!SuppPlatformStuff.canCatchFire(level, pos.method_10093(direction), direction)) continue;
            for (int i = 0; i < 2; ++i) {
                Vector3f step = direction.method_23955();
                double x = (double)pos.method_10263() + 0.5 + (double)step.x * 0.5 + (step.x == 0.0f ? random.method_43058() - 0.5 : (double)(-step.x) * random.method_43058() * 0.1);
                double y = (double)pos.method_10264() + 0.5 + (double)step.y * 0.5 + (step.y == 0.0f ? random.method_43058() - 0.5 : (double)(-step.y) * random.method_43058() * 0.1);
                double z = (double)pos.method_10260() + 0.5 + (double)step.z * 0.5 + (step.z == 0.0f ? random.method_43058() - 0.5 : (double)(-step.z) * random.method_43058() * 0.1);
                level.method_8406((class_2394)class_2398.field_11237, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        FireStage stage = FireStage.fromAge(age);
        boolean fireTickOn = level.method_8450().method_8355(class_1928.field_19387);
        if (stage == FireStage.OFF) {
            for (class_2350 dir : class_2350.values()) {
                if (dir == class_2350.field_11033 || !GunpowderBlock.canBlockLightMeOnFire((class_1936)level, pos.method_10093(dir))) continue;
                this.tryLightUp(null, state, pos, (class_1936)level, ILightable.FireSoundType.FLAMING_ARROW);
                return;
            }
            return;
        }
        if (stage == FireStage.RISING) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
            MiscUtils.scheduleTickOverridingExisting(level, pos, this, this.getReactToFireDelay());
            return;
        }
        if (stage == FireStage.DYING) {
            int missingLayers = (Integer)state.method_11654((class_2769)MISSING_LEVELS);
            if (missingLayers == 15) {
                level.method_8501(pos, class_2246.field_10124.method_9564());
                if (SuppPlatformStuff.canCatchFire((class_1937)level, pos.method_10074(), class_2350.field_11036) && fireTickOn) {
                    int newAge = random.method_43048(8);
                    level.method_8652(pos, FlammableLiquidBlock.getFireDelegate().method_24855((class_1936)level, pos, newAge), 3);
                }
                return;
            }
            level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)MISSING_LEVELS, (Comparable)Integer.valueOf(missingLayers + 1))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(4)));
            level.method_39279(pos, (class_2248)this, this.getFireTickDelay(level.field_9229));
            return;
        }
        if (stage == FireStage.RAGING && fireTickOn) {
            level.method_39279(pos, (class_2248)this, this.getFireTickDelay(level.field_9229));
            int ageAdd = random.method_43048(3) / 2;
            int ageIncrease = Math.min(15, age + ageAdd);
            if (age != ageIncrease) {
                state = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(ageIncrease));
                level.method_8652(pos, state, 4);
            }
            FlammableLiquidBlock.burnStuffAroundLikeFire(state, level, pos, random, age);
        }
    }

    public int getFireSpreadSpeed(class_2680 state, class_1922 level, class_2338 pos, class_2350 direction) {
        return this.isLitUp(state, level, pos) ? 0 : 60;
    }

    private static void burnStuffAroundLikeFire(class_2680 state, class_3218 level, class_2338 pos, class_5819 random, int age) {
        boolean increaseFireBurnout = level.method_23753(pos).method_40220(class_6908.field_41752);
        int extraChance = increaseFireBurnout ? -50 : 0;
        SuppPlatformStuff.tryBurningByFire(level, pos.method_10078(), 300 + extraChance, random, age, class_2350.field_11039);
        SuppPlatformStuff.tryBurningByFire(level, pos.method_10067(), 300 + extraChance, random, age, class_2350.field_11034);
        SuppPlatformStuff.tryBurningByFire(level, pos.method_10084(), 250 + extraChance, random, age, class_2350.field_11033);
        SuppPlatformStuff.tryBurningByFire(level, pos.method_10095(), 300 + extraChance, random, age, class_2350.field_11035);
        SuppPlatformStuff.tryBurningByFire(level, pos.method_10072(), 300 + extraChance, random, age, class_2350.field_11043);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 4; ++dy) {
                    class_2248 class_22482;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    int chance = 100;
                    if (dy > 1) {
                        chance += (dy - 1) * 100;
                    }
                    mutableBlockPos.method_25504((class_2382)pos, dx, dy, dz);
                    class_2358 fireBlock = FlammableLiquidBlock.getFireDelegate();
                    int igniteOdds = fireBlock.method_10194((class_4538)level, (class_2338)mutableBlockPos);
                    boolean isLumisene = false;
                    if (igniteOdds == 0 && (dy != 0 || dx != 0 && dz != 0)) {
                        class_2680 nextState = level.method_8320(pos);
                        if (state.method_26204() instanceof FlammableLiquidBlock) {
                            igniteOdds = PlatHelper.getFireSpreadSpeed((class_2680)nextState, (class_1922)level, (class_2338)pos, (class_2350)class_2350.field_11036);
                            isLumisene = true;
                        }
                    }
                    if (igniteOdds <= 0) continue;
                    int i2 = (igniteOdds + 40 + level.method_8407().method_5461() * 7) / (age + 30);
                    if (increaseFireBurnout) {
                        i2 /= 2;
                    }
                    if (i2 <= 0 || random.method_43048(chance) > i2 || level.method_8419() && fireBlock.method_10192((class_1937)level, (class_2338)mutableBlockPos)) continue;
                    int newAge = Math.min(15, age + random.method_43048(5) / 4);
                    if (isLumisene && (class_22482 = level.method_8320(pos).method_26204()) instanceof FlammableLiquidBlock) {
                        FlammableLiquidBlock fl = (FlammableLiquidBlock)class_22482;
                        fl.tryLightUp(null, state, pos, (class_1936)level, ILightable.FireSoundType.FLAMING_ARROW);
                        continue;
                    }
                    level.method_8652((class_2338)mutableBlockPos, fireBlock.method_24855((class_1936)level, (class_2338)mutableBlockPos, newAge), 3);
                }
            }
        }
    }

    public class_7 getBlockPathType(class_2680 state, class_1922 level, class_2338 pos, @Nullable class_1308 mob) {
        if (this.isLitUp(state, level, pos)) {
            return class_7.field_3;
        }
        return null;
    }

    @Nullable
    public class_7 getAdjacentBlockPathType(class_2680 state, class_1922 level, class_2338 pos, @Nullable class_1308 mob, class_7 originalType) {
        if (this.isLitUp(state, level, pos)) {
            return class_7.field_3;
        }
        return null;
    }

    @NotNull
    private static class_2358 getFireDelegate() {
        return (class_2358)class_2246.field_10036;
    }

    public static enum FireStage {
        OFF,
        RISING,
        RAGING,
        DYING;


        public boolean isBurning() {
            return this != OFF;
        }

        public static FireStage fromAge(int age) {
            if (age == 0) {
                return OFF;
            }
            if (age == 15) {
                return DYING;
            }
            if (age < 4) {
                return RISING;
            }
            return RAGING;
        }
    }
}

