/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_markers;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.SliceMapItem;
import net.mehvahdjukaar.supplementaries.common.misc.ColoredMapHandler;
import net.mehvahdjukaar.supplementaries.common.misc.MapLightHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;

public class WeatheredMap {
    private static final String ANTIQUE_KEY = "antique";
    private static final CustomMapData.Type<WeatheredMapData> ANTIQUE_DATA_KEY;
    public static final class_3620 ANTIQUE_LIGHT;
    public static final class_3620 ANTIQUE_DARK;
    private static final Object2ObjectArrayMap<class_3620, class_3620> ANTIQUE_COLORS;

    public static void init() {
    }

    public static WeatheredMapData getAntiqueData(class_22 data) {
        return (WeatheredMapData)ANTIQUE_DATA_KEY.get(data);
    }

    public static void setAntique(class_1937 level, class_1799 stack, boolean on) {
        WeatheredMap.setAntique(level, stack, on, false);
    }

    public static void setAntique(class_1937 level, class_1799 stack, boolean on, boolean replaceOld) {
        class_22 mapitemsaveddata = class_1806.method_8001((class_1799)stack, (class_1937)level);
        Integer mapId = WeatheredMap.createAntiqueMapData(mapitemsaveddata, level, on, replaceOld);
        if (mapId != null) {
            stack.method_7948().method_10569("map", mapId.intValue());
        }
    }

    public static Integer createAntiqueMapData(class_22 mapitemsaveddata, class_1937 level, boolean on, boolean replaceOld) {
        if (mapitemsaveddata instanceof ExpandedMapData) {
            ExpandedMapData data = (ExpandedMapData)mapitemsaveddata;
            class_22 newData = replaceOld ? mapitemsaveddata : data.copy();
            WeatheredMapData instance = WeatheredMap.getAntiqueData(newData);
            ColoredMapHandler.ColorData colorData = ColoredMapHandler.getColorData(newData);
            colorData.clear();
            MapLightHandler.LightData lightData = MapLightHandler.getLightData(newData);
            lightData.clear();
            instance.set(on);
            instance.setDirty(newData, CustomMapData.SimpleDirtyCounter::markDirty);
            if (!replaceOld) {
                int mapId = level.method_17889();
                String mapKey = class_1806.method_17440((int)mapId);
                level.method_17890(mapKey, newData);
                return mapId;
            }
        }
        return null;
    }

    static {
        class_3620 mc1;
        class_3620 mc;
        ANTIQUE_DATA_KEY = MapDataRegistry.registerCustomMapSavedData((class_2960)Supplementaries.res(ANTIQUE_KEY), WeatheredMapData::new);
        ANTIQUE_COLORS = new Object2ObjectArrayMap();
        try {
            Class<class_3620> cl = class_3620.class;
            Constructor cons = cl.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
            cons.setAccessible(true);
            mc = (class_3620)cons.newInstance(62, 13870193);
            mc1 = (class_3620)cons.newInstance(63, 10976850);
        }
        catch (Exception e) {
            mc = class_3620.field_16003;
            mc1 = class_3620.field_33533;
            Supplementaries.LOGGER.warn("Failed to add custom map colors for antique map: ", (Throwable)e);
        }
        ANTIQUE_DARK = mc1;
        ANTIQUE_LIGHT = mc;
        ANTIQUE_COLORS.put((Object)class_3620.field_16023, (Object)class_3620.field_16000);
        ANTIQUE_COLORS.put((Object)class_3620.field_33532, (Object)class_3620.field_16000);
        ANTIQUE_COLORS.put((Object)class_3620.field_16004, (Object)class_3620.field_15977);
        ANTIQUE_COLORS.put((Object)class_3620.field_16000, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_15996, (Object)class_3620.field_15996);
        ANTIQUE_COLORS.put((Object)class_3620.field_15978, (Object)class_3620.field_15977);
        ANTIQUE_COLORS.put((Object)class_3620.field_16007, (Object)class_3620.field_16007);
        ANTIQUE_COLORS.put((Object)class_3620.field_16009, (Object)class_3620.field_16007);
        ANTIQUE_COLORS.put((Object)class_3620.field_15986, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_16025, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_16022, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_16005, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_15979, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_15977, (Object)class_3620.field_15992);
    }

    public static class WeatheredMapData
    implements CustomMapData<CustomMapData.SimpleDirtyCounter> {
        private boolean antique = false;

        public boolean isAntique() {
            return this.antique;
        }

        public void load(class_2487 tag) {
            this.antique = tag.method_10545(WeatheredMap.ANTIQUE_KEY) ? tag.method_10577(WeatheredMap.ANTIQUE_KEY) : false;
        }

        public void loadUpdateTag(class_2487 tag) {
            if (tag.method_10545(WeatheredMap.ANTIQUE_KEY)) {
                this.antique = tag.method_10577(WeatheredMap.ANTIQUE_KEY);
            }
        }

        public void save(class_2487 tag) {
            if (this.antique) {
                tag.method_10556(WeatheredMap.ANTIQUE_KEY, true);
            }
        }

        public void saveToUpdateTag(class_2487 tag, CustomMapData.SimpleDirtyCounter dirtyCounter) {
            tag.method_10556(WeatheredMap.ANTIQUE_KEY, this.antique);
        }

        public CustomMapData.Type<WeatheredMapData> getType() {
            return ANTIQUE_DATA_KEY;
        }

        @Nullable
        public class_2561 onItemTooltip(class_22 data, class_1799 stack) {
            if (this.antique) {
                return class_2561.method_43471((String)"filled_map.antique.tooltip").method_27692(class_124.field_1080);
            }
            return null;
        }

        public CustomMapData.SimpleDirtyCounter createDirtyCounter() {
            return new CustomMapData.SimpleDirtyCounter();
        }

        public boolean onItemUpdate(class_22 data, class_1297 entity) {
            boolean hasCeiling;
            boolean hasDepthLock;
            if (!this.antique) {
                return false;
            }
            class_1937 level = entity.method_37908();
            if (level.method_27983() != data.field_118 || !(entity instanceof class_1657)) {
                return true;
            }
            class_1657 pl = (class_1657)entity;
            int minHeight = SliceMapItem.getMapHeight(data);
            boolean bl = hasDepthLock = minHeight != Integer.MAX_VALUE;
            if (hasDepthLock && !SliceMapItem.canPlayerSee(minHeight, (class_1297)pl)) {
                return true;
            }
            int scale = 1 << data.field_119;
            int mapX = data.field_116;
            int mapZ = data.field_115;
            int playerX = class_3532.method_15357((double)(entity.method_23317() - (double)mapX)) / scale + 64;
            int playerZ = class_3532.method_15357((double)(entity.method_23321() - (double)mapZ)) / scale + 64;
            int range = 128 / scale;
            if (hasDepthLock) {
                range = (int)((double)range * SliceMapItem.getRangeMultiplier());
            }
            if (hasCeiling = WeatheredMapData.isHasCeiling(level, minHeight)) {
                range /= 2;
            }
            class_22.class_23 player = data.method_101((class_1657)entity);
            boolean hasChangedAColorThisZ = false;
            for (int pixelX = playerX - range + 1; pixelX < playerX + range; ++pixelX) {
                if ((pixelX & 0xF) != (player.field_131 & 0xF) && !hasChangedAColorThisZ) continue;
                hasChangedAColorThisZ = false;
                double somethingY = 0.0;
                for (int pixelZ = playerZ - range - 1; pixelZ < playerZ + range; ++pixelZ) {
                    class_2818 lc;
                    boolean maxRadius;
                    if (pixelX < 0 || pixelZ < -1 || pixelX >= 128 || pixelZ >= 128) continue;
                    int offsetX = pixelX - playerX;
                    int offsetZ = pixelZ - playerZ;
                    int dist = offsetX * offsetX + offsetZ * offsetZ;
                    boolean bl2 = maxRadius = dist > range * range;
                    if (maxRadius) continue;
                    boolean innerRadius = dist > (range - 2) * (range - 2);
                    int worldX = (mapX / scale + pixelX - 64) * scale;
                    int worldZ = (mapZ / scale + pixelZ - 64) * scale;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    class_2791 levelchunk = level.method_8402(class_4076.method_18675((int)worldX), class_4076.method_18675((int)worldZ), class_2806.field_12803, false);
                    if (!(levelchunk instanceof class_2818) || (lc = (class_2818)levelchunk).method_12223()) continue;
                    class_1923 chunkpos = levelchunk.method_12004();
                    int chunkCoordX = worldX & 0xF;
                    int chunkCoordZ = worldZ & 0xF;
                    double maxY = 0.0;
                    int distanceFromLand = 8;
                    HashMap<class_2338, Boolean> isWaterMap = new HashMap<class_2338, Boolean>();
                    if (hasCeiling) {
                        int l3 = worldX + worldZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)class_2246.field_10566.method_9564().method_26205((class_1922)level, class_2338.field_10980), 10);
                        } else {
                            multiset.add((Object)class_2246.field_10113.method_9564().method_26205((class_1922)level, class_2338.field_10980), 100);
                        }
                        maxY = 100.0;
                        distanceFromLand = 0;
                    } else {
                        class_2338.class_2339 mutable1 = new class_2338.class_2339();
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ - scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ + scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ - scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ + scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX, worldZ - scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX, worldZ + scale)) {
                            --distanceFromLand;
                        }
                        for (int scaleOffsetX = 0; scaleOffsetX < scale; ++scaleOffsetX) {
                            for (int scaleOffsetZ = 0; scaleOffsetZ < scale; ++scaleOffsetZ) {
                                int cY = Math.min(minHeight, levelchunk.method_12005(class_2902.class_2903.field_13202, scaleOffsetX + chunkCoordX, scaleOffsetZ + chunkCoordZ) + 1);
                                class_3620 newColor = null;
                                if (cY <= level.method_31607() + 1) {
                                    newColor = class_2246.field_9987.method_9564().method_26205((class_1922)level, (class_2338)mutable1);
                                } else {
                                    class_2680 blockState;
                                    class_3620 temp;
                                    do {
                                        mutable1.method_10103(chunkpos.method_8326() + scaleOffsetX + chunkCoordX, --cY, chunkpos.method_8328() + scaleOffsetZ + chunkCoordZ);
                                        blockState = levelchunk.method_8320((class_2338)mutable1);
                                        temp = blockState.method_26205((class_1922)level, (class_2338)mutable1);
                                        if (temp == class_3620.field_16008 || temp == class_3620.field_16019 || !blockState.method_26220((class_1922)level, (class_2338)mutable1).method_1110()) continue;
                                        newColor = class_3620.field_15999;
                                    } while (temp == class_3620.field_16008 && cY > level.method_31607());
                                    if (newColor == null) {
                                        newColor = blockState.method_26205((class_1922)level, (class_2338)mutable1);
                                    }
                                }
                                data.method_109((class_1922)level, chunkpos.method_8326() + scaleOffsetX + chunkCoordX, chunkpos.method_8328() + scaleOffsetZ + chunkCoordZ);
                                maxY += (double)cY / (double)(scale * scale);
                                if (cY >= minHeight) {
                                    newColor = SliceMapItem.getCutoffColor((class_2338)mutable1, (class_1922)levelchunk);
                                }
                                multiset.add((Object)newColor);
                            }
                        }
                    }
                    int relativeShade = 1;
                    class_3620 mc = (class_3620)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)class_3620.field_16008);
                    if (mc == class_3620.field_16019) {
                        mc = class_3620.field_15987;
                        if (distanceFromLand > 7 && pixelZ % 2 == 0) {
                            relativeShade = (pixelX + (int)(class_3532.method_15374((float)((float)pixelZ + 0.0f)) * 7.0f)) / 8 % 5;
                            if (relativeShade == 3) {
                                relativeShade = 1;
                            } else if (relativeShade == 4) {
                                relativeShade = 0;
                            }
                        } else if (distanceFromLand > 7) {
                            mc = ANTIQUE_LIGHT;
                            relativeShade = 2;
                        } else if (distanceFromLand > 5) {
                            relativeShade = 1;
                        } else if (distanceFromLand > 3) {
                            relativeShade = 0;
                        }
                    } else if (distanceFromLand > 0) {
                        relativeShade = 3;
                        mc = class_3620.field_15977;
                        if (distanceFromLand > 3) {
                            relativeShade = 1;
                        }
                    } else {
                        double depthY = (maxY - somethingY) * 4.0 / (double)(scale + 4) + ((double)(pixelX + pixelZ & 1) - 0.5) * 0.4;
                        if (depthY > 0.6) {
                            relativeShade = 2;
                        } else if (depthY < -0.6) {
                            relativeShade = 0;
                        }
                        mc = (class_3620)ANTIQUE_COLORS.getOrDefault((Object)mc, (Object)ANTIQUE_DARK);
                    }
                    somethingY = maxY;
                    if (pixelZ < 0 || innerRadius && (pixelX + pixelZ & 1) == 0) continue;
                    hasChangedAColorThisZ |= data.method_32365(pixelX, pixelZ, (byte)(mc.field_16021 * 4 + relativeShade));
                }
            }
            ++player.field_131;
            return true;
        }

        private static boolean isHasCeiling(class_1937 level, int mapHeight) {
            boolean original = level.method_8597().comp_643();
            if (original && mapHeight != Integer.MAX_VALUE && CommonConfigs.Tools.SLICE_MAP_ENABLED.get().booleanValue()) {
                return false;
            }
            return original;
        }

        public void set(boolean on) {
            this.antique = on;
        }

        private static boolean isWaterAt(class_1937 level, Map<class_2338, Boolean> map, int scale, int x, int z) {
            class_2338 pos = new class_2338(x, 0, z);
            return map.computeIfAbsent(pos, p -> {
                int y = level.method_8624(class_2902.class_2903.field_13202, x, z) - 1;
                return level.method_8316(pos.method_10086(y)).method_15769();
            });
        }
    }
}

