/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.mehvahdjukaar.moonlight.api.client.anim.PendulumAnimation;
import net.mehvahdjukaar.moonlight.api.client.anim.SwingAnimation;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HatStandEntity
extends LivingEntity {
    private static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.defineId(HatStandEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.defineId(HatStandEntity.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<OptionalInt> FACING_TARGET = SynchedEntityData.defineId(HatStandEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private final NonNullList<ItemStack> helmet = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private boolean invisible;
    public long lastHit;
    private boolean slotsDisabled = false;
    private Rotations headPose;
    public final SwingAnimation swingAnimation;
    public final AnimationState skibidiAnimation;
    private final int tickOffset;
    private int skibidiAnimDur = 0;
    @Nullable
    private Float originalYRot = null;
    @Nullable
    private Entity target = null;
    public Vec3 jumpScareAngles = Vec3.ZERO;

    public HatStandEntity(EntityType<? extends HatStandEntity> entityType, Level level) {
        super(entityType, level);
        this.headPose = DEFAULT_HEAD_POSE;
        if (PlatHelper.getPhysicalSide().isClient()) {
            this.swingAnimation = new PendulumAnimation(ClientConfigs.Blocks.HAT_STAND_CONFIG, this::getRotationAxis);
            this.skibidiAnimation = new AnimationState();
        } else {
            this.swingAnimation = null;
            this.skibidiAnimation = null;
        }
        this.tickOffset = level.random.nextInt(100);
        this.originalYRot = null;
    }

    private Vector3f getRotationAxis() {
        return this.getViewVector(0.0f).toVector3f();
    }

    public void refreshDimensions() {
        double d = this.getX();
        double e = this.getY();
        double f = this.getZ();
        super.refreshDimensions();
        this.setPos(d, e, f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CLIENT_FLAGS, (Object)0);
        builder.define(FACING_TARGET, (Object)OptionalInt.empty());
        builder.define(DATA_HEAD_POSE, (Object)DEFAULT_HEAD_POSE);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.helmet;
    }

    public Iterable<ItemStack> getHandSlots() {
        return List.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        if (Objects.requireNonNull(slot) == EquipmentSlot.HEAD) {
            return (ItemStack)this.helmet.get(0);
        }
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        this.verifyEquippedItem(stack);
        if (slot == EquipmentSlot.HEAD) {
            this.onEquipItem(slot, (ItemStack)this.helmet.set(0, (Object)stack), stack);
        }
    }

    public boolean canTakeItem(ItemStack stack) {
        EquipmentSlot equipmentSlot = this.getEquipmentSlotForItem(stack);
        return this.getItemBySlot(equipmentSlot).isEmpty();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ItemStack stack = (ItemStack)this.helmet.get(0);
        if (!stack.isEmpty()) {
            compound.put("Helmet", stack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
        }
        compound.putBoolean("Invisible", this.isInvisible());
        compound.putBoolean("NoBasePlate", this.isNoBasePlate());
        compound.putBoolean("DisabledSlots", this.slotsDisabled);
        ListTag compoundTag = new ListTag();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            compoundTag = this.headPose.save();
        }
        compound.put("HeadPose", (Tag)compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Helmet")) {
            this.helmet.set(0, (Object)ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)compound.getCompound("Helmet")));
        }
        this.setInvisible(compound.getBoolean("Invisible"));
        this.setNoBasePlate(compound.getBoolean("NoBasePlate"));
        this.slotsDisabled = compound.getBoolean("DisabledSlots");
        ListTag listTag = compound.getList("HeadPose", 5);
        this.setHeadPose(listTag.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(listTag));
    }

    public boolean isPushable() {
        return false;
    }

    public void aiStep() {
        super.aiStep();
        Level level = this.level();
        if (level.isClientSide) {
            Entity e;
            this.swingAnimation.tick(!level.getFluidState(this.getOnPos()).isEmpty());
            List list = level.getEntities((Entity)this, this.getBoundingBox());
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !this.swingAnimation.hitByEntity(e = (Entity)iterator.next())) {
            }
            float currentRot = this.getYRot();
            if (this.target != null && this.skibidiAnimation.isStarted()) {
                Vec3 distanceVec = this.target.position().subtract(this.position()).normalize();
                float targetYRot = distanceVec.toVector3f().angleSigned((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)) * 57.295776f - 90.0f;
                float difference = Mth.degreesDifference((float)currentRot, (float)targetYRot);
                this.setYRot(Mth.lerp((float)0.5f, (float)currentRot, (float)(currentRot + difference)));
            } else if (this.originalYRot != null && currentRot != this.originalYRot.floatValue()) {
                this.setYRot(this.originalYRot.floatValue());
                this.originalYRot = null;
            }
        } else if (this.skibidiAnimDur != 0) {
            --this.skibidiAnimDur;
            if (this.skibidiAnimDur == 0) {
                this.getEntityData().set(FACING_TARGET, (Object)OptionalInt.empty());
                this.setPose(Pose.STANDING);
            }
        } else if (this.getPose() == Pose.STANDING && (this.tickCount + this.tickOffset) % 100 == 0 && this.random.nextFloat() < 0.2f) {
            this.setSkibidiIfInCauldron(null);
        }
    }

    protected void doPush(Entity entity) {
    }

    protected void pushEntities() {
        super.pushEntities();
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!itemStack.is(Items.NAME_TAG)) {
            boolean isClientSide = player.level().isClientSide;
            if (player.isSecondaryUseActive()) {
                if (isClientSide) {
                    this.swingAnimation.addImpulse(0.001f);
                    this.swingAnimation.addPositiveImpulse(1.2f);
                }
                return InteractionResult.sidedSuccess((boolean)isClientSide);
            }
            if (player.isSpectator()) {
                return InteractionResult.SUCCESS;
            }
            if (isClientSide) {
                return InteractionResult.CONSUME;
            }
            if (!this.slotsDisabled) {
                if (itemStack.isEmpty()) {
                    EquipmentSlot targetSlot = EquipmentSlot.HEAD;
                    if (this.hasItemInSlot(targetSlot) && this.swapItem(player, targetSlot, itemStack, hand)) {
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    EquipmentSlot equipmentSlot = this.getEquipmentSlotForItem(itemStack);
                    if (CommonConfigs.Building.HAT_STAND_UNRESTRICTED.get().booleanValue()) {
                        equipmentSlot = EquipmentSlot.HEAD;
                    }
                    if (equipmentSlot != EquipmentSlot.HEAD) {
                        return InteractionResult.FAIL;
                    }
                    if (this.swapItem(player, equipmentSlot, itemStack, hand)) {
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD;
    }

    private boolean swapItem(Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack itemStack = this.getItemBySlot(slot);
        if (player.getAbilities().instabuild && itemStack.isEmpty() && !stack.isEmpty()) {
            this.setItemSlot(slot, stack.copyWithCount(1));
            return true;
        }
        if (!stack.isEmpty() && stack.getCount() > 1) {
            if (!itemStack.isEmpty()) {
                return false;
            }
            this.setItemSlot(slot, stack.split(1));
            return true;
        }
        this.setItemSlot(slot, stack);
        player.setItemInHand(hand, itemStack);
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        Level level;
        if (this.level().isClientSide && source.getDirectEntity() instanceof Projectile) {
            this.swingAnimation.hitByEntity(source.getDirectEntity());
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!this.isRemoved()) {
                if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                    this.dismantle(sl, source);
                    return false;
                }
                if (!this.isInvulnerableTo(source) && !this.invisible) {
                    if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                        this.dismantle(sl, source);
                        return false;
                    }
                    if (source.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                        if (this.isOnFire()) {
                            this.causeDamage(sl, source, 0.15f);
                        } else {
                            this.igniteForSeconds(5.0f);
                        }
                        return false;
                    }
                    if (source.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                        this.causeDamage(sl, source, 4.0f);
                        return false;
                    }
                    boolean isDirectArrow = source.getDirectEntity() instanceof AbstractArrow;
                    boolean isPierceArrow = isDirectArrow && ((AbstractArrow)source.getDirectEntity()).getPierceLevel() > 0;
                    boolean bl3 = "player".equals(source.getMsgId());
                    if (!bl3 && !isDirectArrow) {
                        return false;
                    }
                    Entity sourceEntity = source.getEntity();
                    if (sourceEntity instanceof Player) {
                        Player player = (Player)sourceEntity;
                        if (!player.getAbilities().mayBuild) {
                            return false;
                        }
                    }
                    if (source.isCreativePlayer()) {
                        this.dismantle(sl, null);
                        return isPierceArrow;
                    }
                    long l = this.level().getGameTime();
                    if (l - this.lastHit > 5L && !isDirectArrow) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)32);
                        this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
                        this.lastHit = l;
                    } else {
                        this.dismantle(sl, source);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void handleEntityEvent(byte id) {
        if (id == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d) || d == 0.0) {
            d = 4.0;
        }
        return distance < (d *= 64.0) * d;
    }

    private void showBreakingParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void causeDamage(ServerLevel sl, DamageSource damageSource, float amount) {
        float f = this.getHealth();
        if ((f -= amount) <= 0.5f) {
            this.dismantle(sl, damageSource);
        } else {
            this.setHealth(f);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, damageSource.getEntity());
        }
    }

    protected float tickHeadTurn(float yRot, float animStep) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    public void setYBodyRot(float pOffset) {
        float r;
        this.yRotO = r = this.getYRot();
        this.yBodyRotO = r;
        this.yBodyRot = r;
    }

    public void setYHeadRot(float pRotation) {
        float r;
        this.yRotO = r = this.getYRot();
        this.yHeadRotO = r;
        this.yHeadRot = r;
    }

    public void tick() {
        super.tick();
        Rotations rotations = (Rotations)this.entityData.get(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)rotations)) {
            this.setHeadPose(rotations);
        }
    }

    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
        super.setInvisible(invisible);
    }

    public void setNoBasePlate(boolean noBasePlate) {
        this.entityData.set(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_CLIENT_FLAGS), 8, noBasePlate));
    }

    public boolean isNoBasePlate() {
        return ((Byte)this.entityData.get(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    private byte setBit(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }

    public void dismantle(ServerLevel serverLevel, @Nullable DamageSource source) {
        if (source != null) {
            this.dropAllDeathLoot(serverLevel, source);
        }
        this.showBreakingParticles();
        this.playBrokenSound();
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    protected void dropAllDeathLoot(ServerLevel serverLevel, DamageSource damageSource) {
        super.dropAllDeathLoot(serverLevel, damageSource);
        this.spawnAtLocation(this.getPickResult(), 1.0f);
    }

    protected void dropEquipment() {
        super.dropEquipment();
        ItemStack itemStack = (ItemStack)this.helmet.get(0);
        if (!itemStack.isEmpty()) {
            this.spawnAtLocation(itemStack, 1.0f);
            this.helmet.set(0, (Object)ItemStack.EMPTY);
        }
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    public void kill() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.dismantle(sl, sl.damageSources().generic());
        }
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return this.isInvisible();
    }

    public void setHeadPose(Rotations headPose) {
        this.headPose = headPose;
        this.entityData.set(DATA_HEAD_POSE, (Object)headPose);
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean skipAttackInteraction(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player p = (Player)entity;
        if (this.level().mayInteract(p, this.blockPosition())) return false;
        return true;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_CLIENT_FLAGS.equals(key)) {
            this.refreshDimensions();
            this.blocksBuilding = true;
        }
        if (DATA_POSE.equals(key) && this.level().isClientSide) {
            Pose pose = this.getPose();
            if (pose == Pose.SNIFFING || pose == Pose.SPIN_ATTACK) {
                this.skibidiAnimation.start(this.tickCount);
            } else {
                this.skibidiAnimation.stop();
            }
        }
        if (FACING_TARGET.equals(key) && this.level().isClientSide) {
            OptionalInt o = (OptionalInt)this.getEntityData().get(FACING_TARGET);
            if (o.isPresent()) {
                this.target = this.level().getEntity(o.getAsInt());
                this.originalYRot = Float.valueOf(this.getYRot());
            } else {
                this.target = null;
            }
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean attackable() {
        return false;
    }

    public ItemStack getPickResult() {
        ItemStack itemStack = new ItemStack((ItemLike)ModRegistry.HAT_STAND.get());
        if (this.hasCustomName()) {
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return itemStack;
    }

    public boolean canBeSeenByAnyone() {
        return !this.isInvisible();
    }

    private void setSkibidiIfInCauldron(@Nullable LivingEntity target) {
        BlockState state = this.getBlockStateOn();
        Block block = state.getBlock();
        if (block instanceof AbstractCauldronBlock || block instanceof ComposterBlock) {
            this.setSkibidi(true, true, target);
        } else if (block instanceof HopperBlock || block instanceof DecoratedPotBlock) {
            this.setSkibidi(true, false, target);
        }
    }

    public void setSkibidi(boolean skibidi, boolean tall, @Nullable LivingEntity playerTarget) {
        OptionalInt opt = playerTarget != null ? OptionalInt.of(playerTarget.getId()) : OptionalInt.empty();
        this.entityData.set(FACING_TARGET, (Object)opt);
        if (skibidi) {
            this.setPose(tall ? Pose.SPIN_ATTACK : Pose.SNIFFING);
            this.skibidiAnimDur = 160;
        } else {
            this.setPose(Pose.STANDING);
        }
    }

    public static void makeSkibidiInArea(LivingEntity player) {
        Level level = player.level();
        List toilets = level.getEntitiesOfClass(HatStandEntity.class, new AABB(player.getOnPos()).inflate(10.0));
        toilets.forEach(h -> h.setSkibidiIfInCauldron(player));
    }
}

