/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class RopeSlideSoundInstance
extends AbstractTickableSoundInstance {
    private final Player player;
    private int ropeTicks;
    private boolean stopToggle = false;

    public RopeSlideSoundInstance(Player player) {
        super(ModSounds.ROPE_SLIDE.get(), SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.player = player;
        this.x = this.player.getX();
        this.y = this.player.getY();
        this.z = this.player.getZ();
        this.looping = true;
        this.delay = 1;
        this.volume = 0.0f;
        this.ropeTicks = 0;
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
    }

    public void tick() {
        BlockState b;
        this.stopToggle = false;
        this.x = this.player.getX();
        this.y = this.player.getY();
        this.z = this.player.getZ();
        if (this.player.onClimbable() && (b = this.player.getBlockStateOn()).is(ModTags.FAST_FALL_ROPES)) {
            float downwardSpeed = -((float)this.player.getDeltaMovement().y);
            float minPitch = 0.7f;
            float speedScaling = 0.5f;
            float maxPitch = 2.0f;
            float newPitch = Mth.clamp((float)(0.5f + downwardSpeed * speedScaling), (float)0.0f, (float)maxPitch);
            if (newPitch >= minPitch) {
                ++this.ropeTicks;
                float minVolume = 0.0f;
                float maxVolume = 1.0f;
                float volumeScaling = 0.07f;
                this.pitch = newPitch;
                this.volume = Mth.clamp((float)((float)this.ropeTicks * volumeScaling), (float)minVolume, (float)maxVolume);
                return;
            }
        }
        this.stop();
        this.pitch = 0.0f;
        this.volume = 0.0f;
        this.ropeTicks = 0;
    }

    public boolean canStartSilent() {
        return true;
    }

    public boolean canPlaySound() {
        return !this.player.isRemoved() && !this.player.isSilent() && this.player.onClimbable();
    }

    protected void stop() {
        this.stopToggle = true;
    }

    public boolean isStopped() {
        return this.stopToggle;
    }
}

