/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadsTransformer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class RandomRotationModel
implements CustomBakedModel {
    private final Map<Direction, List<BakedQuad>[]> quadCache = new Object2ObjectArrayMap();
    private final BakedModel wrapped;

    public RandomRotationModel(BakedModel back, ModelState modelTransform) {
        this.wrapped = back;
    }

    public boolean useAmbientOcclusion() {
        return this.wrapped.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.wrapped.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.wrapped.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.wrapped.isCustomRenderer();
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.wrapped.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return this.wrapped.getOverrides();
    }

    public ItemTransforms getTransforms() {
        return this.wrapped.getTransforms();
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        int randIndex = rand.nextInt(4);
        float angle = (float)randIndex * 90.0f;
        List[] array = this.quadCache.computeIfAbsent(side, d -> new List[4]);
        List arr = array[randIndex];
        if (arr == null) {
            ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>();
            for (BakedQuad q : this.wrapped.getQuads(state, side, rand)) {
                Direction normal = q.getDirection();
                Quaternionf randomRot = new Quaternionf().rotateAxis(angle * ((float)Math.PI / 180), (Vector3fc)normal.step());
                Matrix4f mat = new Matrix4f();
                mat.rotate((Quaternionfc)randomRot);
                BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingTransform(mat);
                newQuads.add(transformer.transform(q));
            }
            array[randIndex] = newQuads;
            return newQuads;
        }
        return array[randIndex];
    }
}

