/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlingshotParticle
extends TextureSheetParticle {
    private SlingshotParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet sprites) {
        super(world, x, y, z);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.quadSize *= 1.0f;
        this.lifetime = (int)(8.0 / ((double)this.random.nextFloat() * 0.3 + 0.7));
        this.hasPhysics = false;
        this.pickSprite(sprites);
    }

    public float getQuadSize(float partialTicks) {
        float d = ((float)this.age + partialTicks) / (float)this.lifetime;
        return Mth.lerp((float)d, (float)this.quadSize, (float)(this.quadSize * 5.2f));
    }

    public void tick() {
        super.tick();
        float d = (float)this.age / (float)this.lifetime;
        this.alpha = 1.0f - d;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        VoxelShape shape = this.level.getBlockState(pos).getCollisionShape((BlockGetter)this.level, pos);
        if (!shape.isEmpty() && shape.toAabbs().contains(this.getBoundingBox())) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SlingshotParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite);
        }
    }
}

