/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.List;
import java.util.WeakHashMap;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EndermanSkullBlockTile
extends SkullBlockEntity {
    private float prevMouthAnim;
    private float mouthAnim;
    private int watchTime;
    private static final WeakHashMap<Level, EnderMan> FAKE_ENDERMAN = new WeakHashMap();

    public EndermanSkullBlockTile(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public BlockEntityType<?> getType() {
        return ModRegistry.ENDERMAN_SKULL_TILE.get();
    }

    public float getMouthAnimation(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevMouthAnim, (float)this.mouthAnim);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EndermanSkullBlockTile tile) {
        if (level.isClientSide) {
            boolean watched = (Boolean)state.getValue((Property)ModBlockProperties.WATCHED);
            tile.prevMouthAnim = tile.mouthAnim;
            tile.mouthAnim = Mth.clamp((float)(tile.mouthAnim + (watched ? 0.5f : -0.5f)), (float)0.0f, (float)1.0f);
        } else {
            boolean watched = EndermanSkullBlockTile.isBeingWatched(level, pos, state);
            tile.watchTime = !watched ? 0 : ++tile.watchTime;
            int wantedPower = Mth.clamp((int)(watched ? 1 + tile.watchTime / CommonConfigs.Redstone.ENDERMAN_HEAD_INCREMENT.get() : 0), (int)0, (int)15);
            if ((Boolean)state.getValue((Property)ModBlockProperties.WATCHED) != watched || (Integer)state.getValue((Property)EndermanSkullBlock.POWER) != wantedPower) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)ModBlockProperties.WATCHED, (Comparable)Boolean.valueOf(watched))).setValue((Property)EndermanSkullBlock.POWER, (Comparable)Integer.valueOf(wantedPower)));
            }
        }
    }

    public static void clearCache() {
        FAKE_ENDERMAN.clear();
    }

    public static boolean isBeingWatched(Level level, BlockPos pos, BlockState state) {
        int range = 20;
        List players = level.getEntitiesOfClass(Player.class, AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)));
        EnderMan fakeEnderman = FAKE_ENDERMAN.computeIfAbsent(level, l -> new EnderMan(EntityType.ENDERMAN, l));
        fakeEnderman.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5 - (double)fakeEnderman.getEyeHeight(), (double)pos.getZ() + 0.5);
        for (Player player : players) {
            BlockHitResult hit;
            HitResult result;
            fakeEnderman.lookAt((Entity)player, 360.0f, 360.0f);
            ItemStack itemstack = player.getItemBySlot(EquipmentSlot.HEAD);
            if (SuppPlatformStuff.isEndermanMask(fakeEnderman, player, itemstack) || !((result = player.pick(64.0, 1.0f, false)) instanceof BlockHitResult) || !(hit = (BlockHitResult)result).getBlockPos().equals((Object)pos) || !EndermanSkullBlockTile.isLookingAtFace(pos, state, result.getLocation(), hit.getDirection())) continue;
            return true;
        }
        return false;
    }

    private static boolean isLookingAtFace(BlockPos pos, BlockState state, Vec3 location, Direction face) {
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_WORKS_FROM_ANY_SIDE.get().booleanValue()) {
            return true;
        }
        if (face.getAxis() == Direction.Axis.Y) {
            return false;
        }
        if (state.hasProperty((Property)WallSkullBlock.FACING)) {
            Direction f = (Direction)state.getValue((Property)WallSkullBlock.FACING);
            return f == face;
        }
        if (state.hasProperty((Property)SkullBlock.ROTATION)) {
            Integer r = (Integer)state.getValue((Property)SkullBlock.ROTATION);
            float angle = (float)r.intValue() * 22.5f;
            if (angle % 90.0f == 0.0f) {
                return Direction.fromYRot((double)angle).getOpposite() == face;
            }
            location = location.subtract(Vec3.atCenterOf((Vec3i)pos));
            Vec3 relative = location.yRot(angle * ((float)Math.PI / 180));
            if (relative.x < -0.25 || relative.x > 0.25) {
                return false;
            }
            if (relative.z > 0.0) {
                return false;
            }
        }
        return true;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("WatchTime", this.watchTime);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.watchTime = tag.getInt("WatchTime");
    }

    @Nullable
    public ResourceLocation getNoteBlockSound() {
        return ModSounds.IMITATE_ENDERMAN.getId();
    }
}

