/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class KeyLockableTile
extends BlockEntity
implements IKeyLockable {
    public static final MutableComponent KEY_LOCKABLE_TOOLTIP = Component.translatable((String)"message.supplementaries.key.lockable").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    private String password = null;

    public KeyLockableTile(BlockPos pos, BlockState state) {
        super(ModRegistry.KEY_LOCKABLE_TILE.get(), pos, state);
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void clearPassword() {
        this.password = null;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public boolean handleAction(Player player, InteractionHand handIn, ItemStack stack, String translName) {
        if (player.isSpectator()) {
            return false;
        }
        String keyPassword = IKeyLockable.getKeyPassword(stack);
        if (player.isSecondaryUseActive() && keyPassword != null) {
            if (this.tryClearingKey(player, stack)) {
                return false;
            }
        } else if (this.password == null) {
            if (keyPassword != null) {
                this.setPassword(keyPassword);
                this.onKeyAssigned(this.level, this.worldPosition, player, keyPassword);
                return false;
            }
            return true;
        }
        IKeyLockable.KeyStatus status = this.getKeyInInventoryStatus(player);
        status.sendMessage(player, translName);
        return status.isCorrect();
    }

    @Override
    public IKeyLockable.KeyStatus getKeyInInventoryStatus(Player player) {
        if (player.isCreative()) {
            return IKeyLockable.KeyStatus.CORRECT_KEY;
        }
        return IKeyLockable.super.getKeyInInventoryStatus(player);
    }

    public boolean tryClearingKey(Player player, ItemStack stack) {
        if (player.isCreative() || this.getKeyStatus(stack).isCorrect()) {
            this.clearPassword();
            this.onPasswordCleared(player, this.worldPosition);
            return true;
        }
        return false;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.password = tag.contains("Password") ? tag.getString("Password") : null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.password != null) {
            tag.putString("Password", this.password);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

