/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.controllers;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BoatNodeEvaluator
extends NodeEvaluator {
    private static final float ON_LAND_MALUS = 1000.0f;
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    private static final double DEFAULT_MOB_JUMP_HEIGHT = 1.125;
    private final Long2ObjectMap<PathType> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();
    private final Node[] reusableNeighbors = new Node[Direction.Plane.HORIZONTAL.length()];

    public BoatNodeEvaluator() {
        this.canFloat = true;
    }

    private boolean isCanStandOnFluid(FluidState fluidState) {
        if (fluidState.is(FluidTags.WATER)) {
            return true;
        }
        return this.mob.canStandOnFluid(fluidState);
    }

    private float getPathfindingMalus(PathType type) {
        return this.getPathfindingMalus(type, this.mob);
    }

    public float getPathfindingMalus(PathType type, Mob mob) {
        if (type == PathType.WATER) {
            return 0.0f;
        }
        float malus = mob.getPathfindingMalus(type);
        return malus == -1.0f ? -1.0f : malus + 1000.0f;
    }

    public static double getWaterHeightLevel(BlockGetter level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState stateBelow = level.getBlockState(belowPos);
        FluidState fluidState = stateBelow.getFluidState();
        VoxelShape voxelShape = stateBelow.getCollisionShape(level, belowPos);
        double solidShape = (double)belowPos.getY() + (voxelShape.isEmpty() ? 0.0 : voxelShape.max(Direction.Axis.Y));
        float fluidHeight = fluidState.getHeight(level, belowPos);
        return Math.max(solidShape, (double)fluidHeight);
    }

    public void setCanFloat(boolean canFloat) {
    }

    protected double getFloorLevel(BlockPos pos) {
        CollisionGetter blockGetter = this.currentContext.level();
        return (this.canFloat() || this.isAmphibious()) && blockGetter.getFluidState(pos).is(FluidTags.WATER) ? (double)pos.getY() + 0.5 : BoatNodeEvaluator.getFloorLevel((BlockGetter)blockGetter, pos);
    }

    public void prepare(PathNavigationRegion level, Mob mob) {
        super.prepare(level, mob);
        mob.onPathfindingStart();
        Entity vehicle = mob.getVehicle();
        if (vehicle != null) {
            this.entityWidth = Mth.floor((float)(vehicle.getBbWidth() + 1.0f));
            this.entityHeight = Mth.floor((float)(vehicle.getBbHeight() + 1.0f));
            this.entityDepth = Mth.floor((float)(vehicle.getBbWidth() + 1.0f));
        }
    }

    public void done() {
        this.mob.onPathfindingDone();
        this.pathTypesByPosCacheByMob.clear();
        this.collisionCache.clear();
        super.done();
    }

    public Node getStart() {
        int i;
        BlockPos.MutableBlockPos mutableBlockPos;
        block11: {
            mutableBlockPos = new BlockPos.MutableBlockPos();
            i = this.mob.getBlockY();
            BlockState blockState = this.currentContext.getBlockState((BlockPos)mutableBlockPos.set(this.mob.getX(), (double)i, this.mob.getZ()));
            if (!this.isCanStandOnFluid(blockState.getFluidState())) {
                if (this.canFloat() && this.mob.isInWater()) {
                    while (true) {
                        if (!blockState.is(Blocks.WATER) && blockState.getFluidState() != Fluids.WATER.getSource(false)) {
                            --i;
                            break block11;
                        }
                        blockState = this.currentContext.getBlockState((BlockPos)mutableBlockPos.set(this.mob.getX(), (double)(++i), this.mob.getZ()));
                    }
                }
                if (this.mob.onGround()) {
                    i = Mth.floor((double)(this.mob.getY() + 0.5));
                } else {
                    mutableBlockPos.set(this.mob.getX(), this.mob.getY() + 1.0, this.mob.getZ());
                    while (mutableBlockPos.getY() > this.currentContext.level().getMinBuildHeight()) {
                        i = mutableBlockPos.getY();
                        mutableBlockPos.setY(mutableBlockPos.getY() - 1);
                        BlockState blockState2 = this.currentContext.getBlockState((BlockPos)mutableBlockPos);
                        if (blockState2.isAir() || blockState2.isPathfindable(PathComputationType.WATER)) continue;
                        break;
                    }
                }
            } else {
                while (this.isCanStandOnFluid(blockState.getFluidState())) {
                    blockState = this.currentContext.getBlockState((BlockPos)mutableBlockPos.set(this.mob.getX(), (double)(++i), this.mob.getZ()));
                }
                --i;
            }
        }
        BlockPos blockPos = this.mob.blockPosition();
        if (!this.canStartAt((BlockPos)mutableBlockPos.set(blockPos.getX(), i, blockPos.getZ()))) {
            AABB aABB = this.mob.getBoundingBox();
            if (this.canStartAt((BlockPos)mutableBlockPos.set(aABB.minX, (double)i, aABB.minZ)) || this.canStartAt((BlockPos)mutableBlockPos.set(aABB.minX, (double)i, aABB.maxZ)) || this.canStartAt((BlockPos)mutableBlockPos.set(aABB.maxX, (double)i, aABB.minZ)) || this.canStartAt((BlockPos)mutableBlockPos.set(aABB.maxX, (double)i, aABB.maxZ))) {
                return this.getStartNode((BlockPos)mutableBlockPos);
            }
        }
        return this.getStartNode(new BlockPos(blockPos.getX(), i, blockPos.getZ()));
    }

    protected Node getStartNode(BlockPos pos) {
        Node node = this.getNode(pos);
        node.type = this.getCachedPathType(node.x, node.y, node.z);
        node.costMalus = this.getPathfindingMalus(node.type);
        return node;
    }

    protected boolean canStartAt(BlockPos pos) {
        PathType pathType = this.getCachedPathType(pos.getX(), pos.getY(), pos.getZ());
        return pathType != PathType.OPEN && this.getPathfindingMalus(pathType) >= 0.0f;
    }

    public Target getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    public int getNeighbors(Node[] outputArray, Node node) {
        int i = 0;
        int j = 0;
        PathType pathType = this.getCachedPathType(node.x, node.y + 1, node.z);
        PathType pathType2 = this.getCachedPathType(node.x, node.y, node.z);
        if (this.getPathfindingMalus(pathType) >= 0.0f && pathType2 != PathType.STICKY_HONEY) {
            j = Mth.floor((float)Math.max(1.0f, this.mob.maxUpStep()));
        }
        double d = this.getFloorLevel(new BlockPos(node.x, node.y, node.z));
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Node node2;
            this.reusableNeighbors[direction.get2DDataValue()] = node2 = this.findAcceptedNode(node.x + direction.getStepX(), node.y, node.z + direction.getStepZ(), j, d, direction, pathType2);
            if (!this.isNeighborValid(node2, node)) continue;
            outputArray[i++] = node2;
        }
        for (Direction horizontalDir : Direction.Plane.HORIZONTAL) {
            Node node3;
            Direction direction2 = horizontalDir.getClockWise();
            if (!this.isDiagonalValid(node, this.reusableNeighbors[horizontalDir.get2DDataValue()], this.reusableNeighbors[direction2.get2DDataValue()]) || !this.isDiagonalValid(node3 = this.findAcceptedNode(node.x + horizontalDir.getStepX() + direction2.getStepX(), node.y, node.z + horizontalDir.getStepZ() + direction2.getStepZ(), j, d, horizontalDir, pathType2))) continue;
            outputArray[i++] = node3;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable Node neighbor, Node node) {
        return neighbor != null && !neighbor.closed && (neighbor.costMalus >= 0.0f || node.costMalus < 0.0f);
    }

    protected boolean isDiagonalValid(Node root, @Nullable Node xNode, @Nullable Node zNode) {
        if (zNode == null || xNode == null || zNode.y > root.y || xNode.y > root.y) {
            return false;
        }
        if (xNode.type != PathType.WALKABLE_DOOR && zNode.type != PathType.WALKABLE_DOOR) {
            boolean bl = zNode.type == PathType.FENCE && xNode.type == PathType.FENCE && (double)this.mob.getBbWidth() < 0.5;
            return (zNode.y < root.y || zNode.costMalus >= 0.0f || bl) && (xNode.y < root.y || xNode.costMalus >= 0.0f || bl);
        }
        return false;
    }

    protected boolean isDiagonalValid(@Nullable Node node) {
        if (node == null || node.closed) {
            return false;
        }
        return node.type == PathType.WALKABLE_DOOR ? false : node.costMalus >= 0.0f;
    }

    private static boolean doesBlockHavePartialCollision(PathType pathType) {
        return pathType == PathType.FENCE || pathType == PathType.DOOR_WOOD_CLOSED || pathType == PathType.DOOR_IRON_CLOSED;
    }

    private boolean canReachWithoutCollision(Node node) {
        AABB aABB = this.mob.getBoundingBox();
        Vec3 vec3 = new Vec3((double)node.x - this.mob.getX() + aABB.getXsize() / 2.0, (double)node.y - this.mob.getY() + aABB.getYsize() / 2.0, (double)node.z - this.mob.getZ() + aABB.getZsize() / 2.0);
        int i = Mth.ceil((double)(vec3.length() / aABB.getSize()));
        vec3 = vec3.scale((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.hasCollisions(aABB = aABB.move(vec3))) continue;
            return false;
        }
        return true;
    }

    public static double getFloorLevel(BlockGetter level, BlockPos pos) {
        BlockPos blockPos = pos.below();
        VoxelShape voxelShape = level.getBlockState(blockPos).getCollisionShape(level, blockPos);
        return (double)blockPos.getY() + (voxelShape.isEmpty() ? 0.0 : voxelShape.max(Direction.Axis.Y));
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected Node findAcceptedNode(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, PathType pathType) {
        Node node = null;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        double d = this.getFloorLevel((BlockPos)mutableBlockPos.set(x, y, z));
        if (d - nodeFloorLevel > this.getMobJumpHeight()) {
            return null;
        }
        PathType pathType2 = this.getCachedPathType(x, y, z);
        float f = this.getPathfindingMalus(pathType2);
        if (f >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathType2, f);
        }
        if (BoatNodeEvaluator.doesBlockHavePartialCollision(pathType) && node != null && node.costMalus >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (!(pathType2 == PathType.WALKABLE || this.isAmphibious() && pathType2 == PathType.WATER)) {
            if ((node == null || node.costMalus < 0.0f) && verticalDeltaLimit > 0 && (pathType2 != PathType.FENCE || this.canWalkOverFences()) && pathType2 != PathType.UNPASSABLE_RAIL && pathType2 != PathType.TRAPDOOR && pathType2 != PathType.POWDER_SNOW) {
                node = this.tryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType, mutableBlockPos);
            } else if (!this.isAmphibious() && pathType2 == PathType.WATER && !this.canFloat()) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathType2 == PathType.OPEN) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (BoatNodeEvaluator.doesBlockHavePartialCollision(pathType2) && node == null) {
                node = this.getClosedNode(x, y, z, pathType2);
            }
            return node;
        }
        return node;
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.maxUpStep());
    }

    private Node getNodeAndUpdateCostToMax(int x, int y, int z, PathType pathType, float malus) {
        Node node = this.getNode(x, y, z);
        node.type = pathType;
        node.costMalus = Math.max(node.costMalus, malus);
        return node;
    }

    private Node getBlockedNode(int x, int y, int z) {
        Node node = this.getNode(x, y, z);
        node.type = PathType.BLOCKED;
        node.costMalus = -1.0f;
        return node;
    }

    private Node getClosedNode(int x, int y, int z, PathType pathType) {
        Node node = this.getNode(x, y, z);
        node.closed = true;
        node.type = pathType;
        node.costMalus = pathType.getMalus();
        return node;
    }

    @Nullable
    private Node tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, PathType pathType, BlockPos.MutableBlockPos pos) {
        Node node = this.findAcceptedNode(x, y + 1, z, verticalDeltaLimit - 1, nodeFloorLevel, direction, pathType);
        if (node == null) {
            return null;
        }
        if (this.mob.getBbWidth() >= 1.0f) {
            return node;
        }
        if (node.type != PathType.OPEN && node.type != PathType.WALKABLE) {
            return node;
        }
        double d = (double)(x - direction.getStepX()) + 0.5;
        double e = (double)(z - direction.getStepZ()) + 0.5;
        double f = (double)this.mob.getBbWidth() / 2.0;
        AABB aABB = new AABB(d - f, this.getFloorLevel((BlockPos)pos.set(d, (double)(y + 1), e)) + 0.001, e - f, d + f, (double)this.mob.getBbHeight() + this.getFloorLevel((BlockPos)pos.set((double)node.x, (double)node.y, (double)node.z)) - 0.002, e + f);
        return this.hasCollisions(aABB) ? null : node;
    }

    @Nullable
    private Node tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable Node node) {
        --y;
        while (y > this.mob.level().getMinBuildHeight()) {
            PathType pathType = this.getCachedPathType(x, y, z);
            if (pathType != PathType.WATER) {
                return node;
            }
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathType, this.getPathfindingMalus(pathType));
            --y;
        }
        return node;
    }

    private Node tryFindFirstGroundNodeBelow(int x, int y, int z) {
        for (int i = y - 1; i >= this.mob.level().getMinBuildHeight(); --i) {
            if (y - i > this.mob.getMaxFallDistance()) {
                return this.getBlockedNode(x, i, z);
            }
            PathType pathType = this.getCachedPathType(x, i, z);
            float f = this.getPathfindingMalus(pathType);
            if (pathType == PathType.OPEN) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, pathType, f);
            }
            return this.getBlockedNode(x, i, z);
        }
        return this.getBlockedNode(x, y, z);
    }

    private boolean hasCollisions(AABB boundingBox) {
        return this.collisionCache.computeIfAbsent((Object)boundingBox, object -> !this.currentContext.level().noCollision((Entity)this.mob, boundingBox));
    }

    protected PathType getCachedPathType(int x, int y, int z) {
        return (PathType)this.pathTypesByPosCacheByMob.computeIfAbsent(BlockPos.asLong((int)x, (int)y, (int)z), l -> this.getPathTypeOfMob(this.currentContext, x, y, z, this.mob));
    }

    public PathType getPathTypeOfMob(PathfindingContext context, int x, int y, int z, Mob mob) {
        Set<PathType> set = this.getPathTypeWithinMobBB(context, x, y, z);
        if (set.contains(PathType.FENCE)) {
            return PathType.FENCE;
        }
        if (set.contains(PathType.UNPASSABLE_RAIL)) {
            return PathType.UNPASSABLE_RAIL;
        }
        PathType pathType = PathType.BLOCKED;
        for (PathType pathType2 : set) {
            if (mob.getPathfindingMalus(pathType2) < 0.0f) {
                return pathType2;
            }
            if (!(mob.getPathfindingMalus(pathType2) >= mob.getPathfindingMalus(pathType))) continue;
            pathType = pathType2;
        }
        return this.entityWidth <= 1 && pathType != PathType.OPEN && mob.getPathfindingMalus(pathType) == 0.0f && this.getPathType(context, x, y, z) == PathType.OPEN ? PathType.OPEN : pathType;
    }

    public Set<PathType> getPathTypeWithinMobBB(PathfindingContext context, int x, int y, int z) {
        EnumSet<PathType> enumSet = EnumSet.noneOf(PathType.class);
        for (int i = 0; i < this.entityWidth; ++i) {
            for (int j = 0; j < this.entityHeight; ++j) {
                for (int k = 0; k < this.entityDepth; ++k) {
                    int l = i + x;
                    int m = j + y;
                    int n = k + z;
                    PathType pathType = this.getPathType(context, l, m, n);
                    BlockPos blockPos = this.mob.blockPosition();
                    boolean bl = this.canPassDoors();
                    if (pathType == PathType.DOOR_WOOD_CLOSED && this.canOpenDoors() && bl) {
                        pathType = PathType.WALKABLE_DOOR;
                    }
                    if (pathType == PathType.DOOR_OPEN && !bl) {
                        pathType = PathType.BLOCKED;
                    }
                    if (pathType == PathType.RAIL && this.getPathType(context, blockPos.getX(), blockPos.getY(), blockPos.getZ()) != PathType.RAIL && this.getPathType(context, blockPos.getX(), blockPos.getY() - 1, blockPos.getZ()) != PathType.RAIL) {
                        pathType = PathType.UNPASSABLE_RAIL;
                    }
                    enumSet.add(pathType);
                }
            }
        }
        return enumSet;
    }

    public PathType getPathType(PathfindingContext context, int x, int y, int z) {
        return BoatNodeEvaluator.getPathTypeStatic(context, new BlockPos.MutableBlockPos(x, y, z));
    }

    public static PathType getPathTypeStatic(Mob mob, BlockPos pos) {
        return BoatNodeEvaluator.getPathTypeStatic(new PathfindingContext((CollisionGetter)mob.level(), mob), pos.mutable());
    }

    public static PathType getPathTypeStatic(PathfindingContext context, BlockPos.MutableBlockPos pos) {
        int k;
        int j;
        int i = pos.getX();
        PathType pathType = context.getPathTypeFromState(i, j = pos.getY(), k = pos.getZ());
        if (pathType == PathType.OPEN && j >= context.level().getMinBuildHeight() + 1) {
            return switch (context.getPathTypeFromState(i, j - 1, k)) {
                case PathType.OPEN, PathType.WATER, PathType.LAVA, PathType.WALKABLE -> PathType.OPEN;
                case PathType.DAMAGE_FIRE -> PathType.DAMAGE_FIRE;
                case PathType.DAMAGE_OTHER -> PathType.DAMAGE_OTHER;
                case PathType.STICKY_HONEY -> PathType.STICKY_HONEY;
                case PathType.POWDER_SNOW -> PathType.DANGER_POWDER_SNOW;
                case PathType.DAMAGE_CAUTIOUS -> PathType.DAMAGE_CAUTIOUS;
                case PathType.TRAPDOOR -> PathType.DANGER_TRAPDOOR;
                default -> BoatNodeEvaluator.checkNeighbourBlocks(context, i, j, k, PathType.WALKABLE);
            };
        }
        return pathType;
    }

    public static PathType checkNeighbourBlocks(PathfindingContext context, int x, int y, int z, PathType pathType) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    PathType pathType2 = context.getPathTypeFromState(x + i, y + j, z + k);
                    if (pathType2 == PathType.DAMAGE_OTHER) {
                        return PathType.DANGER_OTHER;
                    }
                    if (pathType2 == PathType.DAMAGE_FIRE || pathType2 == PathType.LAVA) {
                        return PathType.DANGER_FIRE;
                    }
                    if (pathType2 == PathType.WATER) {
                        return PathType.WATER_BORDER;
                    }
                    if (pathType2 != PathType.DAMAGE_CAUTIOUS) continue;
                    return PathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return pathType;
    }
}

