/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import java.util.EnumSet;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.entities.goals.PlundererAICommon;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class UseCannonBoatGoal
extends Goal {
    private final int maxTimeWithoutShooting;
    private final int minCannonRange;
    private final int shootingCooldownMin;
    private final int shootingCooldownMax;
    private final Mob mob;
    private final int maxUseTime;
    private int time;
    @Nullable
    private LivingEntity target;
    private int igniteCannonCooldown;
    private int ticksSinceShot;
    private CannonAccess access;

    @Deprecated(forRemoval=true)
    public UseCannonBoatGoal(Mob mob, int a, int b, int minRange, int maxDuration) {
        this(mob, maxDuration, minRange, a, b, 300);
    }

    public UseCannonBoatGoal(Mob mob) {
        this(mob, 300, 16, 50, 80, 300);
    }

    public UseCannonBoatGoal(Mob mob, int maxDuration, int minRange, int minShootingCooldown, int maxShootingCooldown, int maxTimeWithoutShooting) {
        this.mob = mob;
        this.maxUseTime = maxDuration;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.minCannonRange = minRange;
        this.shootingCooldownMin = minShootingCooldown;
        this.shootingCooldownMax = maxShootingCooldown;
        this.maxTimeWithoutShooting = maxTimeWithoutShooting;
    }

    public boolean canUse() {
        CannonAccess ac;
        if (this.mob.getNavigation().isStuck()) {
            return false;
        }
        Entity entity = this.mob.getControlledVehicle();
        if (entity instanceof CannonAccess && (ac = (CannonAccess)entity).getInternalCannon().hasSomeFuelAndProjectiles() && PlundererAICommon.hasValidTargetInCannonRange(this.mob, this.minCannonRange)) {
            this.access = ac;
            this.target = this.mob.getTarget();
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.time < this.maxUseTime && this.ticksSinceShot < this.maxTimeWithoutShooting;
    }

    public void stop() {
        this.target = null;
        this.access = null;
        this.ticksSinceShot = 0;
        this.igniteCannonCooldown = 0;
        this.time = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        ++this.time;
        this.mob.getLookControl().setLookAt((Entity)this.target, 90.0f, 90.0f);
        ++this.ticksSinceShot;
        if (this.igniteCannonCooldown > 0) {
            --this.igniteCannonCooldown;
        }
        if (PlundererAICommon.aimCannonAndShoot(this.access, this.mob, this.target, this.igniteCannonCooldown <= 0)) {
            this.igniteCannonCooldown = this.shootCooldown();
            this.ticksSinceShot = 0;
        }
    }

    private int shootCooldown() {
        return Mth.randomBetweenInclusive((RandomSource)this.mob.getRandom(), (int)this.shootingCooldownMin, (int)this.shootingCooldownMax);
    }
}

