/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.neoforge;

import com.mojang.datafixers.util.Either;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.hud.SelectableContainerItemHud;
import net.mehvahdjukaar.supplementaries.common.events.ClientEvents;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.components.SelectableContainerContent;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.PaintingTooltip;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.SherdTooltip;
import net.mehvahdjukaar.supplementaries.common.misc.songs.SongsManager;
import net.mehvahdjukaar.supplementaries.common.utils.IQuiverPlayer;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundSourceEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class ClientEventsForge {
    private static boolean firstScreenShown;
    static boolean mutex;

    public static void init() {
        NeoForge.EVENT_BUS.register(ClientEventsForge.class);
    }

    @SubscribeEvent
    public static void onScreenDrawPost(ScreenEvent.Init.Post event) {
        if (!firstScreenShown && event.getScreen() instanceof TitleScreen) {
            ClientEvents.onFirstScreen(event.getScreen());
            firstScreenShown = true;
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (event.getEntity() != null) {
            ClientEvents.onItemTooltip(event.getItemStack(), event.getContext(), event.getFlags(), event.getToolTip());
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (CompatHandler.CONFIGURED) {
            ClientEvents.addConfigButton(event.getScreen(), event.getListenersList(), arg_0 -> ((ScreenEvent.Init.Post)event).addListener(arg_0));
        }
    }

    @SubscribeEvent
    public static void onClientEndTick(ClientTickEvent.Post event) {
        ClientEvents.onClientTick(Minecraft.getInstance());
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.Key event) {
        LocalPlayer localPlayer;
        Minecraft mc = Minecraft.getInstance();
        int action = event.getAction();
        if (mc.screen == null && ClientRegistry.QUIVER_KEYBIND.matches(event.getKey(), event.getScanCode()) && (localPlayer = mc.player) instanceof IQuiverPlayer) {
            IQuiverPlayer qe = (IQuiverPlayer)localPlayer;
            if (action == 2 || action == 1) {
                SelectableContainerItemHud.getInstance().setUsingKeybind(qe.supplementaries$getQuiverSlot(), (Player)mc.player);
            } else if (action == 0) {
                SelectableContainerItemHud.getInstance().setUsingKeybind(SlotReference.EMPTY, (Player)mc.player);
            }
        }
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollingEvent event) {
        if (ClientEvents.onMouseScrolled(event.getScrollDeltaY())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isAttack() && CannonController.onPlayerAttack()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        } else if (event.isUseItem() && CannonController.onPlayerUse()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (CannonController.isActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlayPre(RenderGuiLayerEvent.Pre event) {
        ResourceLocation overlay;
        if (CannonController.cancelsXPBar() && (overlay = event.getName()) == VanillaGuiLayers.EXPERIENCE_BAR) {
            event.setCanceled(true);
        }
        if (CannonController.cancelsHotBar() && (overlay = event.getName()) == VanillaGuiLayers.HOTBAR) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        double wobble = ClientEvents.getRopeWobble(event.getPartialTick());
        if (wobble != 0.0) {
            event.setRoll((float)((double)event.getRoll() + wobble));
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(ScreenEvent.Opening event) {
        Screen screen;
        if (!mutex && event.getNewScreen() instanceof DeathScreen && (screen = event.getCurrentScreen()) instanceof ChatScreen) {
            ChatScreen cs = (ChatScreen)screen;
            if (ClientConfigs.Tweaks.DEATH_CHAT.get().booleanValue()) {
                mutex = true;
                cs.charTyped('-', 0);
                cs.keyPressed(257, 0, 0);
                mutex = false;
            }
        }
    }

    @SubscribeEvent
    public static void onSoundPlay(PlaySoundSourceEvent event) {
        SongsManager.recordNoteFromSound(event.getSound(), event.getName());
    }

    @SubscribeEvent
    public static void onGatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        CustomData customData;
        ResourceKey pattern;
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        Item i = stack.getItem();
        if (ClientConfigs.Tweaks.SHERDS_TOOLTIPS.get().booleanValue() && (pattern = DecoratedPotPatterns.getPatternFromItem((Item)i)) != null && i != Items.BRICK) {
            event.getTooltipElements().add(Either.right((Object)new SherdTooltip((ResourceKey<DecoratedPotPattern>)pattern)));
        }
        if (ClientConfigs.Tweaks.PAINTINGS_TOOLTIPS.get().booleanValue() && i instanceof HangingEntityItem && !(customData = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).isEmpty() && customData.contains("variant")) {
            event.getTooltipElements().add(Either.right((Object)new PaintingTooltip(customData)));
        }
    }

    @SubscribeEvent
    public static void onRenderOutline(RenderHighlightEvent.Block event) {
        if (CannonController.isActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAddTooltips(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof SelectableContainerItem) {
            SelectableContainerItem si = (SelectableContainerItem)item;
            SelectableContainerContent data = (SelectableContainerContent)stack.get(si.getComponentType());
            if (data == null) {
                return;
            }
            ItemStack selected = data.getSelected();
            if (selected.getItem() instanceof SelectableContainerItem) {
                return;
            }
            RenderTooltipEvent.GatherComponents newEvent = new RenderTooltipEvent.GatherComponents(selected, event.getScreenWidth(), event.getScreenHeight(), event.getTooltipElements(), event.getMaxWidth());
            NeoForge.EVENT_BUS.post((Event)newEvent);
        }
    }

    static {
        mutex = false;
    }
}

