/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.common.items.components.ConfettiColors;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfettiPopperItem
extends BlockItem {
    public ConfettiPopperItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        return (context.isSecondaryUseActive() || context.canPlace() && context.getLevel().getBlockState(context.getClickedPos()).is(this.getBlock())) && super.canPlace(context, state);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, InteractionHand hand) {
        VibeChecker.assertSameLevel(level, player);
        ItemStack heldItem = player.getItemInHand(hand);
        Vec3 pos = player.getEyePosition().add(player.getLookAngle().scale(0.2)).add(0.0, -0.25, 0.0);
        float oldRot = player.getXRot();
        player.setXRot((float)((double)oldRot - 20.0 * Math.cos(oldRot * ((float)Math.PI / 180))));
        Vec3 dir = player.getLookAngle();
        ClientBoundParticlePacket packet = ConfettiPopperItem.getConfettiPacket(heldItem, pos, dir);
        player.setXRot(oldRot);
        if (!level.isClientSide) {
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)player, (CustomPacketPayload)packet);
            level.gameEvent((Entity)player, (Holder)GameEvent.EXPLODE, player.position());
        } else {
            ClientReceivers.spawnConfettiParticles(packet, level, level.random);
        }
        heldItem.consume(1, (LivingEntity)player);
        return InteractionResultHolder.sidedSuccess((Object)heldItem, (boolean)level.isClientSide);
    }

    @NotNull
    public static ClientBoundParticlePacket getConfettiPacket(ItemStack heldItem, Vec3 pos, Vec3 dir) {
        ConfettiColors colorsComp = (ConfettiColors)heldItem.get(ModComponents.CONFETTI_COLORS.get());
        int[] colors = colorsComp != null ? colorsComp.getColors().stream().mapToInt(i -> i).toArray() : new int[]{};
        return new ClientBoundParticlePacket(pos, ClientBoundParticlePacket.Kind.CONFETTI, dir, colors);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand usedHand) {
        if (entity.getType() == EntityType.CREEPER && entity instanceof Creeper) {
            Creeper c = (Creeper)entity;
            if (entity instanceof IPartyCreeper) {
                IPartyCreeper pc = (IPartyCreeper)entity;
                if (!c.isIgnited() && !pc.supplementaries$isFestive()) {
                    pc.supplementaries$setFestive(true);
                    stack.consume(1, (LivingEntity)player);
                    return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
                }
            }
        }
        return super.interactLivingEntity(stack, player, entity, usedHand);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ConfettiColors colorsComp = (ConfettiColors)stack.get(ModComponents.CONFETTI_COLORS.get());
        if (colorsComp != null) {
            colorsComp.addToTooltip(context, tooltipComponents::add, tooltipFlag);
        }
    }
}

