/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.particles.CannonFireParticle;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.PlayerSuggestionBoxWidget;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlintBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MovingSlidyBlock;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonUtils;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimesManager;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.MovingSlidyBlockEntity;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBallEntity;
import net.mehvahdjukaar.supplementaries.common.entities.IFluteParrot;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.common.inventories.RedMerchantMenu;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.common.items.SongInstrumentItem;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.CannonBallExplosion;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.IMobContainerProvider;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundCannonAnimationPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundCannonballExplosionPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundControlCannonPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundDisplayClockTimePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundFinalizeBookDataPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundFluteParrotsPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySpeakerMessagePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendCapturedMobsPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendHourglassDataPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSetSlidingBlockEntityPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncTradesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundUpdateCannonBoatPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncEquippedQuiverPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncPartyCreeperPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ClientReceivers {
    private static void withPlayerDo(Consumer<Player> action) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            action.accept((Player)player);
        }
    }

    private static void withLevelDo(Consumer<Level> action) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            action.accept((Level)level);
        }
    }

    public static void handlePlaySpeakerMessagePacket(ClientBoundPlaySpeakerMessagePacket message) {
        Component str;
        SpeakerBlockTile.Mode mode = message.mode;
        Component component = str = Minecraft.getInstance().isTextFilteringEnabled() ? message.filtered : message.message;
        if (mode == SpeakerBlockTile.Mode.NARRATOR && !ClientConfigs.Blocks.SPEAKER_BLOCK_MUTE.get().booleanValue()) {
            Minecraft.getInstance().getNarrator().narrator.say(str.getString(), true);
        } else if (mode == SpeakerBlockTile.Mode.TITLE) {
            Gui gui = Minecraft.getInstance().gui;
            gui.clear();
            gui.resetTitleTimes();
            gui.setTitle(str);
        } else {
            ClientReceivers.withPlayerDo(p -> p.displayClientMessage(str, mode == SpeakerBlockTile.Mode.STATUS_MESSAGE));
        }
    }

    public static void handleSendBombKnockbackPacket(ClientBoundSendKnockbackPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.getEntity(message.id());
            if (e != null) {
                e.addDeltaMovement(message.knockback());
            }
        });
    }

    public static void handleLoginPacket(ClientBoundSendLoginPacket message) {
        ClientReceivers.withPlayerDo(p -> PlayerSuggestionBoxWidget.setUsernameCache(message.usernameCache()));
    }

    public static void handleSpawnBlockParticlePacket(ClientBoundParticlePacket message) {
        ClientReceivers.withLevelDo(l -> {
            RandomSource ran = l.random;
            switch (message.type) {
                case BOMB_EXPLOSION: {
                    Integer radius = message.getFirstExtraData();
                    if (radius == null) break;
                    l.addParticle((ParticleOptions)ModParticles.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), message.pos.x, message.pos.y, message.pos.z, (double)radius.intValue(), 0.0, 0.0);
                    break;
                }
                case BUBBLE_BLOW: {
                    ParticleUtil.spawnParticlesOnBlockFaces((Level)l, (BlockPos)BlockPos.containing((Position)message.pos), (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (UniformInt)UniformInt.of((int)2, (int)4), (float)0.001f, (float)0.01f, (boolean)true);
                    break;
                }
                case BUBBLE_CLEAN: {
                    ParticleUtil.spawnParticleOnBlockShape((Level)l, (BlockPos)BlockPos.containing((Position)message.pos), (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (UniformInt)UniformInt.of((int)2, (int)4), (float)0.01f);
                    break;
                }
                case WAX_ON: {
                    ParticleUtil.spawnParticleOnBlockShape((Level)l, (BlockPos)BlockPos.containing((Position)message.pos), (ParticleOptions)ParticleTypes.WAX_ON, (UniformInt)UniformInt.of((int)3, (int)5), (float)0.01f);
                    break;
                }
                case GLOW_ON: {
                    ParticleUtil.spawnParticleOnBlockShape((Level)l, (BlockPos)BlockPos.containing((Position)message.pos), (ParticleOptions)ParticleTypes.GLOW, (UniformInt)UniformInt.of((int)3, (int)5), (float)0.0f);
                    break;
                }
                case BUBBLE_CLEAN_ENTITY: {
                    Entity e;
                    if (message.getFirstExtraData() == null || (e = l.getEntity(message.getFirstExtraData().intValue())) == null) break;
                    ParticleUtil.spawnParticleOnBoundingBox((AABB)e.getBoundingBox(), (Level)l, (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (UniformInt)UniformInt.of((int)2, (int)4), (float)0.01f);
                    break;
                }
                case BUBBLE_EAT: {
                    Entity entity = l.getEntity(message.getFirstExtraData().intValue());
                    Vec3 v = message.dir.normalize();
                    double x = entity.getX() + v.x;
                    double y = entity.getEyeY() + v.y - 0.12;
                    double z = entity.getZ() + v.z;
                    for (int j = 0; j < 4; ++j) {
                        v = v.scale(0.1 + (double)(ran.nextFloat() * 0.1f));
                        double dx = v.x + (0.5 - (double)ran.nextFloat()) * 0.9;
                        double dy = v.y + (0.5 - (double)ran.nextFloat()) * 0.06;
                        double dz = v.z + (0.5 - (double)ran.nextFloat()) * 0.9;
                        l.addParticle((ParticleOptions)ModParticles.SUDS_PARTICLE.get(), x, y, z, dx, dy, dz);
                    }
                    break;
                }
                case DISPENSER_MINECART: {
                    boolean j1 = false;
                    boolean j2 = true;
                    boolean k2 = false;
                    double d18 = message.pos.x + (double)j1 * 0.6;
                    double d24 = message.pos.y + (double)j2 * 0.6;
                    double d28 = message.pos.z + (double)k2 * 0.6;
                    for (int i3 = 0; i3 < 10; ++i3) {
                        double d4 = ran.nextDouble() * 0.2 + 0.01;
                        double d6 = d18 + (double)j1 * 0.01 + (ran.nextDouble() - 0.5) * (double)k2 * 0.5;
                        double d8 = d24 + (double)j2 * 0.01 + (ran.nextDouble() - 0.5) * (double)j2 * 0.5;
                        double d30 = d28 + (double)k2 * 0.01 + (ran.nextDouble() - 0.5) * (double)j1 * 0.5;
                        double d9 = (double)j1 * d4 + ran.nextGaussian() * 0.01;
                        double d10 = (double)j2 * d4 + ran.nextGaussian() * 0.01;
                        double d11 = (double)k2 * d4 + ran.nextGaussian() * 0.01;
                        l.addParticle((ParticleOptions)ParticleTypes.SMOKE, d6, d8, d30, d9, d10, d11);
                    }
                    break;
                }
                case FLINT_BLOCK_IGNITE: {
                    if (message.getFirstExtraData() == null || message.pos == null) break;
                    boolean isIronMoving = message.getFirstExtraData() == 1;
                    BlockPos pos = BlockPos.containing((Position)message.pos);
                    for (Direction ironDir : Direction.values()) {
                        BlockPos facingPos = pos.relative(ironDir);
                        BlockState facingState = l.getBlockState(facingPos);
                        if (!(isIronMoving ? facingState.is(ModRegistry.FLINT_BLOCK.get()) : FlintBlock.canBlockCreateSpark(facingState, l, facingPos, ironDir.getOpposite()))) continue;
                        for (int i = 0; i < 6; ++i) {
                            ParticleUtil.spawnParticleOnFace((Level)l, (BlockPos)facingPos, (Direction)ironDir.getOpposite(), (ParticleOptions)ParticleTypes.CRIT, (float)-0.5f, (float)0.5f, (boolean)false);
                        }
                    }
                    break;
                }
                case CONFETTI: {
                    ClientReceivers.spawnConfettiParticles(message, l, ran);
                    break;
                }
                case CONFETTI_EXPLOSION: {
                    int radius = message.getFirstExtraData();
                    ParticleUtil.spawnParticleInASphere((Level)l, (double)message.pos.x, (double)(message.pos.y + 1.0), (double)message.pos.z, () -> ran.nextInt(6) == 0 ? (ParticleOptions)ModParticles.STREAMER_PARTICLE.get() : (ParticleOptions)ModParticles.CONFETTI_PARTICLE.get(), (int)(radius * 40), (float)((float)radius / 9.0f), (float)0.05f, (float)(0.15f * (float)radius / 3.0f));
                    l.playLocalSound(message.pos.x, message.pos.y, message.pos.z, ModSounds.CONFETTI_POPPER.get(), SoundSource.HOSTILE, 4.0f, ran.nextFloat() * 0.2f + 0.5f, false);
                    break;
                }
                case FEATHER: {
                    int amount = message.getFirstExtraData() == null ? 1 : message.getFirstExtraData();
                    double dy = Mth.clamp((double)(0.03 * message.dir.y / 7.0), (double)0.03, (double)0.055);
                    for (int i = 0; i < amount; ++i) {
                        l.addParticle((ParticleOptions)ModParticles.FEATHER_PARTICLE.get(), message.pos.x + ran.nextGaussian() * 0.35, message.pos.y, message.pos.z + ran.nextGaussian() * 0.35, ran.nextGaussian() * 0.007, dy * 0.5, ran.nextGaussian() * 0.007);
                    }
                    break;
                }
                case WRENCH_ROTATION: {
                    if (!ClientConfigs.Items.WRENCH_PARTICLES.get().booleanValue()) break;
                    l.addParticle((ParticleOptions)ModParticles.ROTATION_TRAIL_EMITTER.get(), message.pos.x(), message.pos.y(), message.pos.z(), (double)message.getFirstExtraData().intValue(), 0.71, -1.0);
                    break;
                }
                case PEARL_TELEPORT: {
                    Vec3 start = message.pos;
                    Vec3 end = message.dir;
                    for (int j = 0; j < 64; ++j) {
                        double delta = ran.nextDouble();
                        float f = (ran.nextFloat() - 0.5f) * 0.2f;
                        float f1 = (ran.nextFloat() - 0.5f) * 0.2f;
                        float f2 = (ran.nextFloat() - 0.5f) * 0.2f;
                        double dx = Mth.lerp((double)delta, (double)end.x(), (double)start.x()) + (ran.nextDouble() - 0.5);
                        double dy = Mth.lerp((double)delta, (double)end.y(), (double)start.y()) + (ran.nextDouble() - 0.5) - 0.5;
                        double dz = Mth.lerp((double)delta, (double)end.z(), (double)start.z()) + (ran.nextDouble() - 0.5);
                        l.addParticle((ParticleOptions)ParticleTypes.PORTAL, dx, dy, dz, (double)f, (double)f1, (double)f2);
                    }
                    break;
                }
            }
        });
    }

    public static void spawnConfettiParticles(ClientBoundParticlePacket message, Level l, RandomSource ran) {
        float spread = 0.1f;
        Vec3 dir = message.dir;
        Vec3 pos = message.pos;
        float scale = (float)dir.length();
        for (int j = 0; j < 60; ++j) {
            Vector3f facingDir = ClientReceivers.randomizeVector(ran, dir, spread).mul(scale * Mth.nextFloat((RandomSource)ran, (float)0.3f, (float)0.7f));
            ParticleOptions p = ClientReceivers.makeConfettiParticle(ran, message.getExtraData());
            l.addParticle(p, pos.x, pos.y, pos.z, (double)facingDir.x, (double)facingDir.y, (double)facingDir.z);
        }
        l.playLocalSound(message.pos.x, message.pos.y, message.pos.z, ModSounds.CONFETTI_POPPER.get(), SoundSource.PLAYERS, 1.0f, ran.nextFloat() * 0.2f + 0.8f, false);
    }

    private static ParticleOptions makeConfettiParticle(RandomSource ran, List<Integer> colors) {
        boolean streamer;
        boolean bl = streamer = ran.nextInt(6) == 0;
        if (colors.isEmpty()) {
            return streamer ? (ParticleOptions)ModParticles.STREAMER_PARTICLE.get() : (ParticleOptions)ModParticles.CONFETTI_PARTICLE.get();
        }
        int pickedColor = colors.get(ran.nextInt(colors.size()));
        return streamer ? ColorParticleOption.create(ModParticles.STREAMER_PARTICLE_DYED.get(), (int)pickedColor) : ColorParticleOption.create(ModParticles.CONFETTI_PARTICLE_DYED.get(), (int)pickedColor);
    }

    public static void handleSetSlidingBlockEntityPacket(ClientBoundSetSlidingBlockEntityPacket m) {
        ClientReceivers.withLevelDo(l -> {
            if (!(l.getBlockEntity(m.pos()) instanceof MovingSlidyBlockEntity)) {
                BlockPos pos = m.pos();
                l.setBlock(m.pos(), m.state(), 64);
                Direction direction = m.direction();
                MovingSlidyBlockEntity be = MovingSlidyBlock.newMovingBlockEntity(pos, m.state(), m.movedState(), direction);
                l.setBlockEntity((BlockEntity)be);
            }
        });
    }

    public static void handleSyncHourglassData(ClientBoundSendHourglassDataPacket packet) {
        ClientReceivers.withLevelDo(l -> {
            HourglassTimesManager.getInstance(l).setData(packet.hourglassTimes);
            Supplementaries.LOGGER.info("Synced Hourglass data");
        });
    }

    public static void handleSyncCapturedMobs(ClientBoundSendCapturedMobsPacket packet) {
        ClientReceivers.withLevelDo(l -> {
            CapturedMobHandler.getInstance(l).acceptData(packet.mobSet, packet.fish);
            Supplementaries.LOGGER.info("Synced Captured Mobs settings");
        });
    }

    public static void handleSyncCannonBoat(ClientBoundUpdateCannonBoatPacket packet) {
        ClientReceivers.withLevelDo(l -> {
            CannonAccess access = CannonAccess.find(l, packet.target());
            if (access != null) {
                access.getInternalCannon().loadWithComponents(packet.tileTag(), (HolderLookup.Provider)l.registryAccess());
            }
        });
    }

    public static void handleFinalizeBookData(ClientBoundFinalizeBookDataPacket message) {
        ClientReceivers.withLevelDo(l -> PlaceableBookManager.registerBookPlacements(l.registryAccess()));
    }

    public static void showTime(ClientBoundDisplayClockTimePacket message) {
        ClientReceivers.withPlayerDo(p -> {
            int time;
            Optional<Long> tOpt = message.time;
            Object ob = "";
            Object br = "";
            if (tOpt.isEmpty()) {
                time = p.getRandom().nextInt(24000);
                ob = (String)ob + String.valueOf(ChatFormatting.OBFUSCATED);
                br = (String)br + String.valueOf(ChatFormatting.RESET);
            } else {
                time = (int)(tOpt.get() + 6000L) % 24000;
            }
            int minutes = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
            int hours = time / 1000;
            String postfix = "";
            if (!ClientConfigs.Blocks.CLOCK_24H.get().booleanValue()) {
                String string = postfix = time < 12000 ? " AM" : " PM";
                if ((hours %= 12) == 0) {
                    hours = 12;
                }
            }
            String text = (String)ob + hours + (String)br + ":" + (String)ob + String.format("%02d", minutes) + (String)br + postfix;
            p.displayClientMessage((Component)Component.literal((String)text), true);
        });
    }

    private double r(RandomSource random, double a) {
        return a * (double)(random.nextFloat() + random.nextFloat() - 1.0f);
    }

    public static Vector3f randomizeVector(RandomSource random, Vec3 mean, float spread) {
        Vector3f facing = mean.toVector3f();
        Vector3f ort = ClientReceivers.findOrthogonalVector(facing);
        ort.rotateAxis(random.nextFloat() * ((float)Math.PI * 2), facing.x, facing.y, facing.z);
        ort.mul((float)(random.nextGaussian() * (double)spread));
        facing.add((Vector3fc)ort).normalize();
        return facing;
    }

    private static Vector3f findOrthogonalVector(Vector3f v) {
        if (Math.abs(v.x) > Math.abs(v.y)) {
            return new Vector3f(-v.z, 0.0f, v.x).normalize();
        }
        return new Vector3f(0.0f, v.z, -v.y).normalize();
    }

    public static void handleSyncAntiqueInkPacket(ClientBoundSyncAntiqueInk message) {
        ClientReceivers.withLevelDo(l -> {
            BlockEntity tile = l.getBlockEntity(message.pos());
            if (tile != null) {
                AntiqueInkItem.setAntiqueInk(tile, message.ink());
            }
        });
    }

    public static void handlePlaySongNotesPacket(ClientBoundPlaySongNotesPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Player p;
            Item patt0$temp;
            Entity e = l.getEntity(message.entityID());
            if (e instanceof Player && (patt0$temp = (p = (Player)e).getUseItem().getItem()) instanceof SongInstrumentItem) {
                SongInstrumentItem instrumentItem = (SongInstrumentItem)patt0$temp;
                IntListIterator intListIterator = message.notes().iterator();
                while (intListIterator.hasNext()) {
                    int note = (Integer)intListIterator.next();
                    if (note <= 0) continue;
                    l.playSound((Player)Minecraft.getInstance().player, p.getX(), p.getY(), p.getZ(), instrumentItem.getSound(), SoundSource.PLAYERS, instrumentItem.getVolume(), instrumentItem.getPitch(note));
                    instrumentItem.spawnNoteParticle((Level)l, (LivingEntity)p, note);
                }
            }
        });
    }

    public static void handleSyncTradesPacket(ClientBoundSyncTradesPacket message) {
        ClientReceivers.withPlayerDo(p -> {
            AbstractContainerMenu container = p.containerMenu;
            if (message.containerId == container.containerId && container instanceof RedMerchantMenu) {
                RedMerchantMenu containerMenu = (RedMerchantMenu)container;
                containerMenu.setOffers(message.offers);
                containerMenu.setXp(message.villagerXp);
                containerMenu.setMerchantLevel(message.villagerLevel);
                containerMenu.setShowProgressBar(message.showProgress);
                containerMenu.setCanRestock(message.canRestock);
            }
        });
    }

    public static void handleSyncQuiverPacket(SyncEquippedQuiverPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.getEntity(message.entityID());
            if (e instanceof IQuiverEntity) {
                IQuiverEntity qe = (IQuiverEntity)e;
                qe.supplementaries$setQuiver(message.heldQuiver());
            }
        });
    }

    public static void handleSyncPartyCreeper(SyncPartyCreeperPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.getEntity(message.entityID());
            if (e instanceof IPartyCreeper) {
                IPartyCreeper le = (IPartyCreeper)e;
                le.supplementaries$setFestive(message.on());
            }
        });
    }

    public static void handleParrotPacket(ClientBoundFluteParrotsPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.getEntity(message.playerId());
            if (e == null) {
                Supplementaries.LOGGER.error("Entity not found for parrot packet");
                return;
            }
            if (message.playing() && e instanceof Player) {
                Player p = (Player)e;
                BlockPos pos = e.blockPosition();
                List list = l.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(3.0));
                for (LivingEntity livingEntity : list) {
                    if (!(livingEntity instanceof IFluteParrot)) continue;
                    IFluteParrot fp = (IFluteParrot)livingEntity;
                    fp.supplementaries$setPartyByFlute(p);
                }
            }
            ClientReceivers.setDisplayParrotsPartying(l, (Either<Player, BlockPos>)Either.left((Object)((Player)e)), message.playing());
        });
    }

    public static void setDisplayParrotsPartying(Level level, Either<Player, BlockPos> source, boolean isPartying) {
        BlockPos pos = source.right().isPresent() ? (BlockPos)source.right().get() : ((Player)source.left().get()).blockPosition();
        List list = level.getEntitiesOfClass(Player.class, new AABB(pos).inflate(3.0));
        for (Player player : list) {
            CompoundTag r;
            CompoundTag l = player.getShoulderEntityLeft();
            if (!l.isEmpty()) {
                l.putBoolean("record_playing", isPartying);
            }
            if ((r = player.getShoulderEntityRight()).isEmpty()) continue;
            r.putBoolean("record_playing", isPartying);
        }
        Player p = source.left().orElse(null);
        int r = 3;
        BlockPos.MutableBlockPos mut = pos.mutable();
        for (int x = pos.getX() - r; x < pos.getX() + r; ++x) {
            for (int y = pos.getY() - r; y < pos.getY() + r; ++y) {
                for (int z = pos.getZ() - r; z < pos.getZ() + r; ++z) {
                    BlockPos.MutableBlockPos ppp = mut.set(x, y, z);
                    BlockEntity blockEntity = level.getBlockEntity((BlockPos)ppp);
                    if (!(blockEntity instanceof IMobContainerProvider)) continue;
                    IMobContainerProvider te = (IMobContainerProvider)blockEntity;
                    MobContainer container = te.getMobContainer();
                    Entity e = container.getDisplayedMob(level, ppp.immutable());
                    if (p == null && e instanceof LivingEntity) {
                        LivingEntity le = (LivingEntity)e;
                        le.setRecordPlayingNearby(pos, isPartying);
                        continue;
                    }
                    if (p == null || !(e instanceof IFluteParrot)) continue;
                    IFluteParrot fp = (IFluteParrot)e;
                    if (!isPartying) continue;
                    fp.supplementaries$setPartyByFlute(p);
                }
            }
        }
    }

    public static void handleExplosionPacket(ClientBoundCannonballExplosionPacket packet) {
        ClientReceivers.withLevelDo(l -> {
            Vec3 pos = packet.pos();
            float power = packet.power();
            List<BlockPos> toBlow = packet.toBlow();
            Vec3 knockback = packet.knockback();
            switch (packet.explosionType()) {
                case CANNONBALL: {
                    CannonBallExplosion explosion = new CannonBallExplosion((Level)l, null, pos.x, pos.y, pos.z, power, toBlow);
                    explosion.finalizeExplosion(true);
                    Entity patt0$temp = l.getEntity(packet.getId());
                    if (!(patt0$temp instanceof CannonBallEntity)) break;
                    CannonBallEntity le = (CannonBallEntity)patt0$temp;
                    if (knockback == null) break;
                    le.setDeltaMovement(knockback);
                }
            }
        });
    }

    public static void handleCannonControlPacket(ClientBoundControlCannonPacket message) {
        ClientReceivers.withLevelDo(l -> {
            CannonAccess access = CannonAccess.find(l, message.target());
            if (access != null) {
                CannonController.startControlling(access);
            }
        });
    }

    public static void handleCannonAnimation(ClientBoundCannonAnimationPacket message) {
        ClientReceivers.withLevelDo(l -> {
            CannonAccess access = CannonAccess.find(l, message.target());
            if (access != null) {
                if (message.fire()) {
                    ClientReceivers.playFiringEffects(access);
                } else {
                    ClientReceivers.playIgniteEffects(access);
                }
            }
        });
    }

    private static void playIgniteEffects(CannonAccess access) {
        Level level = access.getInternalCannon().getLevel();
        PoseStack poseStack = ClientReceivers.calculateGlobalCannonPose(access);
        Vector4f p = poseStack.last().pose().transform(new Vector4f(0.0f, 0.0f, 1.752f, 1.0f));
        Vec3 speed = access.getCannonGlobalVelocity();
        level.addParticle((ParticleOptions)ParticleTypes.CRIT, (double)p.x, (double)p.y, (double)p.z, speed.x, speed.y, speed.z);
        Vec3 pos = access.getCannonGlobalPosition(1.0f);
        level.playLocalSound(pos.x, pos.y, pos.z, ModSounds.CANNON_IGNITE.get(), SoundSource.BLOCKS, 0.6f, 1.2f + level.getRandom().nextFloat() * 0.2f, false);
    }

    private static void playFiringEffects(CannonAccess access) {
        PoseStack poseStack = ClientReceivers.calculateGlobalCannonPose(access);
        CannonBlockTile cannon = access.getInternalCannon();
        Level level = cannon.getLevel();
        float yaw = cannon.getYaw() - access.getCannonGlobalYawOffset(1.0f);
        float pitch = cannon.getPitch();
        float power = cannon.getPowerLevel();
        Vec3 pos = access.getCannonGlobalPosition(1.0f);
        Vec3 speed = access.getCannonGlobalVelocity();
        speed = speed.scale(0.3);
        CannonFireParticle.Options opt = new CannonFireParticle.Options(pitch, yaw, 1.0f);
        speed = Vec3.ZERO;
        level.addParticle((ParticleOptions)opt, pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
        RandomSource ran = level.random;
        CannonUtils.spawnDustRing(level, poseStack, speed);
        CannonUtils.spawnSmokeTrail(level, poseStack, ran, speed);
        float soundPitch = 1.3f - power * 0.1f;
        float soundVolume = 2.0f + power * 0.6f;
        level.playLocalSound(pos.x, pos.y, pos.z, ModSounds.CANNON_FIRE.get(), SoundSource.BLOCKS, soundVolume, soundPitch, false);
    }

    private static PoseStack calculateGlobalCannonPose(CannonAccess access) {
        CannonBlockTile tile = access.getInternalCannon();
        float yaw = tile.getYaw() - access.getCannonGlobalYawOffset(1.0f);
        float pitch = tile.getPitch();
        PoseStack poseStack = new PoseStack();
        Vec3 pos = access.getCannonGlobalPosition(1.0f);
        poseStack.translate(pos.x, pos.y + 0.0625, pos.z);
        poseStack.mulPose(Axis.YP.rotationDegrees(-yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.translate(0.0, 0.0, -1.4);
        return poseStack;
    }
}

