/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.client.CoreShaderContainer;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.client.model.NestedModelLoader;
import net.mehvahdjukaar.moonlight.api.client.renderer.FallingBlockRendererGeneric;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.item.IItemDecoratorRenderer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.MobHeadShadersManager;
import net.mehvahdjukaar.supplementaries.client.block_models.AwningModelLoader;
import net.mehvahdjukaar.supplementaries.client.block_models.BlackboardBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.BookPileModel;
import net.mehvahdjukaar.supplementaries.client.block_models.FaucetModelLoader;
import net.mehvahdjukaar.supplementaries.client.block_models.FlowerBoxBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.FrameBlockBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.GobletModelLoader;
import net.mehvahdjukaar.supplementaries.client.block_models.JarModelLoader;
import net.mehvahdjukaar.supplementaries.client.block_models.RandomRotationModel;
import net.mehvahdjukaar.supplementaries.client.block_models.RopeBuntingsBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.RopeKnotBlockBakedModel;
import net.mehvahdjukaar.supplementaries.client.block_models.SignPostBlockBakedModel;
import net.mehvahdjukaar.supplementaries.client.particles.BombChargeParticle;
import net.mehvahdjukaar.supplementaries.client.particles.BombExplosionEmitterParticle;
import net.mehvahdjukaar.supplementaries.client.particles.BombExplosionParticle;
import net.mehvahdjukaar.supplementaries.client.particles.BombSmokeParticle;
import net.mehvahdjukaar.supplementaries.client.particles.BottlingXpParticle;
import net.mehvahdjukaar.supplementaries.client.particles.BubbleBlockParticle;
import net.mehvahdjukaar.supplementaries.client.particles.CannonFireParticle;
import net.mehvahdjukaar.supplementaries.client.particles.ConfettiParticle;
import net.mehvahdjukaar.supplementaries.client.particles.DrippingLiquidParticle;
import net.mehvahdjukaar.supplementaries.client.particles.FallingLiquidParticle;
import net.mehvahdjukaar.supplementaries.client.particles.FeatherParticle;
import net.mehvahdjukaar.supplementaries.client.particles.RotationTrailEmitter;
import net.mehvahdjukaar.supplementaries.client.particles.RotationTrailParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SlingshotParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SparkleParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SpeakerSoundParticle;
import net.mehvahdjukaar.supplementaries.client.particles.StasisParticle;
import net.mehvahdjukaar.supplementaries.client.particles.StreamerParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SudsParticle;
import net.mehvahdjukaar.supplementaries.client.particles.SugarParticle;
import net.mehvahdjukaar.supplementaries.client.particles.WindTrailParticle;
import net.mehvahdjukaar.supplementaries.client.renderers.color.CogBlockColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.DefaultWaterColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.FlowerBoxColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.FluidColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.GunpowderBlockColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.LunchBasketColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.MimicBlockColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.TippedSpikesColor;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.CannonBoatRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.CannonballRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.HatStandRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.ImprovedThrownItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.PlundererRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.RedMerchantRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.RopeArrowRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.SlingshotProjectileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.JarredHeadLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.JarredModel;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.PickleModel;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.layers.PartyHatLayer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.EndermanSkullModel;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.HatStandModel;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.PlundererModel;
import net.mehvahdjukaar.supplementaries.client.renderers.items.AltimeterItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.BlackboardItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.BubbleBlockItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.CageItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.FlagItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.JarItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.LunchBoxItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.ProjectileWeaponOverlayRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.SelectableItemOverlayRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.items.SlingshotItemOverlayRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BellowsBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BlackboardBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BookPileBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BubbleBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.BuntingBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CageBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CannonBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.ClockBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.DoormatBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.EndermanSkullBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.FlagBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.GlobeBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.HourGlassBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.ItemShelfBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.JarBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.JarBoatTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.NoticeBoardBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.PedestalBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.SignPostBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.SlidyBlockRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.SpringLauncherArmBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.StatueBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.WindVaneBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.screens.CannonScreen;
import net.mehvahdjukaar.supplementaries.client.screens.NoticeBoardScreen;
import net.mehvahdjukaar.supplementaries.client.screens.PresentScreen;
import net.mehvahdjukaar.supplementaries.client.screens.PulleyScreen;
import net.mehvahdjukaar.supplementaries.client.screens.RedMerchantScreen;
import net.mehvahdjukaar.supplementaries.client.screens.TrappedPresentScreen;
import net.mehvahdjukaar.supplementaries.client.screens.VariableSizeContainerScreen;
import net.mehvahdjukaar.supplementaries.client.tooltip.BannerPatternTooltipComponent;
import net.mehvahdjukaar.supplementaries.client.tooltip.BlackboardTooltipComponent;
import net.mehvahdjukaar.supplementaries.client.tooltip.PaintingTooltipComponent;
import net.mehvahdjukaar.supplementaries.client.tooltip.SelectableContainerTooltip;
import net.mehvahdjukaar.supplementaries.client.tooltip.SherdTooltipComponent;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManagerClient;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.VariableSizeContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.common.items.BuntingItemOld;
import net.mehvahdjukaar.supplementaries.common.items.SlingshotItem;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.mehvahdjukaar.supplementaries.common.items.components.LunchBaskedContent;
import net.mehvahdjukaar.supplementaries.common.items.components.QuiverContent;
import net.mehvahdjukaar.supplementaries.common.items.components.SelectableContainerContent;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.BannerPatternTooltip;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.PaintingTooltip;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.SherdTooltip;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.client.ModMapMarkersClient;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.AmendmentsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatHandlerClient;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModMenuTypes;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SnowflakeParticle;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class ClientRegistry {
    public static final ResourceLocation RAGE_SHADER = Supplementaries.res("shaders/post/rage.json");
    public static final String BARBARIC_RAGE_SHADER = Supplementaries.res("shaders/post/barbaric_rage.json").toString();
    public static final ResourceLocation FLARE_SHADER = Supplementaries.res("shaders/post/flare.json");
    public static final ResourceLocation GLITTER_SHADER = Supplementaries.res("shaders/post/glitter.json");
    public static final ResourceLocation BLACK_AND_WHITE_SHADER = Supplementaries.res("shaders/post/black_and_white.json");
    public static final ResourceLocation DESATURATE_SHADER = Supplementaries.res("shaders/post/desaturate.json");
    public static final CoreShaderContainer ENTITY_OFFSET_SHADER = new CoreShaderContainer(GameRenderer::getRendertypeEntityCutoutShader);
    public static final CoreShaderContainer NOISE_SHADER = new CoreShaderContainer(GameRenderer::getRendertypeEntitySolidShader);
    public static final CoreShaderContainer SPHERE_SHADER = new CoreShaderContainer(GameRenderer::getRendertypeEntitySolidShader);
    public static final ModelLayerLocation BELLOWS_MODEL = ClientRegistry.loc("bellows");
    public static final ModelLayerLocation CLOCK_HANDS_MODEL = ClientRegistry.loc("clock_hands");
    public static final ModelLayerLocation GLOBE_BASE_MODEL = ClientRegistry.loc("globe");
    public static final ModelLayerLocation GLOBE_SPECIAL_MODEL = ClientRegistry.loc("globe_special");
    public static final ModelLayerLocation RED_MERCHANT_MODEL = ClientRegistry.loc("red_merchant");
    public static final ModelLayerLocation PLUNDERER_MODEL = ClientRegistry.loc("plunderer");
    public static final ModelLayerLocation HAT_STAND_MODEL = ClientRegistry.loc("hat_stand");
    public static final ModelLayerLocation CANNONBALL_MODEL = ClientRegistry.loc("cannonball");
    public static final ModelLayerLocation HAT_STAND_MODEL_ARMOR = ClientRegistry.loc("hat_stand_armor");
    public static final ModelLayerLocation JARVIS_MODEL = ClientRegistry.loc("jarvis");
    public static final ModelLayerLocation JAR_MODEL = ClientRegistry.loc("jar");
    public static final ModelLayerLocation PICKLE_MODEL = ClientRegistry.loc("pickle");
    public static final ModelLayerLocation ENDERMAN_HEAD_MODEL = ClientRegistry.loc("enderman_head");
    public static final ModelLayerLocation SPIDER_HEAD_MODEL = ClientRegistry.loc("spider_head");
    public static final ModelLayerLocation PARTY_CREEPER_MODEL = ClientRegistry.loc("party_creeper");
    public static final ModelLayerLocation CANNON_MODEL = ClientRegistry.loc("cannon");
    public static final ModelLayerLocation WIND_VANE_MODEL = ClientRegistry.loc("wind_vane");
    public static final ModelLayerLocation BUNTING_MODEL = ClientRegistry.loc("bunting");
    public static final ModelResourceLocation FLUTE_3D_MODEL = ClientRegistry.modelRes("item/flute_in_hand");
    public static final ModelResourceLocation FLUTE_2D_MODEL = ClientRegistry.modelRes("item/flute_gui");
    public static final ModelResourceLocation POPPER_HEAD_MODEL = ClientRegistry.modelRes("item/confetti_popper_head");
    public static final ModelResourceLocation POPPER_GUI_MODEL = ClientRegistry.modelRes("item/confetti_popper_in_hand");
    public static final ModelResourceLocation QUIVER_3D_MODEL = ClientRegistry.modelRes("item/quiver_in_hand_dyed");
    public static final ModelResourceLocation QUIVER_2D_MODEL = ClientRegistry.modelRes("item/quiver_gui_dyed");
    public static final ModelResourceLocation ALTIMETER_TEMPLATE = ClientRegistry.modelRes("item/altimeter_template");
    public static final ModelResourceLocation ALTIMETER_OVERLAY = ClientRegistry.modelRes("item/altimeter_overlay");
    public static final ModelResourceLocation LUNCH_BOX_ITEM_MODEL = ClientRegistry.modelRes("item/lunch_basket_gui");
    public static final ModelResourceLocation LUNCH_BOX_DYED_ITEM_MODEL = ClientRegistry.modelRes("item/lunch_basket_gui_dyed");
    public static final ModelResourceLocation LUNCH_BOX_OPEN_ITEM_MODEL = ClientRegistry.modelRes("item/lunch_basket_gui_open");
    public static final ModelResourceLocation LUNCH_BOX_OPEN_DYED_ITEM_MODEL = ClientRegistry.modelRes("item/lunch_basket_gui_open_dyed");
    public static final ModelResourceLocation BOAT_MODEL = ClientRegistry.modelRes("block/jar_boat_ship");
    public static final ModelResourceLocation BLACKBOARD_FRAME = ClientRegistry.modelRes("block/blackboard_frame");
    public static final Supplier<Map<WoodType, ModelResourceLocation>> WAY_SIGN_MODELS = Suppliers.memoize(() -> WoodTypeRegistry.INSTANCE.getValues().stream().collect(Collectors.toMap(Function.identity(), w -> ClientRegistry.modelRes("block/way_signs/" + w.getVariantId("way_sign")))));
    public static final KeyMapping QUIVER_KEYBIND = new KeyMapping("supplementaries.keybind.quiver", InputConstants.Type.KEYSYM, InputConstants.getKey((String)"key.keyboard.v").getValue(), "supplementaries.gui.controls");

    private static ModelLayerLocation loc(String name) {
        return new ModelLayerLocation(Supplementaries.res(name), name);
    }

    private static ModelResourceLocation modelRes(String name) {
        return RenderUtil.getStandaloneModelLocation((ResourceLocation)Supplementaries.res(name));
    }

    public static void init() {
        CompatHandlerClient.init();
        ClientHelper.addClientSetup(ClientRegistry::setup);
        ClientHelper.addClientReloadListener(() -> MobHeadShadersManager.INSTANCE, (ResourceLocation)Supplementaries.res("mob_head_effects"));
        ClientHelper.addEntityRenderersRegistration(ClientRegistry::registerEntityRenderers);
        ClientHelper.addBlockEntityRenderersRegistration(ClientRegistry::registerBlockEntityRenderers);
        ClientHelper.addBlockColorsRegistration(ClientRegistry::registerBlockColors);
        ClientHelper.addItemColorsRegistration(ClientRegistry::registerItemColors);
        ClientHelper.addParticleRegistration(ClientRegistry::registerParticles);
        ClientHelper.addModelLayerRegistration(ClientRegistry::registerModelLayers);
        ClientHelper.addSpecialModelRegistration(ClientRegistry::registerSpecialModels);
        ClientHelper.addTooltipComponentRegistration(ClientRegistry::registerTooltipComponent);
        ClientHelper.addModelLoaderRegistration(ClientRegistry::registerModelLoaders);
        ClientHelper.addItemDecoratorsRegistration(ClientRegistry::registerItemDecorators);
        ClientHelper.addKeyBindRegistration(ClientRegistry::registerKeyBinds);
        ClientHelper.addShaderRegistration(ClientRegistry::registerShaders);
        ClientHelper.addItemRenderersRegistration(ClientRegistry::registerItemRenderers);
    }

    public static void setup() {
        CompatHandlerClient.setup();
        ModMapMarkersClient.init();
        MenuScreens.register(ModMenuTypes.PULLEY_BLOCK.get(), PulleyScreen::new);
        MenuScreens.register(ModMenuTypes.LUNCH_BASKET.get(), (MenuScreens.ScreenConstructor)new MenuScreens.ScreenConstructor<VariableSizeContainerMenu, VariableSizeContainerScreen>(){

            public VariableSizeContainerScreen create(VariableSizeContainerMenu m, Inventory inventory, Component component) {
                return new VariableSizeContainerScreen(m, inventory, component, ModTextures.LUNCH_BASKET_GUI_TEXTURE);
            }
        });
        MenuScreens.register(ModMenuTypes.SACK.get(), (MenuScreens.ScreenConstructor)new MenuScreens.ScreenConstructor<VariableSizeContainerMenu, VariableSizeContainerScreen>(){

            public VariableSizeContainerScreen create(VariableSizeContainerMenu m, Inventory inventory, Component component) {
                return new VariableSizeContainerScreen(m, inventory, component, ModTextures.SACK_GUI_TEXTURE);
            }
        });
        MenuScreens.register(ModMenuTypes.SAFE.get(), ShulkerBoxScreen::new);
        MenuScreens.register(ModMenuTypes.PRESENT_BLOCK.get(), PresentScreen::new);
        MenuScreens.register(ModMenuTypes.TRAPPED_PRESENT_BLOCK.get(), TrappedPresentScreen::new);
        MenuScreens.register(ModMenuTypes.NOTICE_BOARD.get(), NoticeBoardScreen::new);
        MenuScreens.register(ModMenuTypes.CANNON.get(), CannonScreen::new);
        MenuScreens.register(ModMenuTypes.RED_MERCHANT.get(), RedMerchantScreen::new);
        RenderType cutoutMipped = RenderType.cutoutMipped();
        ClientHelper.registerRenderType((Block)ModRegistry.COG_BLOCK.get(), (RenderType)cutoutMipped);
        ModRegistry.AWNINGS.values().forEach(c -> ClientHelper.registerRenderType((Block)((Block)c.get()), (RenderType)cutoutMipped));
        ClientHelper.registerRenderType((Block)ModRegistry.CRYSTAL_DISPLAY.get(), (RenderType)cutoutMipped);
        RenderType cutout = RenderType.cutout();
        ClientHelper.registerRenderType((Block)ModRegistry.WIND_VANE.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.CONFETTI_LITTER.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.FIRE_PIT.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.BUNTING_ROPE_BLOCK.get()), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.BOOK_PILE.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.BOOK_PILE_H.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.GLOBE.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.GLOBE_SEPIA.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.CRANK.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.WAY_SIGN.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.BELLOWS.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_WALL.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_WALL_SOUL.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_SOUL.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_WALL_GREEN.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_GREEN.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.ITEM_SHELF.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.CAGE.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.SCONCE_LEVER.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.HOURGLASS.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.BLACKBOARD.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.GOLD_DOOR.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.GOLD_TRAPDOOR.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.BAMBOO_SPIKES.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.NETHERITE_DOOR.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.NETHERITE_TRAPDOOR.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.ROPE.get()), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.FLAX.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.FLAX_WILD.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.FLAX_POT.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.BARNACLES.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.JAR_BOAT.get(), (RenderType)RenderType.translucent());
        ClientHelper.registerRenderType((Block)ModRegistry.GOBLET.get(), (RenderType[])new RenderType[]{RenderType.translucent(), cutout});
        ClientHelper.registerRenderType((Block)ModRegistry.FAUCET.get(), (RenderType[])new RenderType[]{RenderType.translucent(), cutout});
        ClientHelper.registerRenderType((Block)ModRegistry.JAR.get(), (RenderType[])new RenderType[]{RenderType.translucent(), cutout});
        ClientHelper.registerRenderType((Block)ModRegistry.FLOWER_BOX.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.TIMBER_FRAME.get()), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.TIMBER_BRACE.get()), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)((Block)ModRegistry.TIMBER_CROSS_BRACE.get()), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.IRON_GATE.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.GOLD_GATE.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.GOLD_BARS.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.GUNPOWDER_BLOCK.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.CANNON.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.ROPE_KNOT.get(), (RenderType)cutout);
        ClientHelper.registerRenderType((Block)ModRegistry.LUNCH_BASKET.get(), (RenderType)cutout);
        ModRegistry.CANDLE_HOLDERS.values().forEach(c -> ClientHelper.registerRenderType((Block)((Block)c.get()), (RenderType)cutout));
        ModRegistry.BUNTING_BLOCKS.values().forEach(c -> ClientHelper.registerRenderType((Block)((Block)c.get()), (RenderType)cutout));
        ModRegistry.BUNTING_WALL_BLOCKS.values().forEach(c -> ClientHelper.registerRenderType((Block)((Block)c.get()), (RenderType)cutout));
        ClientHelper.registerRenderType((Block)((Block)ModFluids.LUMISENE_BLOCK.get()), (RenderType)cutoutMipped);
        ClientHelper.registerFluidRenderType((Fluid)ModFluids.LUMISENE_FLUID.get(), (RenderType)RenderType.translucent());
        ItemProperties.register((Item)Items.CROSSBOW, (ResourceLocation)Supplementaries.res("rope_arrow"), (ClampedItemPropertyFunction)new CrossbowProperty((Item)ModRegistry.ROPE_ARROW_ITEM.get()));
        ClampedItemPropertyFunction antiqueProp = (itemStack, clientLevel, livingEntity, i) -> AntiqueInkItem.hasAntiqueInk(itemStack) ? 1.0f : 0.0f;
        ItemProperties.register((Item)Items.WRITTEN_BOOK, (ResourceLocation)Supplementaries.res("antique_ink"), (ClampedItemPropertyFunction)antiqueProp);
        ItemProperties.register((Item)Items.FILLED_MAP, (ResourceLocation)Supplementaries.res("antique_ink"), (ClampedItemPropertyFunction)antiqueProp);
        ItemProperties.register((Item)ModRegistry.SLINGSHOT_ITEM.get(), (ResourceLocation)Supplementaries.res("pull"), (stack, world, entity, s) -> {
            if (entity == null || entity.getUseItem() != stack) {
                return 0.0f;
            }
            return (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / (float)SlingshotItem.getChargeDuration(stack, entity);
        });
        ItemProperties.register((Item)ModRegistry.SLINGSHOT_ITEM.get(), (ResourceLocation)Supplementaries.res("pulling"), (stack, world, entity, s) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)ModRegistry.BUBBLE_BLOWER.get(), (ResourceLocation)Supplementaries.res("using"), (stack, world, entity, s) -> entity != null && entity.isUsingItem() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)entity.getUseItem()) ? 1.0f : 0.0f);
        ModRegistry.PRESENTS.values().forEach(i -> ItemProperties.register((Item)((Block)i.get()).asItem(), (ResourceLocation)Supplementaries.res("packed"), (stack, world, entity, s) -> 1.0f));
        ModRegistry.TRAPPED_PRESENTS.values().forEach(i -> ItemProperties.register((Item)((Block)i.get()).asItem(), (ResourceLocation)Supplementaries.res("primed"), (stack, world, entity, s) -> TrappedPresentBlockTile.isPrimed(stack) ? 1.0f : 0.0f));
        ItemProperties.register((Item)ModRegistry.CANDY_ITEM.get(), (ResourceLocation)Supplementaries.res("wrapping"), (stack, world, entity, s) -> MiscUtils.FESTIVITY.getCandyWrappingIndex());
        ItemProperties.register((Item)ModRegistry.QUIVER_ITEM.get(), (ResourceLocation)Supplementaries.res("dyed"), (stack, world, entity, s) -> stack.has(DataComponents.DYED_COLOR) ? 1.0f : 0.0f);
        ItemProperties.register((Item)ModRegistry.LUNCH_BASKET_ITEM.get(), (ResourceLocation)Supplementaries.res("dyed"), (stack, world, entity, s) -> stack.has(DataComponents.DYED_COLOR) ? 1.0f : 0.0f);
        ItemProperties.register((Item)ModRegistry.GLOBE_ITEM.get(), (ResourceLocation)Supplementaries.res("type"), (ClampedItemPropertyFunction)new GlobeProperty());
        ItemProperties.register((Item)ModRegistry.BUNTING_OLD.get(), (ResourceLocation)Supplementaries.res("dye"), (stack, world, entity, s) -> (float)BuntingItemOld.getColor(stack).getId() / 100.0f);
    }

    private static void registerKeyBinds(ClientHelper.KeyBindEvent event) {
        event.register(QUIVER_KEYBIND);
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((ParticleType)ModParticles.SPEAKER_SOUND.get(), SpeakerSoundParticle.Factory::new);
        event.register((ParticleType)ModParticles.GREEN_FLAME.get(), FlameParticle.Provider::new);
        event.register((ParticleType)ModParticles.DRIPPING_LIQUID.get(), DrippingLiquidParticle.Factory::new);
        event.register((ParticleType)ModParticles.FALLING_LIQUID.get(), FallingLiquidParticle.Factory::new);
        event.register((ParticleType)ModParticles.SPLASHING_LIQUID.get(), ColoredSplashingParticle::new);
        event.register((ParticleType)ModParticles.BOMB_EXPLOSION_PARTICLE.get(), BombExplosionParticle.Factory::new);
        event.register((ParticleType)ModParticles.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), BombExplosionEmitterParticle.Factory::new);
        event.register((ParticleType)ModParticles.BOMB_SMOKE_PARTICLE.get(), BombSmokeParticle.Factory::new);
        event.register((ParticleType)ModParticles.BOTTLING_XP_PARTICLE.get(), BottlingXpParticle.Factory::new);
        event.register((ParticleType)ModParticles.SPARKLE_PARTICLE.get(), SparkleParticle.Factory::new);
        event.register((ParticleType)ModParticles.FEATHER_PARTICLE.get(), FeatherParticle.Factory::new);
        event.register((ParticleType)ModParticles.SLINGSHOT_PARTICLE.get(), SlingshotParticle.Factory::new);
        event.register((ParticleType)ModParticles.STASIS_PARTICLE.get(), StasisParticle.Factory::new);
        event.register((ParticleType)ModParticles.CONFETTI_PARTICLE.get(), ConfettiParticle.Factory::new);
        event.register(ModParticles.CONFETTI_PARTICLE_DYED.get(), ConfettiParticle.DyeFactory::new);
        event.register((ParticleType)ModParticles.STREAMER_PARTICLE.get(), StreamerParticle.Factory::new);
        event.register(ModParticles.STREAMER_PARTICLE_DYED.get(), StreamerParticle.DyeFactory::new);
        event.register((ParticleType)ModParticles.WIND_STREAM.get(), WindTrailParticle.Factory::new);
        event.register((ParticleType)ModParticles.ROTATION_TRAIL.get(), RotationTrailParticle.Factory::new);
        event.register((ParticleType)ModParticles.ROTATION_TRAIL_EMITTER.get(), RotationTrailEmitter.Factory::new);
        event.register((ParticleType)ModParticles.SUDS_PARTICLE.get(), SudsParticle.Factory::new);
        event.register((ParticleType)ModParticles.ASH_PARTICLE.get(), AshParticleFactory::new);
        event.register((ParticleType)ModParticles.BUBBLE_BLOCK_PARTICLE.get(), BubbleBlockParticle.Factory::new);
        event.register((ParticleType)ModParticles.SUGAR_PARTICLE.get(), SugarParticle.Factory::new);
        event.register(ModParticles.CANNON_FIRE_PARTICLE.get(), CannonFireParticle.Factory::new);
        event.register((ParticleType)ModParticles.BOMB_CHARGE.get(), BombChargeParticle.Factory::new);
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register(ModEntities.CANNON_BOAT.get(), CannonBoatRenderer::new);
        event.register(ModEntities.BOMB.get(), context -> new ImprovedThrownItemRenderer(context, 1.0f));
        event.register(ModEntities.THROWABLE_BRICK.get(), context -> new ImprovedThrownItemRenderer(context, 1.0f));
        if (!CompatHandler.AMENDMENTS || !AmendmentsCompat.has3DSlimeballRenderer()) {
            event.register(ModEntities.THROWABLE_SLIMEBALL.get(), context -> new ImprovedThrownItemRenderer(context, 1.0f));
        }
        if (ClientConfigs.Items.CANNONBALL_3D.get().booleanValue()) {
            event.register(ModEntities.CANNONBALL.get(), context -> new CannonballRenderer(context, 1.615f));
        } else {
            event.register(ModEntities.CANNONBALL.get(), context -> new ImprovedThrownItemRenderer(context, 1.615f));
        }
        event.register(ModEntities.PLUNDERER.get(), PlundererRenderer::new);
        event.register(ModEntities.SLINGSHOT_PROJECTILE.get(), SlingshotProjectileRenderer::new);
        event.register(ModEntities.DISPENSER_MINECART.get(), c -> new MinecartRenderer(c, ModelLayers.HOPPER_MINECART));
        event.register(ModEntities.RED_MERCHANT.get(), RedMerchantRenderer::new);
        event.register(ModEntities.HAT_STAND.get(), HatStandRenderer::new);
        event.register(ModEntities.ROPE_ARROW.get(), RopeArrowRenderer::new);
        event.register(ModEntities.FALLING_URN.get(), FallingBlockRenderer::new);
        event.register(ModEntities.FALLING_ASH.get(), FallingBlockRendererGeneric::new);
        event.register(ModEntities.FALLING_SACK.get(), FallingBlockRenderer::new);
        event.register(ModEntities.PEARL_MARKER.get(), NoopRenderer::new);
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(ModRegistry.DOORMAT_TILE.get(), DoormatBlockTileRenderer::new);
        event.register(ModRegistry.CLOCK_BLOCK_TILE.get(), ClockBlockTileRenderer::new);
        event.register(ModRegistry.PEDESTAL_TILE.get(), PedestalBlockTileRenderer::new);
        event.register(ModRegistry.WIND_VANE_TILE.get(), WindVaneBlockTileRenderer::new);
        event.register(ModRegistry.NOTICE_BOARD_TILE.get(), NoticeBoardBlockTileRenderer::new);
        event.register(ModRegistry.JAR_TILE.get(), JarBlockTileRenderer::new);
        event.register(ModRegistry.SPRING_LAUNCHER_ARM_TILE.get(), SpringLauncherArmBlockTileRenderer::new);
        event.register(ModRegistry.WAY_SIGN_TILE.get(), SignPostBlockTileRenderer::new);
        event.register(ModRegistry.BELLOWS_TILE.get(), BellowsBlockTileRenderer::new);
        event.register(ModRegistry.FLAG_TILE.get(), FlagBlockTileRenderer::new);
        event.register(ModRegistry.ITEM_SHELF_TILE.get(), ItemShelfBlockTileRenderer::new);
        event.register(ModRegistry.CAGE_TILE.get(), CageBlockTileRenderer::new);
        event.register(ModRegistry.GLOBE_TILE.get(), GlobeBlockTileRenderer::new);
        event.register(ModRegistry.HOURGLASS_TILE.get(), HourGlassBlockTileRenderer::new);
        event.register(ModRegistry.BLACKBOARD_TILE.get(), BlackboardBlockTileRenderer::new);
        event.register(ModRegistry.STATUE_TILE.get(), StatueBlockTileRenderer::new);
        event.register(ModRegistry.BOOK_PILE_TILE.get(), BookPileBlockTileRenderer::new);
        event.register(ModRegistry.JAR_BOAT_TILE.get(), JarBoatTileRenderer::new);
        event.register(ModRegistry.BUBBLE_BLOCK_TILE.get(), BubbleBlockTileRenderer::new);
        event.register(ModRegistry.ENDERMAN_SKULL_TILE.get(), EndermanSkullBlockTileRenderer::new);
        event.register(ModRegistry.CANNON_TILE.get(), CannonBlockTileRenderer::new);
        event.register(ModRegistry.BUNTING_TILE.get(), BuntingBlockTileRenderer::new);
        event.register(ModRegistry.MOVING_SLIDY_BLOCK_TILE.get(), SlidyBlockRenderer::new);
    }

    private static void registerShaders(ClientHelper.ShaderEvent event) {
        event.register(Supplementaries.res("static_noise"), DefaultVertexFormat.NEW_ENTITY, arg_0 -> ((CoreShaderContainer)NOISE_SHADER).assign(arg_0));
        event.register(Supplementaries.res("spherify"), DefaultVertexFormat.NEW_ENTITY, arg_0 -> ((CoreShaderContainer)SPHERE_SHADER).assign(arg_0));
        event.register(Supplementaries.res("entity_cutout_texture_offset"), DefaultVertexFormat.NEW_ENTITY, arg_0 -> ((CoreShaderContainer)ENTITY_OFFSET_SHADER).assign(arg_0));
    }

    private static void registerItemRenderers(ClientHelper.ItemRendererEvent event) {
        event.register((ItemLike)ModRegistry.ALTIMETER_ITEM.get(), (ItemStackRenderer)new AltimeterItemRenderer());
        event.register((ItemLike)ModRegistry.CAGE_ITEM.get(), (ItemStackRenderer)new CageItemRenderer());
        event.register((ItemLike)ModRegistry.JAR_ITEM.get(), (ItemStackRenderer)new JarItemRenderer());
        event.register((ItemLike)ModRegistry.BLACKBOARD_ITEM.get(), (ItemStackRenderer)new BlackboardItemRenderer());
        event.register((ItemLike)ModRegistry.BUBBLE_BLOCK_ITEM.get(), (ItemStackRenderer)new BubbleBlockItemRenderer());
        event.register((ItemLike)ModRegistry.LUNCH_BASKET_ITEM.get(), (ItemStackRenderer)new LunchBoxItemRenderer());
        FlagItemRenderer renderer = new FlagItemRenderer();
        for (Supplier<Block> f : ModRegistry.FLAGS.values()) {
            event.register((ItemLike)f.get(), (ItemStackRenderer)renderer);
        }
    }

    private static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        FlowerPotHandler.CUSTOM_MODELS.forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
        WAY_SIGN_MODELS.get().values().forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
        PlaceableBookManagerClient.registerExtraModels(event);
        event.register(BLACKBOARD_FRAME);
        event.register(BOAT_MODEL);
        event.register(LUNCH_BOX_ITEM_MODEL);
        event.register(LUNCH_BOX_OPEN_ITEM_MODEL);
        event.register(LUNCH_BOX_DYED_ITEM_MODEL);
        event.register(LUNCH_BOX_OPEN_DYED_ITEM_MODEL);
        event.register(ALTIMETER_TEMPLATE);
        event.register(ALTIMETER_OVERLAY);
        if (PlatHelper.getPlatform().isFabric()) {
            event.register(FLUTE_3D_MODEL);
            event.register(FLUTE_2D_MODEL);
            event.register(QUIVER_2D_MODEL);
            event.register(QUIVER_3D_MODEL);
            event.register(POPPER_GUI_MODEL);
            event.register(POPPER_HEAD_MODEL);
        }
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(Supplementaries.res("frame_block"), (CustomModelLoader)new NestedModelLoader("overlay", FrameBlockBakedModel::new));
        event.register(Supplementaries.res("flower_box"), (CustomModelLoader)new NestedModelLoader("box", FlowerBoxBakedModel::new));
        event.register(Supplementaries.res("rope_knot"), (CustomModelLoader)new NestedModelLoader("knot", RopeKnotBlockBakedModel::new));
        event.register(Supplementaries.res("blackboard"), (CustomModelLoader)new NestedModelLoader("frame", BlackboardBakedModel::new));
        event.register(Supplementaries.res("random_rotation"), (CustomModelLoader)new NestedModelLoader("model", RandomRotationModel::new));
        event.register(Supplementaries.res("way_sign"), SignPostBlockBakedModel::new);
        event.register(Supplementaries.res("goblet"), (CustomModelLoader)new GobletModelLoader());
        event.register(Supplementaries.res("extra_rotation"), (CustomModelLoader)new AwningModelLoader());
        event.register(Supplementaries.res("faucet"), (CustomModelLoader)new FaucetModelLoader());
        event.register(Supplementaries.res("book_pile"), BookPileModel::new);
        event.register(Supplementaries.res("rope_bunting"), RopeBuntingsBakedModel::new);
        event.register(Supplementaries.res("jar"), (CustomModelLoader)new JarModelLoader());
    }

    private static void registerItemDecorators(ClientHelper.ItemDecoratorEvent event) {
        if (ClientConfigs.Items.QUIVER_OVERLAY.get().booleanValue()) {
            event.register((ItemLike)ModRegistry.QUIVER_ITEM.get(), (IItemDecoratorRenderer)new SelectableItemOverlayRenderer());
        }
        if (ClientConfigs.Items.LUNCH_BOX_OVERLAY.get().booleanValue()) {
            event.register((ItemLike)ModRegistry.LUNCH_BASKET_ITEM.get(), (IItemDecoratorRenderer)new SelectableItemOverlayRenderer());
        }
        if (ClientConfigs.Tweaks.PROJECTILE_WEAPON_OVERLAY.get().booleanValue()) {
            event.register((ItemLike)ModRegistry.SLINGSHOT_ITEM.get(), (IItemDecoratorRenderer)new SlingshotItemOverlayRenderer());
            for (Item i : BuiltInRegistries.ITEM) {
                if (!(i instanceof ProjectileWeaponItem) || i == ModRegistry.SLINGSHOT_ITEM.get()) continue;
                event.register((ItemLike)i, (IItemDecoratorRenderer)new ProjectileWeaponOverlayRenderer());
            }
        }
    }

    private static void registerTooltipComponent(ClientHelper.TooltipComponentEvent event) {
        event.register(BlackboardData.class, BlackboardTooltipComponent::new);
        event.register(QuiverContent.class, SelectableContainerTooltip::new);
        event.register(LunchBaskedContent.class, SelectableContainerTooltip::new);
        event.register(SelectableContainerContent.class, SelectableContainerTooltip::new);
        event.register(BannerPatternTooltip.class, BannerPatternTooltipComponent::new);
        event.register(PaintingTooltip.class, PaintingTooltipComponent::new);
        event.register(SherdTooltip.class, SherdTooltipComponent::new);
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        event.register((BlockColor)new TippedSpikesColor(), new Block[]{ModRegistry.BAMBOO_SPIKES.get()});
        event.register((BlockColor)new DefaultWaterColor(), new Block[]{ModRegistry.JAR_BOAT.get()});
        event.register((BlockColor)new MimicBlockColor(), new Block[]{ModRegistry.WAY_SIGN.get(), (Block)ModRegistry.TIMBER_BRACE.get(), (Block)ModRegistry.TIMBER_FRAME.get(), (Block)ModRegistry.TIMBER_CROSS_BRACE.get(), ModRegistry.ROPE_KNOT.get()});
        event.register((BlockColor)new CogBlockColor(), new Block[]{ModRegistry.COG_BLOCK.get()});
        event.register((BlockColor)new GunpowderBlockColor(), new Block[]{ModRegistry.GUNPOWDER_BLOCK.get()});
        event.register((BlockColor)new FlowerBoxColor(), new Block[]{ModRegistry.FLOWER_BOX.get()});
        event.register((BlockColor)new FluidColor(false), new Block[]{ModRegistry.GOBLET.get(), ModRegistry.JAR.get()});
        event.register((BlockColor)new LunchBasketColor(), new Block[]{ModRegistry.LUNCH_BASKET.get()});
    }

    private static void registerItemColors(ClientHelper.ItemColorEvent event) {
        event.register((ItemColor)new TippedSpikesColor(), new ItemLike[]{(ItemLike)ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get()});
        event.register((ItemColor)new DefaultWaterColor(), new ItemLike[]{(ItemLike)ModRegistry.JAR_BOAT.get()});
        event.register((itemStack, i) -> i == 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)itemStack, (int)-6265536), new ItemLike[]{(ItemLike)ModRegistry.QUIVER_ITEM.get()});
        event.register((itemStack, i) -> i == 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)itemStack, (int)DyeColor.RED.getMapColor().col), new ItemLike[]{(ItemLike)ModRegistry.LUNCH_BASKET_ITEM.get()});
    }

    private static void registerModelLayers(ClientHelper.ModelLayerEvent event) {
        event.register(BELLOWS_MODEL, BellowsBlockTileRenderer::createMesh);
        event.register(CLOCK_HANDS_MODEL, ClockBlockTileRenderer::createMesh);
        event.register(GLOBE_BASE_MODEL, GlobeBlockTileRenderer::createBaseMesh);
        event.register(GLOBE_SPECIAL_MODEL, GlobeBlockTileRenderer::createSpecialMesh);
        event.register(RED_MERCHANT_MODEL, RedMerchantRenderer::createMesh);
        event.register(PLUNDERER_MODEL, PlundererModel::createMesh);
        event.register(HAT_STAND_MODEL, HatStandModel::createMesh);
        event.register(CANNONBALL_MODEL, CannonballRenderer::createMesh);
        event.register(HAT_STAND_MODEL_ARMOR, HatStandModel::createArmorMesh);
        event.register(JARVIS_MODEL, JarredModel::createMesh);
        event.register(JAR_MODEL, JarredHeadLayer::createMesh);
        event.register(PICKLE_MODEL, PickleModel::createMesh);
        event.register(ENDERMAN_HEAD_MODEL, EndermanSkullModel::createMesh);
        event.register(SPIDER_HEAD_MODEL, ClientRegistry::createSpiderHead);
        event.register(PARTY_CREEPER_MODEL, PartyHatLayer::createMesh);
        event.register(CANNON_MODEL, CannonBlockTileRenderer::createMesh);
        event.register(WIND_VANE_MODEL, WindVaneBlockTileRenderer::createMesh);
        event.register(BUNTING_MODEL, BuntingBlockTileRenderer::createMesh);
    }

    private static LayerDefinition createSpiderHead() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartPose partPose = PartPose.offset((float)0.0f, (float)-0.0f, (float)0.0f);
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 4).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), partPose);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LevelLightEngine getLightEngine() {
        return Minecraft.getInstance().level.getLightEngine();
    }

    private record CrossbowProperty(Item projectile) implements ClampedItemPropertyFunction
    {
        public float call(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            ChargedProjectiles chargedProjectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
            return chargedProjectiles != null && chargedProjectiles.contains(this.projectile) ? 1.0f : 0.0f;
        }

        public float unclampedCall(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
            return 0.0f;
        }
    }

    private static class GlobeProperty
    implements ClampedItemPropertyFunction {
        private GlobeProperty() {
        }

        public float call(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
            Component customName = (Component)itemStack.get(DataComponents.CUSTOM_NAME);
            if (customName != null) {
                return GlobeManager.getNamedGlobeTextureID(customName.getString()).floatValue();
            }
            return Float.NEGATIVE_INFINITY;
        }

        public float unclampedCall(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
            return this.call(itemStack, clientLevel, livingEntity, i);
        }
    }

    private static class AshParticleFactory
    extends SnowflakeParticle.Provider {
        public AshParticleFactory(SpriteSet pSprites) {
            super(pSprites);
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            Particle p = super.createParticle(pType, pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            if (p != null) {
                float yellow = pLevel.random.nextFloat() * 0.05f;
                p.setColor(0.42352942f + yellow, 0.40392157f + yellow, 0.40392157f);
            }
            return p;
        }
    }

    public static class ColoredSplashingParticle
    extends SplashParticle.Provider {
        public ColoredSplashingParticle(SpriteSet sprites) {
            super(sprites);
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double r, double g, double b) {
            Particle p = super.createParticle(type, level, x, y, z, 0.0, 0.0, 0.0);
            p.setColor((float)r, (float)g, (float)b);
            return p;
        }
    }
}

