/*
 * Decompiled with CFR 0.152.
 */
package com.koletar.jj.mineresetlite;

import com.koletar.jj.mineresetlite.SerializableBlock;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.generator.WorldInfo;
import org.bukkit.potion.PotionEffect;

public class Mine
implements ConfigurationSerializable {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private World world;
    private Map<SerializableBlock, Double> composition;
    private Set<SerializableBlock> structure;
    private int resetDelay;
    private List<Integer> resetWarnings;
    private List<Integer> resetWarningsLastMinute;
    private String name;
    private SerializableBlock surface;
    private boolean fillMode;
    private int resetClock;
    private boolean isSilent;
    private int tpX = 0;
    private int tpY = -2147483647;
    private int tpZ = 0;
    private int tpYaw = 0;
    private int tpPitch = 0;
    private double resetPercent = -1.0;
    private List<PotionEffect> potions = new ArrayList<PotionEffect>();
    int luckyBlocks = 0;
    List<Integer> luckyNum;
    List<String> luckyCommands;
    private boolean tpAtReset;
    private Location centerOfGravity;

    public Mine(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, String name, World world) {
        this.name = name;
        this.redefine(minX, minY, minZ, maxX, maxY, maxZ, world);
        this.composition = new HashMap<SerializableBlock, Double>();
        this.resetWarnings = new LinkedList<Integer>();
        this.resetWarningsLastMinute = new LinkedList<Integer>();
        this.structure = new HashSet<SerializableBlock>();
        this.luckyNum = new ArrayList<Integer>();
        this.luckyCommands = new ArrayList<String>();
    }

    public Mine(Map<String, Object> me) {
        try {
            this.redefine((Integer)me.get("minX"), (Integer)me.get("minY"), (Integer)me.get("minZ"), (Integer)me.get("maxX"), (Integer)me.get("maxY"), (Integer)me.get("maxZ"), Bukkit.getServer().getWorld((String)me.get("world")));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error deserializing coordinate pairs");
        }
        if (this.world == null) {
            Logger l = Bukkit.getLogger();
            l.severe("[MineResetLite] Unable to find a world! Please include these logger lines along with the stack trace when reporting this bug!");
            l.severe("[MineResetLite] Attempted to load world named: " + String.valueOf(me.get("world")));
            l.severe("[MineResetLite] Worlds listed: " + String.valueOf(Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList())));
            throw new IllegalArgumentException("World was null!");
        }
        try {
            Map sComposition = (Map)me.get("composition");
            this.composition = new HashMap<SerializableBlock, Double>();
            for (Map.Entry entry : sComposition.entrySet()) {
                BigDecimal bd = new BigDecimal((Double)entry.getValue());
                bd = bd.setScale(4, RoundingMode.HALF_UP);
                this.composition.put(new SerializableBlock((String)entry.getKey()), bd.doubleValue());
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error deserializing composition");
        }
        try {
            List sStructure = (List)me.get("structure");
            this.structure = new HashSet<SerializableBlock>();
            for (String string : sStructure) {
                this.structure.add(new SerializableBlock(string));
            }
        }
        catch (Throwable sStructure) {
            // empty catch block
        }
        this.name = (String)me.get("name");
        this.resetDelay = (Integer)me.get("resetDelay");
        List warnings = (List)me.get("resetWarnings");
        this.resetWarnings = new LinkedList<Integer>();
        this.resetWarningsLastMinute = new LinkedList<Integer>();
        for (String string : warnings) {
            try {
                if (string.toLowerCase().endsWith("s")) {
                    String string2 = string.toLowerCase().replace("s", "");
                    this.resetWarningsLastMinute.add(Integer.valueOf(string2));
                    continue;
                }
                this.resetWarnings.add(Integer.valueOf(string));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Non-numeric reset warnings supplied");
            }
        }
        if (me.containsKey("surface") && !me.get("surface").equals("")) {
            this.surface = new SerializableBlock((String)me.get("surface"));
        }
        if (me.containsKey("fillMode")) {
            this.fillMode = (Boolean)me.get("fillMode");
        }
        if (me.containsKey("resetClock")) {
            this.resetClock = (Integer)me.get("resetClock");
        }
        if (this.resetDelay > 0 && this.resetClock == 0) {
            this.resetClock = this.resetDelay;
        }
        if (me.containsKey("isSilent")) {
            this.isSilent = (Boolean)me.get("isSilent");
        }
        if (me.containsKey("tpY")) {
            this.tpX = (Integer)me.get("tpX");
            this.tpY = (Integer)me.get("tpY");
            this.tpZ = (Integer)me.get("tpZ");
        }
        if (me.containsKey("tpYaw")) {
            this.tpYaw = (Integer)me.get("tpYaw");
            this.tpPitch = (Integer)me.get("tpPitch");
        }
        if (me.containsKey("resetPercent")) {
            this.resetPercent = (Double)me.get("resetPercent");
        }
        this.tpAtReset = !me.containsKey("tpAtReset") || (Boolean)me.get("tpAtReset") != false;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> me = new HashMap<String, Object>();
        me.put("minX", this.minX);
        me.put("minY", this.minY);
        me.put("minZ", this.minZ);
        me.put("maxX", this.maxX);
        me.put("maxY", this.maxY);
        me.put("maxZ", this.maxZ);
        me.put("world", this.world.getName());
        HashMap<String, Double> sComposition = new HashMap<String, Double>();
        for (Map.Entry<SerializableBlock, Double> entry : this.composition.entrySet()) {
            sComposition.put(entry.getKey().toString(), entry.getValue());
        }
        me.put("composition", sComposition);
        ArrayList<String> sStructure = new ArrayList<String>();
        for (SerializableBlock serializableBlock : this.structure) {
            sStructure.add(serializableBlock.toString());
        }
        me.put("structure", sStructure);
        me.put("name", this.name);
        me.put("resetDelay", this.resetDelay);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Integer warning : this.resetWarnings) {
            linkedList.add(warning.toString());
        }
        for (Integer warning : this.resetWarningsLastMinute) {
            linkedList.add(warning.toString() + "s");
        }
        me.put("resetWarnings", linkedList);
        if (this.surface != null) {
            me.put("surface", this.surface.toString());
        } else {
            me.put("surface", "");
        }
        me.put("fillMode", this.fillMode);
        me.put("resetClock", this.resetClock);
        me.put("isSilent", this.isSilent);
        me.put("tpX", this.tpX);
        me.put("tpY", this.tpY);
        me.put("tpZ", this.tpZ);
        me.put("tpYaw", this.tpYaw);
        me.put("tpPitch", this.tpPitch);
        me.put("resetPercent", this.resetPercent);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (PotionEffect pe : this.potions) {
            hashMap.put(pe.getType().getName(), pe.getAmplifier());
        }
        me.put("potions", hashMap);
        me.put("lucky_blocks", this.luckyBlocks);
        me.put("lucky_commands", this.luckyCommands);
        me.put("tpAtReset", this.tpAtReset);
        return me;
    }

    public World getWorld() {
        return this.world;
    }

    public String getName() {
        return this.name;
    }

    public Map<SerializableBlock, Double> getComposition() {
        return this.composition;
    }

    public Location getTpPos() {
        return new Location(this.getWorld(), (double)this.tpX, (double)this.tpY, (double)this.tpZ);
    }

    public double getTpY() {
        return this.tpY;
    }

    public Location getMin() {
        return new Location(this.getWorld(), (double)this.minX, (double)this.minY, (double)this.minZ);
    }

    public Location getMax() {
        return new Location(this.getWorld(), (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public double getResetPercent() {
        return this.resetPercent;
    }

    public void redefine(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, World world) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.world = world;
        this.computeCenterOfGravity(this.world, this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }

    private Location computeCenterOfGravity(World w, int min_x, int max_x, int min_y, int max_y, int min_z, int max_z) {
        Location max = new Location(w, (double)Math.max(max_x, min_x), (double)max_y, (double)Math.max(max_z, min_z));
        Location min = new Location(w, (double)Math.min(max_x, min_x), (double)min_y, (double)Math.min(max_z, min_z));
        this.centerOfGravity = max.add(min).multiply(0.5);
        return this.centerOfGravity;
    }
}

