/*
 * Decompiled with CFR 0.152.
 */
package com.koletar.jj.mineresetlite;

import org.bukkit.Material;

public class SerializableBlock {
    private String blockId;
    private byte data;

    public SerializableBlock(String s) {
        String[] split = s.split(":");
        if (split.length < 1) {
            throw new IllegalArgumentException("String form of SerializableBlock didn't have sufficient data");
        }
        try {
            Material type = Material.getMaterial((String)split[0]);
            this.data = split.length > 1 ? Byte.parseByte(split[1]) : (byte)0;
            this.blockId = type.name();
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Unable to convert id to integer and data to byte");
        }
    }

    public String getBlockId() {
        return this.blockId;
    }

    public byte getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        return o instanceof SerializableBlock && this.blockId.equals(((SerializableBlock)o).blockId) && this.data == ((SerializableBlock)o).data;
    }
}

