/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core;

import dev.triumphteam.cmd.core.BaseCommand;
import dev.triumphteam.cmd.core.SubCommand;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.LimitlessInternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import dev.triumphteam.cmd.core.execution.ExecutionProvider;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.message.MessageRegistry;
import dev.triumphteam.cmd.core.message.context.DefaultMessageContext;
import dev.triumphteam.cmd.core.message.context.InvalidArgumentContext;
import dev.triumphteam.cmd.core.processor.AbstractSubCommandProcessor;
import dev.triumphteam.cmd.core.requirement.Requirement;
import dev.triumphteam.cmd.core.sender.SenderValidator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSubCommand<S>
implements SubCommand<S> {
    private final BaseCommand baseCommand;
    private final Method method;
    private final String parentName;
    private final String name;
    private final List<String> alias;
    private final boolean isDefault;
    private final Class<? extends S> senderType;
    private final List<InternalArgument<S, ?>> internalArguments;
    private final Set<Requirement<S, ?>> requirements;
    private final MessageRegistry<S> messageRegistry;
    private final ExecutionProvider executionProvider;
    private final SenderValidator<S> senderValidator;
    private final boolean hasArguments;
    private final boolean containsLimitless;

    public AbstractSubCommand(@NotNull AbstractSubCommandProcessor<S> processor, @NotNull String parentName, @NotNull ExecutionProvider executionProvider) {
        this.baseCommand = processor.getBaseCommand();
        this.method = processor.getMethod();
        this.name = processor.getName();
        this.alias = processor.getAlias();
        this.internalArguments = processor.getArguments();
        this.requirements = processor.getRequirements();
        this.messageRegistry = processor.getMessageRegistry();
        this.isDefault = processor.isDefault();
        this.senderValidator = processor.getSenderValidator();
        this.senderType = processor.getSenderType();
        this.parentName = parentName;
        this.executionProvider = executionProvider;
        this.hasArguments = !this.internalArguments.isEmpty();
        this.containsLimitless = this.internalArguments.stream().anyMatch(LimitlessInternalArgument.class::isInstance);
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    @NotNull
    public Class<? extends S> getSenderType() {
        return this.senderType;
    }

    @Override
    @NotNull
    public String getParentName() {
        return this.parentName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasArguments() {
        return this.hasArguments;
    }

    @NotNull
    protected MessageRegistry<S> getMessageRegistry() {
        return this.messageRegistry;
    }

    @Override
    public void execute(@NotNull S sender, @NotNull @NotNull List<@NotNull String> args) {
        if (!this.senderValidator.validate(this.messageRegistry, this, sender)) {
            return;
        }
        if (!this.meetRequirements(sender)) {
            return;
        }
        ArrayList<Object> invokeArguments = new ArrayList<Object>();
        invokeArguments.add(sender);
        if (!this.validateAndCollectArguments(sender, invokeArguments, args)) {
            return;
        }
        if (!this.containsLimitless && args.size() >= invokeArguments.size()) {
            this.messageRegistry.sendMessage(MessageKey.TOO_MANY_ARGUMENTS, sender, new DefaultMessageContext(this.parentName, this.name));
            return;
        }
        this.executionProvider.execute(() -> {
            try {
                this.method.invoke((Object)this.baseCommand, invokeArguments.toArray());
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                throw new CommandExecutionException("An error occurred while executing the command", this.parentName, this.name).initCause(exception instanceof InvocationTargetException ? exception.getCause() : exception);
            }
        });
    }

    @NotNull
    protected @NotNull List<@NotNull InternalArgument<S, ?>> getArguments() {
        return this.internalArguments;
    }

    @Nullable
    protected InternalArgument<S, ?> getArgument(@NotNull String name) {
        List foundArgs = this.internalArguments.stream().filter(internalArgument -> internalArgument.getName().toLowerCase().startsWith(name)).collect(Collectors.toList());
        if (foundArgs.size() != 1) {
            return null;
        }
        return (InternalArgument)foundArgs.get(0);
    }

    @Nullable
    protected InternalArgument<S, ?> getArgument(int index) {
        int size = this.internalArguments.size();
        if (size == 0) {
            return null;
        }
        if (index >= size) {
            InternalArgument<S, ?> last = this.internalArguments.get(size - 1);
            if (last instanceof LimitlessInternalArgument) {
                return last;
            }
            return null;
        }
        return this.internalArguments.get(index);
    }

    public @NotNull List<@Nullable String> mapArguments(@NotNull @NotNull Map<@NotNull String, @NotNull String> args) {
        List arguments = this.getArguments().stream().map(InternalArgument::getName).collect(Collectors.toList());
        return arguments.stream().map(it -> {
            String value = (String)args.get(it);
            return value == null ? "" : value;
        }).collect(Collectors.toList());
    }

    private boolean validateAndCollectArguments(@NotNull S sender, @NotNull List<@Nullable Object> invokeArguments, @NotNull @NotNull List<@NotNull String> commandArgs) {
        for (int i = 0; i < this.internalArguments.size(); ++i) {
            Object result;
            InternalArgument<S, ?> internalArgument = this.internalArguments.get(i);
            if (internalArgument instanceof LimitlessInternalArgument) {
                LimitlessInternalArgument limitlessArgument = (LimitlessInternalArgument)internalArgument;
                List<String> leftOvers = this.leftOvers(commandArgs, i);
                result = limitlessArgument.resolve(sender, leftOvers);
                if (result == null) {
                    return false;
                }
                invokeArguments.add(result);
                return true;
            }
            if (!(internalArgument instanceof StringInternalArgument)) {
                throw new CommandExecutionException("Found unsupported internalArgument", this.parentName, this.name);
            }
            StringInternalArgument stringArgument = (StringInternalArgument)internalArgument;
            String arg = this.valueOrNull(commandArgs, i);
            if (arg == null || arg.isEmpty()) {
                if (internalArgument.isOptional()) {
                    invokeArguments.add(null);
                    continue;
                }
                this.messageRegistry.sendMessage(MessageKey.NOT_ENOUGH_ARGUMENTS, sender, new DefaultMessageContext(this.parentName, this.name));
                return false;
            }
            result = stringArgument.resolve(sender, arg);
            if (result == null) {
                this.messageRegistry.sendMessage(MessageKey.INVALID_ARGUMENT, sender, new InvalidArgumentContext(this.parentName, this.name, arg, internalArgument.getName(), internalArgument.getType()));
                return false;
            }
            invokeArguments.add(result);
        }
        return true;
    }

    private boolean meetRequirements(@NotNull S sender) {
        for (Requirement<S, ?> requirement : this.requirements) {
            if (requirement.isMet(sender)) continue;
            requirement.sendMessage(this.messageRegistry, sender, this.parentName, this.name);
            return false;
        }
        return true;
    }

    @Nullable
    private String valueOrNull(@NotNull @NotNull List<@NotNull String> list, int index) {
        if (index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    @NotNull
    private @NotNull List<@NotNull String> leftOvers(@NotNull @NotNull List<@NotNull String> list, int from) {
        if (from > list.size()) {
            return Collections.emptyList();
        }
        return list.subList(from, list.size());
    }

    @NotNull
    public String toString() {
        return "SimpleSubCommand{baseCommand=" + this.baseCommand + ", method=" + this.method + ", name='" + this.name + '\'' + ", alias=" + this.alias + ", isDefault=" + this.isDefault + ", arguments=" + this.internalArguments + ", requirements=" + this.requirements + ", messageRegistry=" + this.messageRegistry + ", containsLimitlessArgument=" + this.containsLimitless + '}';
    }
}

