/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument;

import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.suggestion.Suggestion;
import dev.triumphteam.cmd.core.suggestion.SuggestionContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class SplitStringInternalArgument<S>
extends StringInternalArgument<S> {
    private final String regex;
    private final InternalArgument<S, String> internalArgument;
    private final Class<?> collectionType;

    public SplitStringInternalArgument(@NotNull String name, @NotNull String description, @NotNull String regex, @NotNull InternalArgument<S, String> internalArgument, @NotNull Class<?> collectionType, @NotNull Suggestion<S> suggestion, int position, boolean optional) {
        super(name, description, String.class, suggestion, position, optional);
        this.regex = regex;
        this.internalArgument = internalArgument;
        this.collectionType = collectionType;
    }

    @Override
    @NotNull
    public Object resolve(@NotNull S sender, @NotNull String value) {
        Stream<Object> stream = Arrays.stream(value.split(this.regex)).map(arg -> this.internalArgument.resolve(sender, (String)arg));
        if (this.collectionType == Set.class) {
            return stream.collect(Collectors.toSet());
        }
        return stream.collect(Collectors.toList());
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull String> suggestions(@NotNull S sender, @NotNull @NotNull List<@NotNull String> trimmed, @NotNull SuggestionContext context) {
        List<String> split = Arrays.asList(trimmed.get(trimmed.size() - 1).split(this.regex));
        if (split.size() == 0) {
            return Collections.emptyList();
        }
        String current = split.get(split.size() - 1);
        String joined = String.join((CharSequence)this.regex, split.subList(0, split.size() - 1));
        String map = joined.isEmpty() ? "" : joined + this.regex;
        return this.getSuggestion().getSuggestions(sender, current, context).stream().map(it -> map + it).collect(Collectors.toList());
    }
}

