/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.processor;

import dev.triumphteam.cmd.core.BaseCommand;
import dev.triumphteam.cmd.core.Command;
import dev.triumphteam.cmd.core.SubCommand;
import dev.triumphteam.cmd.core.annotation.Description;
import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import dev.triumphteam.cmd.core.execution.ExecutionProvider;
import dev.triumphteam.cmd.core.processor.AbstractSubCommandProcessor;
import dev.triumphteam.cmd.core.registry.RegistryContainer;
import dev.triumphteam.cmd.core.sender.SenderMapper;
import dev.triumphteam.cmd.core.sender.SenderValidator;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommandProcessor<SD, S, SC extends SubCommand<S>, P extends AbstractSubCommandProcessor<S>> {
    private String name;
    private String description = "No description provided.";
    private final List<String> alias = new ArrayList<String>();
    private final Map<String, SC> subCommands = new HashMap<String, SC>();
    private final Map<String, SC> subCommandsAlias = new HashMap<String, SC>();
    private final BaseCommand baseCommand;
    private final RegistryContainer<S> registryContainer;
    private final SenderMapper<SD, S> senderMapper;
    private final SenderValidator<S> senderValidator;
    private final ExecutionProvider syncExecutionProvider;
    private final ExecutionProvider asyncExecutionProvider;

    protected AbstractCommandProcessor(@NotNull BaseCommand baseCommand, @NotNull RegistryContainer<S> registryContainer, @NotNull SenderMapper<SD, S> senderMapper, @NotNull SenderValidator<S> senderValidator, @NotNull ExecutionProvider syncExecutionProvider, @NotNull ExecutionProvider asyncExecutionProvider) {
        this.baseCommand = baseCommand;
        this.registryContainer = registryContainer;
        this.senderMapper = senderMapper;
        this.senderValidator = senderValidator;
        this.syncExecutionProvider = syncExecutionProvider;
        this.asyncExecutionProvider = asyncExecutionProvider;
        this.extractCommandNames();
        this.extractDescription();
    }

    public void addSubCommands(@NotNull Command<S, SC> command) {
        for (Method method : this.baseCommand.getClass().getDeclaredMethods()) {
            P processor;
            String subCommandName;
            if (Modifier.isPrivate(method.getModifiers()) || (subCommandName = ((AbstractSubCommandProcessor)(processor = this.createProcessor(method))).getName()) == null) continue;
            ExecutionProvider executionProvider = ((AbstractSubCommandProcessor)processor).isAsync() ? this.asyncExecutionProvider : this.syncExecutionProvider;
            Object subCommand = this.createSubCommand(processor, executionProvider);
            command.addSubCommand(subCommandName, subCommand);
            ((AbstractSubCommandProcessor)processor).getAlias().forEach(alias -> command.addSubCommandAlias((String)alias, subCommand));
        }
    }

    @NotNull
    protected abstract P createProcessor(@NotNull Method var1);

    @NotNull
    protected abstract SC createSubCommand(@NotNull P var1, @NotNull ExecutionProvider var2);

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public @NotNull List<@NotNull String> getAlias() {
        return this.alias;
    }

    @NotNull
    public BaseCommand getBaseCommand() {
        return this.baseCommand;
    }

    @NotNull
    public RegistryContainer<S> getRegistryContainer() {
        return this.registryContainer;
    }

    @NotNull
    public SenderMapper<SD, S> getSenderMapper() {
        return this.senderMapper;
    }

    @NotNull
    public SenderValidator<S> getSenderValidator() {
        return this.senderValidator;
    }

    @NotNull
    public @NotNull Map<@NotNull String, SC> getSubCommands() {
        return this.subCommands;
    }

    @NotNull
    public @NotNull Map<@NotNull String, SC> getSubCommandsAlias() {
        return this.subCommandsAlias;
    }

    @NotNull
    public ExecutionProvider getSyncExecutionProvider() {
        return this.syncExecutionProvider;
    }

    @NotNull
    public ExecutionProvider getAsyncExecutionProvider() {
        return this.asyncExecutionProvider;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    private void extractCommandNames() {
        dev.triumphteam.cmd.core.annotation.Command commandAnnotation = this.baseCommand.getClass().getAnnotation(dev.triumphteam.cmd.core.annotation.Command.class);
        if (commandAnnotation == null) {
            String commandName = this.baseCommand.getCommand();
            if (commandName == null) {
                throw new CommandRegistrationException("Command name or \"@" + dev.triumphteam.cmd.core.annotation.Command.class.getSimpleName() + "\" annotation missing", this.baseCommand.getClass());
            }
            this.name = commandName;
            this.alias.addAll(this.baseCommand.getAlias());
        } else {
            this.name = commandAnnotation.value();
            Collections.addAll(this.alias, commandAnnotation.alias());
        }
        this.alias.addAll(this.baseCommand.getAlias());
        if (this.name.isEmpty()) {
            throw new CommandRegistrationException("Command name must not be empty", this.baseCommand.getClass());
        }
    }

    private void extractDescription() {
        Description description = this.baseCommand.getClass().getAnnotation(Description.class);
        if (description == null) {
            return;
        }
        this.description = description.value();
    }
}

