/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.converters;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.settings.Settings;
import java.io.File;
import java.util.List;
import java.util.Objects;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.converters.RMConverterBase;
import joserodpt.realmines.api.converters.RMSupportedConverters;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.mine.components.items.MineBlockItem;
import joserodpt.realmines.api.mine.types.BlockMine;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class JetsPrisonMinesConverter
implements RMConverterBase {
    private final RealMinesAPI rm;

    public JetsPrisonMinesConverter(RealMinesAPI rm) {
        this.rm = rm;
    }

    @Override
    public RMSupportedConverters getPlugin() {
        return RMSupportedConverters.JETS_PRISON_MINES;
    }

    @Override
    public void convert(CommandSender cmd) {
        cmd.sendMessage(Text.color("&7----------------- &9Real&bMines &f&lImport &7-----------------"));
        Text.send(cmd, "&aImporting Mines from: &b" + this.getPlugin().getSourceName());
        File JetsPrisonMinesPath = new File(this.rm.getPlugin().getDataFolder().getParent() + "//JetsPrisonMines//mines");
        if (!JetsPrisonMinesPath.exists() || !JetsPrisonMinesPath.isDirectory()) {
            Text.send(cmd, "&cError: The path for JetsPrisonMines' mines does not exist: " + JetsPrisonMinesPath.getAbsolutePath());
            return;
        }
        for (File file : Objects.requireNonNull(JetsPrisonMinesPath.listFiles())) {
            try {
                boolean rUseMessages;
                YamlDocument mineFile = YamlDocument.create(file, new Settings[0]);
                String mineName = mineFile.getString("mine_name");
                Text.send(cmd, "&aImporting now &b" + mineName);
                if (this.rm.getMineManager().getMines().containsKey(mineName)) {
                    Text.send(cmd, "&cThere is already a mine named " + mineName + ". &fSkipping!");
                    continue;
                }
                List<String> blocks = mineFile.getStringList("blocks");
                World w = Bukkit.getWorld((String)Objects.requireNonNull(mineFile.getString("region.world")));
                if (w == null) {
                    Text.send(cmd, "&cError: Could not find world: " + mineFile.getString("region.world") + " for mine: " + mineName + ". &fSkipping!");
                    continue;
                }
                double xMin = mineFile.getInt("region.xmin").intValue();
                double yMin = mineFile.getInt("region.ymin").intValue();
                double zMin = mineFile.getInt("region.zmin").intValue();
                Location min = new Location(w, xMin, yMin, zMin);
                double xMax = mineFile.getInt("region.xmax").intValue();
                double yMax = mineFile.getInt("region.ymax").intValue();
                double zMax = mineFile.getInt("region.zmax").intValue();
                Location max = new Location(w, xMax, yMax, zMax);
                BlockMine m = new BlockMine(ChatColor.stripColor((String)Text.color(mineName)), w, min, max);
                m.setIcon(Material.COBBLESTONE);
                Section sec = (Section)mineFile.get("teleport_location");
                if (sec != null) {
                    double spawnX = sec.getDouble("x");
                    double spawnY = sec.getDouble("y");
                    double spawnZ = sec.getDouble("z");
                    double spawnPitch = sec.getDouble("pitch");
                    double spawnYaw = sec.getDouble("yaw");
                    m.setTeleport(new Location(w, spawnX, spawnY, spawnZ, (float)spawnYaw, (float)spawnPitch));
                }
                boolean rUseTimer = mineFile.getBoolean("reset.use_timer");
                int rTimer = mineFile.getInt("reset.timer");
                if (rUseTimer) {
                    m.setResetState(RMine.Reset.TIME, true);
                    m.setResetValue(RMine.Reset.TIME, rTimer);
                    Text.send(cmd, " &f> Importing reset delay of: &b" + rTimer + " seconds");
                } else {
                    m.setResetState(RMine.Reset.TIME, false);
                }
                boolean rUsePercentage = mineFile.getBoolean("reset.use_percentage");
                double rPercentage = mineFile.getDouble("reset.percentage");
                if (rUsePercentage) {
                    m.setResetState(RMine.Reset.PERCENTAGE, true);
                    m.setResetValue(RMine.Reset.PERCENTAGE, (int)(rPercentage / 100.0));
                    Text.send(cmd, " &f> Importing reset percentage of: &b" + rPercentage / 100.0 + "%");
                }
                m.setSilent(!(rUseMessages = mineFile.getBoolean("reset.use_messages").booleanValue()));
                for (String blockDetails : blocks) {
                    String[] bd = blockDetails.split(":");
                    String blockName = bd.length > 0 ? bd[0] : null;
                    String chanceStr = bd.length > 1 ? bd[1] : "1.0";
                    try {
                        Material mat = Material.valueOf((String)blockName);
                        m.addItem("default", new MineBlockItem(mat, Double.parseDouble(chanceStr) / 100.0));
                    }
                    catch (IllegalArgumentException e) {
                        Text.send(cmd, "&cError: Could not find block: " + blockName + " for mine: " + mineName + ". &fSkipping!");
                    }
                }
                m.reset(RMine.ResetCause.IMPORT);
                this.rm.getMineManager().addMine(m);
                Text.send(cmd, "&aSucessfully imported mine " + m.getDisplayName());
            }
            catch (IllegalArgumentException e) {
                Text.send(cmd, "&cError: This mine has a location that has an unknown world. &fSkipping!");
                e.printStackTrace();
            }
            catch (Exception e) {
                Text.send(cmd, "&cError: Could not load JetsPrisonMines file: " + file.getName() + "! See console for more details.");
                this.rm.getPlugin().getLogger().severe("Error loading JetsPrisonMines file: " + file.getName());
                e.printStackTrace();
            }
        }
        Text.send(cmd, "&aEnded Mine Import Process from &b" + this.getPlugin().getSourceName());
        cmd.sendMessage(Text.color("&7----------------- &9Real&bMines &f&lImport &7-----------------"));
    }
}

