/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.converters;

import com.koletar.jj.mineresetlite.Mine;
import com.koletar.jj.mineresetlite.SerializableBlock;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.converters.RMConverterBase;
import joserodpt.realmines.api.converters.RMSupportedConverters;
import joserodpt.realmines.api.mine.RMine;
import joserodpt.realmines.api.mine.components.RMFailedToLoadException;
import joserodpt.realmines.api.mine.components.items.MineBlockItem;
import joserodpt.realmines.api.mine.types.BlockMine;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class MRLConverter
implements RMConverterBase {
    private final RealMinesAPI rm;

    public MRLConverter(RealMinesAPI rm) {
        this.rm = rm;
    }

    @Override
    public RMSupportedConverters getPlugin() {
        return RMSupportedConverters.MINE_RESET_LITE;
    }

    @Override
    public void convert(CommandSender cmd) {
        cmd.sendMessage(Text.color("&7----------------- &9Real&bMines &f&lImport &7-----------------"));
        Text.send(cmd, "&aImporting Mines from: &b" + this.getPlugin().getSourceName());
        File MRLDirectory = new File(this.rm.getPlugin().getDataFolder().getParent() + "//MineResetLite//mines");
        if (!MRLDirectory.exists() || !MRLDirectory.isDirectory()) {
            Text.send(cmd, "&cError: The path for MineResetLite mines does not exist: " + MRLDirectory.getAbsolutePath());
            return;
        }
        ConfigurationSerialization.registerClass(Mine.class);
        File[] MRLyamlFiles = MRLDirectory.listFiles();
        int mineCounter = MRLyamlFiles.length;
        for (int i = 0; i < mineCounter; ++i) {
            Mine MRLmine = (Mine)YamlConfiguration.loadConfiguration((File)MRLyamlFiles[i]).get("mine");
            Text.send(cmd, "&aImporting now &b" + MRLmine.getName());
            if (this.rm.getMineManager().getMines().containsKey(MRLmine.getName())) {
                Text.send(cmd, "&cThere is already a mine named " + MRLmine.getName() + ". &fSkipping!");
                continue;
            }
            Map<SerializableBlock, Double> composition = MRLmine.getComposition();
            HashMap<Material, Double> blocks = new HashMap<Material, Double>();
            for (SerializableBlock serializableBlock : composition.keySet()) {
                blocks.put(Material.valueOf((String)serializableBlock.getBlockId()), composition.get(serializableBlock) * 100.0);
            }
            Text.send(cmd, " &f> Mine has &b" + blocks.size() + "&f blocks.");
            try {
                BlockMine m = new BlockMine(ChatColor.stripColor((String)Text.color(MRLmine.getName())), MRLmine.getWorld(), MRLmine.getMin(), MRLmine.getMax());
                m.setIcon(Material.COBBLESTONE);
                blocks.forEach((material, aDouble) -> m.addItem("default", new MineBlockItem((Material)material, aDouble / 100.0)));
                double value2 = MRLmine.getResetPercent();
                if ((int)value2 != -1) {
                    m.setResetState(RMine.Reset.PERCENTAGE, true);
                    m.setResetValue(RMine.Reset.PERCENTAGE, (int)(value2 * 100.0));
                    Text.send(cmd, " &f> Importing reset percentage of: &b" + value2 * 100.0 + "%");
                }
                m.reset(RMine.ResetCause.IMPORT);
                if (MRLmine.getTpY() >= 0.0) {
                    Text.send(cmd, " &f> Importing mine teleport position.");
                    m.setTeleport(MRLmine.getTpPos());
                }
                this.rm.getMineManager().addMine(m);
                Text.send(cmd, "&aSucessfully imported mine " + m.getDisplayName());
                continue;
            }
            catch (RMFailedToLoadException e) {
                Text.send(cmd, "&cFailed to import mine " + e.getMineName() + " because: " + e.getReason());
            }
        }
        Text.send(cmd, "&aEnded Mine Import Process from &b" + this.getPlugin().getSourceName());
        cmd.sendMessage(Text.color("&7----------------- &9Real&bMines &f&lImport &7-----------------"));
    }
}

