/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.pattern.RandomPattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.RMConfig;
import joserodpt.realmines.api.config.RMLanguageConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.event.MineBlockBreakEvent;
import joserodpt.realmines.api.event.OnMineResetEvent;
import joserodpt.realmines.api.mine.components.MineColor;
import joserodpt.realmines.api.mine.components.MineCuboid;
import joserodpt.realmines.api.mine.components.MineSign;
import joserodpt.realmines.api.mine.components.RMBlockSet;
import joserodpt.realmines.api.mine.components.RMFailedToLoadException;
import joserodpt.realmines.api.mine.components.RMineSettings;
import joserodpt.realmines.api.mine.components.actions.MineAction;
import joserodpt.realmines.api.mine.components.actions.MineActionCommand;
import joserodpt.realmines.api.mine.components.actions.MineActionDropItem;
import joserodpt.realmines.api.mine.components.actions.MineActionGiveItem;
import joserodpt.realmines.api.mine.components.actions.MineActionMoney;
import joserodpt.realmines.api.mine.components.items.MineBlockItem;
import joserodpt.realmines.api.mine.components.items.MineItem;
import joserodpt.realmines.api.mine.components.items.MineSchematicItem;
import joserodpt.realmines.api.mine.components.items.farm.MineFarmItem;
import joserodpt.realmines.api.mine.task.MineTimer;
import joserodpt.realmines.api.mine.types.farm.FarmItem;
import joserodpt.realmines.api.utils.Countdown;
import joserodpt.realmines.api.utils.ItemStackSpringer;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.Text;
import joserodpt.realmines.api.utils.WorldEditUtils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public abstract class RMine {
    protected String name;
    protected String displayName;
    private World w;
    protected Location teleport;
    protected Material icon;
    protected List<MineSign> signs = new ArrayList<MineSign>();
    protected Map<String, RMBlockSet> blockSets = new HashMap<String, RMBlockSet>();
    protected BlockSetsMode blockSetsMode = BlockSetsMode.INCREMENTAL;
    protected boolean freezed;
    protected boolean silent;
    protected boolean resetByTime = true;
    protected boolean resetByPercentage = true;
    protected int resetByTimeValue = 120;
    protected int resetByPercentageValue = 20;
    protected int minedBlocks;
    protected int blockSetIndex;
    protected boolean highlight = false;
    protected Map<MineCuboid.CuboidDirection, Material> faces = new HashMap<MineCuboid.CuboidDirection, Material>();
    protected MineTimer timer;
    protected MineColor color = MineColor.WHITE;
    protected MineCuboid mineCuboid;
    protected Location _pos1;
    protected Location _pos2;
    private File file;
    private FileConfiguration config;

    public void setBlockSetMode(BlockSetsMode next) {
        this.blockSetsMode = next;
        this.setSettingString(RMineSettings.BLOCK_SETS_MODE, this.getBlockSetMode().name());
    }

    public RMine(String name, World w) throws RMFailedToLoadException {
        this.name = ChatColor.stripColor((String)Text.color(name));
        this.displayName = name;
        this.w = w;
        switch (this.getType().ordinal()) {
            case 0: {
                this.icon = Material.DIAMOND_ORE;
                this.color = MineColor.BLUE;
                break;
            }
            case 1: {
                this.icon = Material.FILLED_MAP;
                this.color = MineColor.ORANGE;
                break;
            }
            case 2: {
                this.icon = Material.WHEAT;
                this.color = MineColor.GREEN;
            }
        }
        this.checkConfig(true, false);
    }

    public RMine(String name, World w, Location pos1, Location pos2) throws RMFailedToLoadException {
        this.name = ChatColor.stripColor((String)Text.color(name));
        this.displayName = name;
        this.w = w;
        this._pos1 = pos1;
        this._pos2 = pos2;
        this.mineCuboid = new MineCuboid(pos1, pos2);
        switch (this.getType().ordinal()) {
            case 0: {
                this.icon = Material.DIAMOND_ORE;
                this.color = MineColor.BLUE;
                break;
            }
            case 1: {
                this.icon = Material.FILLED_MAP;
                this.color = MineColor.ORANGE;
                break;
            }
            case 2: {
                this.icon = Material.WHEAT;
                this.color = MineColor.GREEN;
            }
        }
        this.checkConfig(true, false);
    }

    public RMine(String name, Section mineConfigSection) throws RMFailedToLoadException {
        float z;
        this.name = name;
        this.checkConfig(false, false);
        this.config.set("name", (Object)name);
        this.config.set("type", (Object)mineConfigSection.getString("Type"));
        this.config.set("world", (Object)mineConfigSection.getString("World"));
        this.config.set("icon", (Object)mineConfigSection.getString("Icon"));
        this.config.set("displayName", (Object)mineConfigSection.getString("Display-Name"));
        this.config.set("color", (Object)mineConfigSection.getString("Color"));
        if (this.getType() != Type.SCHEMATIC) {
            String pos1 = mineConfigSection.getString("POS1.X") + ";" + mineConfigSection.getString("POS1.Y") + ";" + mineConfigSection.getString("POS1.Z");
            this.config.set("pos1", (Object)pos1);
            String pos2 = mineConfigSection.getString("POS2.X") + ";" + mineConfigSection.getString("POS2.Y") + ";" + mineConfigSection.getString("POS2.Z");
            this.config.set("pos2", (Object)pos2);
        } else {
            this.config.set("schematic", (Object)mineConfigSection.getString("Schematic-Filename"));
            float x = (float)Math.round(mineConfigSection.getDouble("Place.X") * 100.0) / 100.0f;
            float y = (float)Math.round(mineConfigSection.getDouble("Place.Y") * 100.0) / 100.0f;
            z = (float)Math.round(mineConfigSection.getDouble("Place.Z") * 100.0) / 100.0f;
            this.config.set("pos1", (Object)(x + ";" + y + ";" + z));
        }
        this.config.set("reset.silent", (Object)mineConfigSection.getBoolean("Settings.Reset.Silent"));
        if (mineConfigSection.getStringList("Reset-Commands") != null) {
            this.config.set("reset.commands", mineConfigSection.getStringList("Reset-Commands"));
        } else {
            this.config.set("reset.commands", Collections.emptyList());
        }
        this.config.set("reset.percentage.active", (Object)mineConfigSection.getBoolean("Settings.Reset.ByPercentage"));
        this.config.set("reset.percentage.value", (Object)mineConfigSection.getInt("Settings.Reset.ByPercentageValue"));
        this.config.set("reset.time.active", (Object)mineConfigSection.getBoolean("Settings.Reset.ByTime"));
        this.config.set("reset.time.value", (Object)mineConfigSection.getInt("Settings.Reset.ByTimeValue"));
        this.config.set("reset.time.countdown", (Object)mineConfigSection.getInt("Settings.Reset.ByTimeCountdown"));
        this.config.set(RMineSettings.BREAK_PERMISSION.getConfigKey(), (Object)mineConfigSection.getBoolean("Settings.Break-Permission"));
        this.config.set(RMineSettings.DISCARD_BREAK_ACTION_MESSAGES.getConfigKey(), (Object)mineConfigSection.getBoolean("Settings.Discard-Break-Action-Messages"));
        this.config.set(RMineSettings.BLOCK_SETS_MODE.getConfigKey(), (Object)this.getBlockSetMode().name());
        this.config.set("signs", mineConfigSection.getStringList("Signs"));
        if (mineConfigSection.getSection("Faces") != null) {
            mineConfigSection.getSection("Faces").getRoutesAsStrings(false).forEach(face -> this.config.set("faces." + face, (Object)mineConfigSection.getString("Faces." + face)));
        }
        float x = (float)Math.round(mineConfigSection.getDouble("Teleport.X") * 100.0) / 100.0f;
        float y = (float)Math.round(mineConfigSection.getDouble("Teleport.Y") * 100.0) / 100.0f;
        z = (float)Math.round(mineConfigSection.getDouble("Teleport.Z") * 100.0) / 100.0f;
        float yaw = (float)Math.round(mineConfigSection.getDouble("Teleport.Yaw") * 100.0) / 100.0f;
        float pitch = (float)Math.round(mineConfigSection.getDouble("Teleport.Pitch") * 100.0) / 100.0f;
        String teleport = x + ";" + y + ";" + z + ";" + yaw + ";" + pitch;
        this.config.set("teleport", (Object)teleport);
        this.config.set("block-sets.default.description", (Object)"Default description for block set");
        this.config.set("block-sets.default.icon", (Object)Material.CAULDRON.name());
        if (mineConfigSection.getSection("Blocks") == null) {
            for (String a : mineConfigSection.getStringList("Blocks")) {
                String[] content = a.split(";");
                if (content.length != 2) {
                    RealMinesAPI.getInstance().getLogger().warning("Invalid pre version 1.6 block format for mine " + this.getName() + "! Skipping.");
                    continue;
                }
                this.config.set("block-sets.default.blocks." + content[0] + ".percentage", (Object)Double.parseDouble(content[1]));
            }
        } else {
            mineConfigSection.getSection("Blocks").getRoutesAsStrings(false).forEach(block -> {
                this.config.set("block-sets.default.blocks." + block + ".percentage", (Object)mineConfigSection.getSection("Blocks").getDouble(block + ".Chance"));
                this.config.set("block-sets.default.blocks." + block + ".disabled-vanilla-drop", (Object)mineConfigSection.getSection("Blocks").getBoolean(block + ".Disabled-Vanilla-Drop", (Boolean)false));
                this.config.set("block-sets.default.blocks." + block + ".disabled-block-mining", (Object)mineConfigSection.getSection("Blocks").getBoolean(block + ".Disabled-Block-Mining", (Boolean)false));
                if (mineConfigSection.getSection("Blocks").getSection((String)block).get("Age") != null) {
                    this.config.set("block-sets.default.blocks." + block + ".age", (Object)mineConfigSection.getSection("Blocks").getInt(block + ".Age"));
                }
                if (mineConfigSection.getSection("Blocks").getSection((String)block).getSection("Break-Actions") != null) {
                    mineConfigSection.getSection("Blocks").getSection((String)block).getSection("Break-Actions").getRoutesAsStrings(false).forEach(action -> {
                        String type = mineConfigSection.getSection("Blocks").getSection((String)block).getSection("Break-Actions").getString(action + ".Type");
                        double chanceBA = mineConfigSection.getSection("Blocks").getSection((String)block).getSection("Break-Actions").getDouble(action + ".Chance");
                        this.config.set("block-sets.default.blocks." + block + ".break-actions." + action + ".type", (Object)type);
                        this.config.set("block-sets.default.blocks." + block + ".break-actions." + action + ".chance", (Object)chanceBA);
                        Section breakActions = mineConfigSection.getSection("Blocks").getSection((String)block).getSection("Break-Actions");
                        for (String property : new String[]{"Command", "Amount", "Item"}) {
                            Object value = breakActions.get(action + "." + property);
                            if (value == null || value instanceof String && ((String)value).isEmpty()) continue;
                            this.config.set("block-sets.default.blocks." + block + ".break-actions." + action + ".value", value);
                            return;
                        }
                    });
                }
            });
        }
        this.saveConfig();
        RealMinesAPI.getInstance().getLogger().info("Loading now the new mine config for: " + this.getName());
        this.loadMineConfig();
    }

    public RMine(String name, YamlConfiguration mineConfig) throws RMFailedToLoadException {
        this.name = name;
        this.config = mineConfig;
        this.checkConfig(false, true);
    }

    public FileConfiguration getMineConfig() {
        return this.config;
    }

    private void loadMineConfig() throws RMFailedToLoadException {
        Object value;
        String name = this.getName();
        this.displayName = this.config.getString("displayName");
        String worldName = this.config.getString("world");
        if (worldName == null || worldName.isEmpty()) {
            throw new RMFailedToLoadException(name, "[RealMines] Could not load world " + worldName + ". Is the world name correct and valid? Skipping.");
        }
        World w = Bukkit.getWorld((String)worldName);
        if (w == null) {
            throw new RMFailedToLoadException(name, "[RealMines] Could not load world " + worldName + ". Does the world exist and is loaded? Skipping.");
        }
        this.w = w;
        if (this.config.getString("icon") == null) {
            this.icon = Material.STONE;
            RealMinesAPI.getInstance().getLogger().warning("[RealMines] Could not load icon for mine " + name + ". Invalid material. Replacing with STONE.");
        } else {
            Material icon = Material.getMaterial((String)this.config.getString("icon"));
            if (icon == null) {
                this.icon = Material.STONE;
                RealMinesAPI.getInstance().getLogger().warning("[RealMines] Could not load icon for mine " + name + ". Invalid material. Replacing with STONE.");
            } else {
                this.icon = icon;
            }
        }
        if (this.getType() != Type.SCHEMATIC) {
            String[] pos1 = this.config.getString("pos1").split(";");
            if (pos1.length != 3) {
                throw new RMFailedToLoadException(name, "[RealMines] Could not load pos1 for mine " + name + ". Invalid length args for pos1. Skipping");
            }
            String[] pos2 = this.config.getString("pos2").split(";");
            if (pos2.length != 3) {
                throw new RMFailedToLoadException(name, "[RealMines] Could not load pos2 for mine " + name + ". Invalid length args for pos2. Skipping");
            }
            p1 = new Location(w, Double.parseDouble(pos1[0]), Double.parseDouble(pos1[1]), Double.parseDouble(pos1[2]));
            Location p2 = new Location(w, Double.parseDouble(pos2[0]), Double.parseDouble(pos2[1]), Double.parseDouble(pos2[2]));
            this.setPOS(p1, p2);
        } else {
            String posSTR = this.config.getString("pos1");
            if (posSTR == null) {
                throw new RMFailedToLoadException(name, "[RealMines] Could not load pos1 for mine " + name + ". Invalid pos1. Skipping");
            }
            String[] pos1 = posSTR.split(";");
            if (pos1.length != 3) {
                throw new RMFailedToLoadException(name, "[RealMines] Could not load pos1 for mine " + name + ". Invalid length args for pos1. Skipping");
            }
            this._pos1 = p1 = new Location(w, Double.parseDouble(pos1[0]), Double.parseDouble(pos1[1]), Double.parseDouble(pos1[2]));
        }
        if (this.config.get("teleport") != null) {
            String[] teleport = this.config.getString("teleport").split(";");
            if (teleport.length != 5) {
                throw new RMFailedToLoadException(name, "[RealMines] Could not load teleport for mine " + name + ". Invalid length args for teleport. Skipping");
            }
            this.teleport = new Location(w, Double.parseDouble((String)teleport[0]), Double.parseDouble((String)teleport[1]), Double.parseDouble((String)teleport[2]), Float.parseFloat((String)teleport[3]), Float.parseFloat((String)teleport[4]));
        }
        if (this.config.get("signs") != null) {
            for (String sig : this.config.getStringList("signs")) {
                String[] parse = sig.split(";");
                if (parse.length != 5) {
                    throw new RMFailedToLoadException(name, "[RealMines] Could not load sign for mine " + name + ". Invalid length args for sign. Skipping");
                }
                World sigw = Bukkit.getWorld((String)parse[0]);
                if (sigw == null) {
                    throw new RMFailedToLoadException(name, "[RealMines] Could not load sign for mine " + name + ". Invalid world name. Skipping");
                }
                MineSign ms = new MineSign(sigw.getBlockAt(new Location(sigw, Double.parseDouble(parse[1]), Double.parseDouble(parse[2]), Double.parseDouble(parse[3]))), parse[4]);
                this.signs.add(ms);
            }
        }
        if (this.config.get("faces") != null) {
            for (String sig : this.config.getConfigurationSection("faces").getKeys(false)) {
                this.faces.put(MineCuboid.CuboidDirection.valueOf(sig), Material.valueOf((String)this.config.getString("faces." + sig)));
            }
        }
        if (this.config.getString("color") != null && (value = this.config.getString("color")) != null && !((String)value).isEmpty()) {
            this.color = MineColor.valueOf((String)value);
        }
        this.resetByPercentage = this.config.getBoolean("reset.percentage.active");
        this.resetByPercentageValue = this.config.getInt("reset.percentage.value");
        this.resetByTime = this.config.getBoolean("reset.time.active");
        this.resetByTimeValue = this.config.getInt("reset.time.value");
        this.silent = this.config.getBoolean("reset.silent");
        this.blockSetsMode = BlockSetsMode.valueOf(this.getSettingString(RMineSettings.BLOCK_SETS_MODE));
        if (this.config.getConfigurationSection("block-sets") != null) {
            for (String blockSetKey : this.config.getConfigurationSection("block-sets").getKeys(false)) {
                HashMap<Material, MineItem> items = new HashMap<Material, MineItem>();
                if (this.config.getConfigurationSection("block-sets." + blockSetKey + ".blocks") != null) {
                    for (String mat : this.config.getConfigurationSection("block-sets." + blockSetKey + ".blocks").getKeys(false)) {
                        Double per = this.config.getDouble("block-sets." + blockSetKey + ".blocks." + mat + ".percentage");
                        Boolean disabledVanillaDrop = this.config.getBoolean("block-sets." + blockSetKey + ".blocks." + mat + ".disabled-vanilla-drop");
                        Boolean disabledBlockMining = this.config.getBoolean("block-sets." + blockSetKey + ".blocks." + mat + ".disabled-block-mining");
                        try {
                            Material m = Material.valueOf((String)mat);
                            ArrayList<MineAction> actionsList = new ArrayList<MineAction>();
                            if (this.config.getConfigurationSection("block-sets." + blockSetKey + ".blocks." + mat + ".break-actions") != null) {
                                for (String actionID : this.config.getConfigurationSection("block-sets." + blockSetKey + ".blocks." + mat + ".break-actions").getKeys(false)) {
                                    String actionRoute = "block-sets." + blockSetKey + ".blocks." + mat + ".break-actions." + actionID;
                                    Double chance = this.config.getDouble(actionRoute + ".chance");
                                    try {
                                        MineAction.MineActionType mineactiontype = MineAction.MineActionType.valueOf(this.config.getString(actionRoute + ".type"));
                                        switch (mineactiontype) {
                                            case EXECUTE_COMMAND: {
                                                actionsList.add(new MineActionCommand(actionID, name, chance, this.config.getString(actionRoute + ".value")));
                                                break;
                                            }
                                            case DROP_ITEM: {
                                                String data = this.config.getString(actionRoute + ".value");
                                                try {
                                                    actionsList.add(new MineActionDropItem(actionID, name, chance, ItemStackSpringer.getItemDeSerializedJSON(data).clone()));
                                                }
                                                catch (Exception e) {
                                                    RealMinesAPI.getInstance().getPlugin().getLogger().severe("Badly formatted ItemStack: " + data);
                                                    RealMinesAPI.getInstance().getPlugin().getLogger().warning("Item Serialized for " + mat + " isn't valid! Skipping.");
                                                }
                                                break;
                                            }
                                            case GIVE_ITEM: {
                                                String data2 = this.config.getString(actionRoute + ".value");
                                                try {
                                                    actionsList.add(new MineActionGiveItem(actionID, name, chance, ItemStackSpringer.getItemDeSerializedJSON(data2)));
                                                }
                                                catch (Exception e) {
                                                    RealMinesAPI.getInstance().getPlugin().getLogger().severe("Badly formatted ItemStack: " + data2);
                                                    RealMinesAPI.getInstance().getPlugin().getLogger().warning("Item Serialized for " + mat + " isn't valid! Skipping.");
                                                }
                                                break;
                                            }
                                            case GIVE_MONEY: {
                                                actionsList.add(new MineActionMoney(actionID, name, chance, this.config.getDouble(actionRoute + ".value")));
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        RealMinesAPI.getInstance().getPlugin().getLogger().severe("Break Action Type " + this.config.getString(actionRoute + ".Type") + " is invalid! Skipping. This action is in mine: " + name);
                                    }
                                }
                            }
                            switch (this.getType().ordinal()) {
                                case 0: {
                                    items.put(m, new MineBlockItem(m, per, disabledVanillaDrop, disabledBlockMining, (List<MineAction>)actionsList));
                                    break;
                                }
                                case 2: {
                                    items.put(m, new MineFarmItem(FarmItem.valueOf(mat), per, disabledVanillaDrop, disabledBlockMining, this.config.getInt("block-sets." + blockSetKey + ".blocks." + mat + ".age", 0), actionsList));
                                    break;
                                }
                                case 1: {
                                    items.put(m, new MineSchematicItem(m, disabledVanillaDrop, disabledBlockMining, actionsList));
                                }
                            }
                        }
                        catch (Exception e) {
                            RealMinesAPI.getInstance().getPlugin().getLogger().severe("Material type " + mat + " is invalid! Skipping. This material is in mine: " + this.getName());
                        }
                    }
                }
                Material icon = Material.BARRIER;
                try {
                    icon = Material.getMaterial((String)Objects.requireNonNull(this.config.getString("block-sets." + blockSetKey + ".icon")));
                }
                catch (Exception e) {
                    RealMinesAPI.getInstance().getPlugin().getLogger().severe("Icon for block set " + blockSetKey + " is invalid! Skipping.");
                }
                this.blockSets.put(blockSetKey, new RMBlockSet(blockSetKey, this.config.getString("block-sets." + blockSetKey + ".description"), icon, items));
            }
        }
        this.timer = new MineTimer(this);
        if (this.resetByTime) {
            int countdown = this.config.getInt("reset.time.countdown", this.resetByTimeValue);
            this.timer.start();
            this.setCountdown(countdown);
        }
    }

    public String getSettingString(RMineSettings rMineSettings) {
        return this.getMineConfig().getString(rMineSettings.getConfigKey());
    }

    public void setSettingString(RMineSettings rMineSettings, String s) {
        this.getMineConfig().set(rMineSettings.getConfigKey(), (Object)s);
        this.saveConfig();
    }

    public boolean getSettingBool(RMineSettings rMineSettings) {
        return this.getMineConfig().getBoolean(rMineSettings.getConfigKey());
    }

    public void setSettingBool(RMineSettings rMineSettings, boolean b) {
        this.getMineConfig().set(rMineSettings.getConfigKey(), (Object)b);
        this.saveConfig();
    }

    private void setConfigFile(boolean saveDefaultConfig) {
        this.file = new File(String.valueOf(RealMinesAPI.getInstance().getPlugin().getDataFolder()) + "/mines/", this.getName() + ".yml");
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            try {
                this.file.createNewFile();
                if (saveDefaultConfig) {
                    if (this.config == null) {
                        this.config = YamlConfiguration.loadConfiguration((File)this.file);
                    }
                    this.saveDefaultConfig();
                    return;
                }
            }
            catch (IOException e) {
                RealMinesAPI.getInstance().getLogger().severe("RealMinesAPI threw an error while creating config for " + this.getName());
                e.printStackTrace();
            }
        }
        if (this.config == null) {
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
        }
    }

    private void checkConfig(boolean saveDefaultConfig, boolean loadConfig) throws RMFailedToLoadException {
        this.setConfigFile(saveDefaultConfig);
        if (loadConfig) {
            this.loadMineConfig();
        }
    }

    public void rename(String s) {
        this.name = s;
        this.displayName = s;
        this.setConfigFile(false);
        this.saveData(MineData.NAME);
        this.saveData(MineData.POS);
    }

    private void saveDefaultConfig() {
        this.config.set("name", (Object)this.getName());
        this.config.set("type", (Object)this.getType().name());
        this.config.set("world", (Object)this.getWorld().getName());
        this.config.set("icon", (Object)this.getIcon().name());
        this.config.set("displayName", (Object)this.getDisplayName());
        this.config.set("color", (Object)this.getMineColor().name());
        if (this.getType() != Type.SCHEMATIC) {
            String pos1 = this.getPOS1().getX() + ";" + this.getPOS1().getY() + ";" + this.getPOS1().getZ();
            this.config.set("pos1", (Object)pos1);
            String pos2 = this.getPOS2().getX() + ";" + this.getPOS2().getY() + ";" + this.getPOS2().getZ();
            this.config.set("pos2", (Object)pos2);
        }
        this.config.set("reset.silent", (Object)this.isSilent());
        this.config.set("reset.commands", Collections.emptyList());
        this.config.set("reset.percentage.active", (Object)this.isResetBy(Reset.PERCENTAGE));
        this.config.set("reset.percentage.value", (Object)this.getResetValue(Reset.PERCENTAGE));
        this.config.set("reset.time.active", (Object)this.isResetBy(Reset.TIME));
        this.config.set("reset.time.value", (Object)this.getResetValue(Reset.TIME));
        this.config.set(RMineSettings.BREAK_PERMISSION.getConfigKey(), (Object)false);
        this.config.set(RMineSettings.DISCARD_BREAK_ACTION_MESSAGES.getConfigKey(), (Object)false);
        this.config.set(RMineSettings.BLOCK_SETS_MODE.getConfigKey(), (Object)this.getBlockSetMode().name());
        this.config.set("signs", Collections.emptyList());
        this.config.set("block-sets", Collections.emptyList());
        this.saveConfig();
    }

    public void deleteConfig() {
        File fileToDelete = new File(String.valueOf(RealMinesAPI.getInstance().getPlugin().getDataFolder()) + "/mines/", this.getName() + ".yml");
        if (fileToDelete.exists()) {
            if (!fileToDelete.delete()) {
                RealMinesAPI.getInstance().getLogger().severe("Failed to delete Configuration file for " + this.getName() + ".");
            }
        } else {
            RealMinesAPI.getInstance().getLogger().severe("Configuration file for " + this.getName() + " doesn't exist.");
        }
    }

    public BlockSetsMode getBlockSetMode() {
        return this.blockSetsMode;
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            RealMinesAPI.getInstance().getLogger().severe("RealMinesAPI threw an error while saving config for " + this.getName());
        }
    }

    public MineColor getMineColor() {
        return this.color;
    }

    public void setMineColor(MineColor color) {
        this.color = color;
        this.saveData(MineData.COLOR);
    }

    public boolean hasFaceBlock(MineCuboid.CuboidDirection up) {
        return this.faces.get((Object)up) != null;
    }

    public MineTimer getMineTimer() {
        return this.timer;
    }

    @Nullable
    public Integer getCountdown() {
        if (this.timer == null || this.timer.getCountdown() == null) {
            return null;
        }
        return this.timer.getCountdown().getSecondsLeft();
    }

    public boolean setCountdown(int seconds) {
        return this.setCountdown(seconds, true);
    }

    public boolean setCountdown(int seconds, boolean saveData) {
        if (this.timer == null || this.timer.getCountdown() == null) {
            return false;
        }
        this.timer.getCountdown().setSecondsLeft(seconds);
        if (saveData) {
            this._save(MineData.COUNTDOWN, true);
        }
        return true;
    }

    public boolean resetCountdown(boolean saveData) {
        return this.setCountdown(this.resetByTimeValue, saveData);
    }

    public Location getPOS1() {
        return this._pos1;
    }

    public Location getPOS2() {
        return this._pos2;
    }

    public void setPOS(Location p1, Location p2) {
        if (p2 == null) {
            this._pos1 = p1;
            this._pos2 = p1;
        } else {
            if (this.getType() != Type.SCHEMATIC) {
                this._pos1 = p1;
                this._pos2 = p2;
            }
            this.mineCuboid = new MineCuboid(p1, p2);
        }
        this.setWorld(p1.getWorld());
        this.saveData(MineData.POS);
    }

    private void setWorld(World w) {
        this.w = w;
    }

    public boolean hasTP() {
        return this.teleport != null;
    }

    public List<String> getSignList() {
        return this.getSigns().stream().map(mineSign -> mineSign.getBlock().getWorld().getName() + ";" + mineSign.getBlock().getX() + ";" + mineSign.getBlock().getY() + ";" + mineSign.getBlock().getZ() + ";" + mineSign.getModifier()).collect(Collectors.toList());
    }

    public String getBar() {
        return Text.getProgressBar(this.getRemainingBlocks(), this.getBlockCount(), 10, '\u25a0', ChatColor.GREEN, ChatColor.RED);
    }

    public String getPercentageBar() {
        return this.getBar() + Text.color(" &r&f") + this.getRemainingBlocksPer() + "%";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String input) {
        this.displayName = input;
        this.saveData(MineData.DISPLAYNAME);
    }

    public MineCuboid getMineCuboid() {
        return this.mineCuboid;
    }

    public int getBlockCount() {
        return this.getMineCuboid() == null ? 0 : this.getMineCuboid().getTotalBlocks();
    }

    public int getMinedBlocks() {
        return this.minedBlocks;
    }

    public int getRemainingBlocks() {
        return this.getBlockCount() - this.getMinedBlocks();
    }

    public int getRemainingBlocksPer() {
        return this.getBlockCount() == 0 ? 0 : this.getRemainingBlocks() * 100 / this.getBlockCount();
    }

    public int getMinedBlocksPer() {
        return this.getBlockCount() == 0 ? 0 : this.getMinedBlocks() * 100 / this.getBlockCount();
    }

    public abstract void fillContent();

    public void fillFaces() {
        if (RMConfig.file().getBoolean("RealMines.useWorldEditForBlockPlacement").booleanValue()) {
            for (Map.Entry<MineCuboid.CuboidDirection, Material> pair : this.faces.entrySet()) {
                MineCuboid face = this.getMineCuboid().getFace(pair.getKey());
                BlockVector3 p1 = BlockVector3.at((double)face.getMin().getX(), (double)face.getMin().getY(), (double)face.getMin().getZ());
                BlockVector3 p2 = BlockVector3.at((double)face.getMax().getX(), (double)face.getMax().getY(), (double)face.getMax().getZ());
                RandomPattern solid = new RandomPattern();
                solid.add((Pattern)BukkitAdapter.adapt((BlockData)pair.getValue().createBlockData()).toBaseBlock(), 100.0);
                WorldEditUtils.setBlocks((Region)new CuboidRegion(BukkitAdapter.adapt((World)this.getWorld()), p1, p2), (Pattern)solid);
            }
        } else {
            for (Map.Entry<MineCuboid.CuboidDirection, Material> pair : this.faces.entrySet()) {
                this.getMineCuboid().getFace(pair.getKey()).forEach(block -> block.setType((Material)pair.getValue()));
            }
        }
    }

    public Map<Material, MineItem> getMineItems() {
        return this.blockSets.values().stream().skip(this.blockSetIndex).findFirst().orElse(new RMBlockSet()).getItems();
    }

    public String getCurrentBlockSet() {
        return this.blockSets.values().stream().skip(this.blockSetIndex).findFirst().map(RMBlockSet::getKey).orElse("default");
    }

    public List<MineItem> getBlockIcons(String blockSet) {
        return this.getMineItemsOfSet(blockSet).isEmpty() ? new ArrayList<MineItem>(Collections.singletonList(new MineItem())) : new ArrayList<MineItem>(this.getMineItemsOfSet(blockSet).values());
    }

    public Map<Material, MineItem> getMineItemsOfSet(String key) {
        if (key == null || key.isEmpty()) {
            return this.getMineItems();
        }
        return this.getBlockSets().stream().filter(blockSet -> blockSet.getKey().equals(key)).findFirst().map(RMBlockSet::getItems).orElse(new HashMap());
    }

    public void removeBlockSet(RMBlockSet blockSet) {
        this.blockSets.remove(blockSet.getKey());
        this.saveData(MineData.BLOCKS);
    }

    public RMBlockSet addBlockSet(String name) {
        RMBlockSet s = name == null ? new RMBlockSet() : new RMBlockSet(name);
        this.blockSets.put(s.getKey(), s);
        this.saveData(MineData.BLOCKS);
        return s;
    }

    protected RMBlockSet getBlockSet(String blockSetKey) {
        if (blockSetKey.equalsIgnoreCase("default") && !this.blockSets.containsKey("default")) {
            RMBlockSet s = new RMBlockSet("default");
            this.blockSets.put(s.getKey(), s);
            this.saveData(MineData.BLOCKS);
            return s;
        }
        return this.blockSets.get(blockSetKey);
    }

    public void renameBlockSet(String oldKey, String newKey) {
        RMBlockSet blockSet = this.blockSets.get(oldKey);
        this.blockSets.remove(oldKey);
        blockSet.setKey(newKey);
        this.blockSets.put(newKey, blockSet);
        this.saveData(MineData.BLOCKS);
    }

    public void processBlockBreakAction(MineBlockBreakEvent e, Double random) {
        MineItem item;
        if (e.isBroken() && this.getMineItems().containsKey(e.getMaterial()) && (item = this.getMineItems().get(e.getMaterial())) != null) {
            if (item.getBreakActions().stream().allMatch(action -> action.getChance() > 99.0)) {
                item.getBreakActions().forEach(m -> m.execute(e.getPlayer(), e.getBlock().getLocation()));
                return;
            }
            MineAction exec = null;
            for (MineAction breakAction : item.getBreakActions()) {
                if (!(random < breakAction.getChance())) continue;
                if (exec == null) {
                    exec = breakAction;
                    continue;
                }
                if (!(breakAction.getChance() < exec.getChance())) continue;
                exec = breakAction;
            }
            if (exec != null) {
                exec.execute(e.getPlayer(), e.getBlock().getLocation());
            }
        }
    }

    public void processBlockBreakEvent(MineBlockBreakEvent event, boolean reset) {
        this.minedBlocks = Math.max(0, this.minedBlocks + (event.isBroken() ? 1 : -1));
        if (event.getPlayer() != null) {
            this.processBlockBreakAction(event, RealMinesAPI.getRand().nextDouble() * 100.0);
        }
        this.processBlockBreakEvent(reset);
    }

    private void processBlockBreakEvent(boolean reset) {
        if (reset && this.isResetBy(Reset.PERCENTAGE) & (double)this.getRemainingBlocksPer() < (double)this.getResetValue(Reset.PERCENTAGE)) {
            this.kickPlayers(TranslatableLine.MINE_RESET_PERCENTAGE.get());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RealMinesAPI.getInstance().getPlugin(), this::reset, 10L);
        }
        this.updateSigns();
    }

    public void saveData(MineData t) {
        this._save(t, true);
        if (this.getMineTimer() != null) {
            if (!this.resetByTime) {
                this.timer.kill();
            } else {
                this.timer.restart();
            }
        }
    }

    private void _save(MineData t, boolean save) {
        switch (t.ordinal()) {
            case 1: {
                this.config.set("icon", (Object)this.getIcon().name());
                break;
            }
            case 4: {
                String teleport = this.teleport.getBlockX() + ";" + this.teleport.getBlockY() + ";" + this.teleport.getBlockZ() + ";" + this.teleport.getYaw() + ";" + this.teleport.getPitch();
                this.config.set("teleport", (Object)teleport);
                break;
            }
            case 2: {
                this.config.set("reset.silent", (Object)this.isSilent());
                this.config.set("reset.percentage.active", (Object)this.isResetBy(Reset.PERCENTAGE));
                this.config.set("reset.percentage.value", (Object)this.getResetValue(Reset.PERCENTAGE));
                this.config.set("reset.time.active", (Object)this.isResetBy(Reset.TIME));
                this.config.set("reset.time.value", (Object)this.getResetValue(Reset.TIME));
                break;
            }
            case 3: {
                this.config.set("reset.time.countdown", (Object)this.getCountdown());
            }
            case 5: {
                this.config.set("signs", this.getSignList());
                break;
            }
            case 6: {
                String pos1 = this.getPOS1().getBlockX() + ";" + this.getPOS1().getBlockY() + ";" + this.getPOS1().getBlockZ();
                this.config.set("world", (Object)this.getWorld().getName());
                this.config.set("pos1", (Object)pos1);
                if (this.getType() == Type.SCHEMATIC) break;
                String pos2 = this.getPOS2().getBlockX() + ";" + this.getPOS2().getBlockY() + ";" + this.getPOS2().getBlockZ();
                this.config.set("pos2", (Object)pos2);
                break;
            }
            case 7: {
                this.config.set("name", (Object)this.getName());
                break;
            }
            case 8: {
                this.config.set("displayName", (Object)this.getDisplayName());
            }
            case 9: {
                this.config.set("faces", this.getFaces().entrySet().stream().collect(Collectors.toMap(e -> ((MineCuboid.CuboidDirection)((Object)((Object)e.getKey()))).name(), e -> ((Material)e.getValue()).name())));
                break;
            }
            case 10: {
                this.config.set("color", (Object)this.getMineColor().name());
                break;
            }
            case 11: {
                this.config.set("type", (Object)this.getType().name());
                break;
            }
            case 0: {
                this.config.set("block-sets", Collections.emptyList());
                this.getBlockSets().forEach(blockSetObject -> {
                    String blockSetKey = blockSetObject.getKey();
                    this.config.set("block-sets." + blockSetKey + ".description", (Object)blockSetObject.getDescription());
                    this.config.set("block-sets." + blockSetKey + ".icon", (Object)blockSetObject.getIconMaterial().name());
                    if (blockSetObject.getItems().isEmpty()) {
                        this.config.set("block-sets." + blockSetKey + ".blocks", Collections.emptyList());
                    } else {
                        blockSetObject.getItems().forEach((material, mineItem) -> {
                            String block = material.name();
                            this.config.set("block-sets." + blockSetKey + ".blocks." + block + ".percentage", (Object)mineItem.getPercentage());
                            this.config.set("block-sets." + blockSetKey + ".blocks." + block + ".disabled-vanilla-drop", (Object)mineItem.areVanillaDropsDisabled());
                            this.config.set("block-sets." + blockSetKey + ".blocks." + block + ".disabled-block-mining", (Object)mineItem.isBlockMiningDisabled());
                            if (mineItem instanceof MineFarmItem) {
                                this.config.set("block-sets." + blockSetKey + ".blocks." + block + ".age", (Object)((MineFarmItem)mineItem).getAge());
                            }
                            if (mineItem.hasBreakActions()) {
                                mineItem.getBreakActions().forEach(action -> {
                                    this.config.set("block-sets." + blockSetKey + ".blocks." + block + ".break-actions." + action.getID() + ".type", (Object)action.getType().name());
                                    this.config.set("block-sets." + blockSetKey + ".blocks." + block + ".break-actions." + action.getID() + ".chance", (Object)action.getChance());
                                    this.config.set("block-sets." + blockSetKey + ".blocks." + block + ".break-actions." + action.getID() + ".value", action.getValue());
                                });
                            }
                        });
                    }
                });
                break;
            }
            case 12: {
                this._save(MineData.ICON, false);
                this._save(MineData.TELEPORT, false);
                this._save(MineData.SIGNS, false);
                this._save(MineData.POS, false);
                this._save(MineData.NAME, false);
                this._save(MineData.FACES, false);
                this._save(MineData.COLOR, false);
                this._save(MineData.MINE_TYPE, false);
                this._save(MineData.COUNTDOWN, false);
            }
        }
        if (save) {
            this.saveConfig();
        }
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void reset() {
        this.reset(ResetCause.PLUGIN);
    }

    public void reset(ResetCause re) {
        if (!Bukkit.getOnlinePlayers().isEmpty() || RMConfig.file().getBoolean("RealMines.resetMinesWhenNoPlayers").booleanValue()) {
            OnMineResetEvent event = new OnMineResetEvent(this, re);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            switch (this.getBlockSetMode().ordinal()) {
                case 0: {
                    ++this.blockSetIndex;
                    if (this.blockSetIndex < this.blockSets.size()) break;
                    this.blockSetIndex = 0;
                    break;
                }
                case 1: {
                    this.blockSetIndex = RealMinesAPI.getRand().nextInt(this.blockSets.size());
                    break;
                }
            }
            this.kickPlayers(TranslatableLine.MINE_RESET_STARTING.setV1(TranslatableLine.ReplacableVar.MINE.eq(this.getDisplayName())).get());
            this.fillContent();
            this.minedBlocks = 0;
            this.processBlockBreakEvent(false);
            this.config.getStringList("reset.commands").forEach(s -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), s));
            if (!this.isSilent()) {
                if (RMConfig.file().getBoolean("RealMines.broadcastResetMessageOnlyInWorld").booleanValue()) {
                    this.getMineCuboid().getWorld().getPlayers().forEach(player -> TranslatableLine.MINE_RESET_ANNOUNCEMENT.setV1(TranslatableLine.ReplacableVar.MINE.eq(this.getDisplayName())).send((CommandSender)player));
                } else {
                    Bukkit.broadcastMessage((String)(Text.getPrefix() + TranslatableLine.MINE_RESET_ANNOUNCEMENT.setV1(TranslatableLine.ReplacableVar.MINE.eq(this.getDisplayName())).get()));
                }
            }
            this.updateSigns();
        }
    }

    public void addSign(Block block, String modif) {
        this.signs.add(new MineSign(block, modif));
        this.saveData(MineData.SIGNS);
    }

    public Collection<RMBlockSet> getBlockSets() {
        return Collections.unmodifiableCollection(this.blockSets.values());
    }

    public void updateSigns() {
        Bukkit.getScheduler().runTask((Plugin)RealMinesAPI.getInstance().getPlugin(), () -> {
            for (MineSign ms : this.signs) {
                if (!ms.getBlock().getType().name().contains("SIGN")) continue;
                Sign sign = (Sign)ms.getBlock().getState();
                String modif = ms.getModifier();
                switch (modif.toLowerCase()) {
                    case "tl": {
                        if (this.getMineTimer().getCountdown() == null) break;
                        sign.setLine(1, Countdown.format((long)this.getMineTimer().getCountdown().getSecondsLeft() * 1000L));
                        sign.setLine(2, Text.color("&6"));
                        break;
                    }
                    case "sl": {
                        if (this.getMineTimer().getCountdown() == null) break;
                        sign.setLine(1, Integer.toString(this.getMineTimer().getCountdown().getSecondsLeft()));
                        sign.setLine(2, Text.color("&6"));
                        break;
                    }
                    case "b": {
                        sign.setLine(1, this.getBar());
                        sign.setLine(2, Text.color("&6"));
                        break;
                    }
                    case "pb": {
                        sign.setLine(1, this.getPercentageBar());
                        sign.setLine(2, Text.color("&6"));
                        break;
                    }
                    case "pm": {
                        sign.setLine(1, this.getMinedBlocksPer() + "%");
                        sign.setLine(2, TranslatableLine.SIGNS_MINED_ON.get());
                        break;
                    }
                    case "bm": {
                        sign.setLine(1, String.valueOf(this.getMinedBlocks()));
                        sign.setLine(2, TranslatableLine.SIGNS_MINED_BLOCKS_ON.get());
                        break;
                    }
                    case "br": {
                        sign.setLine(1, String.valueOf(this.getRemainingBlocks()));
                        sign.setLine(2, TranslatableLine.SIGNS_BLOCKS_ON.get());
                        break;
                    }
                    case "pl": {
                        sign.setLine(1, this.getRemainingBlocksPer() + "%");
                        sign.setLine(2, TranslatableLine.SIGNS_LEFT_ON.get());
                    }
                }
                sign.setLine(0, Text.getPrefix());
                sign.setLine(3, Text.color(this.getDisplayName()));
                sign.update();
            }
        });
    }

    public void clear() {
        this.minedBlocks = 0;
        this.processBlockBreakEvent(false);
        this.clearContents();
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void kickPlayers(String s) {
        if (this.getType() != Type.FARM && RMConfig.file().getBoolean("RealMines.teleportPlayers").booleanValue()) {
            this.getPlayersInMine().forEach(player -> RealMinesAPI.getInstance().getMineManager().teleport((Player)player, this, this.isSilent(), false));
        }
        if (!this.isSilent()) {
            this.broadcastMessage(s);
        }
    }

    public void broadcastMessage(String s) {
        this.getPlayersInMine().forEach(p -> Text.send((CommandSender)p, s));
        if (RMConfig.file().getBoolean("RealMines.actionbarMessages").booleanValue()) {
            this.getPlayersInMine().forEach(p -> p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Text.color(s))));
        }
    }

    public List<Player> getPlayersInMine() {
        if (this.getMineCuboid() == null) {
            return Collections.emptyList();
        }
        return Bukkit.getOnlinePlayers().stream().filter(p -> this.getMineCuboid().contains(p.getLocation())).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<Location> getHighlightedCube() {
        ArrayList<Location> result = new ArrayList<Location>();
        World world = this.getMineCuboid().getPOS1().getWorld();
        double minX = Math.min(this.getMineCuboid().getPOS1().getX(), this.getMineCuboid().getPOS2().getX());
        double minY = Math.min(this.getMineCuboid().getPOS1().getY(), this.getMineCuboid().getPOS2().getY());
        double minZ = Math.min(this.getMineCuboid().getPOS1().getZ(), this.getMineCuboid().getPOS2().getZ());
        double maxX = Math.max(this.getMineCuboid().getPOS1().getX() + 1.0, this.getMineCuboid().getPOS2().getX() + 1.0);
        double maxY = Math.max(this.getMineCuboid().getPOS1().getY() + 1.0, this.getMineCuboid().getPOS2().getY() + 1.0);
        double maxZ = Math.max(this.getMineCuboid().getPOS1().getZ() + 1.0, this.getMineCuboid().getPOS2().getZ() + 1.0);
        double dist = 0.5;
        for (double x = minX; x <= maxX; x += 0.5) {
            for (double y = minY; y <= maxY; y += 0.5) {
                for (double z = minZ; z <= maxZ; z += 0.5) {
                    int components = 0;
                    if (x == minX || x == maxX) {
                        ++components;
                    }
                    if (y == minY || y == maxY) {
                        ++components;
                    }
                    if (z == minZ || z == maxZ) {
                        ++components;
                    }
                    if (components < 2) continue;
                    result.add(new Location(world, x, y, z));
                }
            }
        }
        return result;
    }

    public World getWorld() {
        return this.w;
    }

    public void highlight() {
        if (this.highlight) {
            this.getHighlightedCube().forEach(location -> location.getWorld().spawnParticle(Particle.REDSTONE, location.getX(), location.getY(), location.getZ(), 0, 0.001, 1.0, 0.0, 1.0, (Object)new Particle.DustOptions(this.getMineColor().getColor(), 1.0f)));
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isResetBy(Reset e) {
        return switch (e.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.resetByPercentage;
            case 1 -> this.resetByTime;
        };
    }

    public int getResetValue(Reset e) {
        return switch (e.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.resetByPercentageValue;
            case 1 -> this.resetByTimeValue;
        };
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        this.saveData(MineData.RESET);
    }

    public void setResetState(Reset e, boolean b) {
        switch (e.ordinal()) {
            case 0: {
                this.resetByPercentage = b;
            }
            case 1: {
                this.resetByTime = b;
            }
        }
        this.saveData(MineData.RESET);
    }

    public void setResetValue(Reset e, int d) {
        switch (e.ordinal()) {
            case 0: {
                this.resetByPercentageValue = d;
                break;
            }
            case 1: {
                this.resetByTimeValue = d;
            }
        }
        this.saveData(MineData.RESET);
    }

    public Material getIcon() {
        return this.icon;
    }

    public ItemStack getMineIcon() {
        return Items.createItem(this.getIcon(), 1, this.getMineColor().getColorPrefix() + " &f&l" + this.getDisplayName() + " &7[&b&l" + this.getType().name() + "&r&7]", RMLanguageConfig.file().getStringList("GUI.Items.Mine.Description").stream().map(s -> Text.color(s.replaceAll("%remainingblocks%", String.valueOf(this.getRemainingBlocks())).replaceAll("%totalblocks%", String.valueOf(this.getBlockCount())).replaceAll("%bar%", this.getBar()))).collect(Collectors.toList()));
    }

    public void setIcon(Material a) {
        this.icon = a;
        this.saveData(MineData.ICON);
    }

    public boolean isHighlighted() {
        return this.highlight;
    }

    public void setHighlight(boolean b) {
        this.highlight = b;
    }

    public Location getTeleport() {
        return this.teleport;
    }

    public void setTeleport(Location location) {
        this.teleport = location;
        this.saveData(MineData.TELEPORT);
    }

    public List<MineSign> getSigns() {
        return this.signs;
    }

    public Material getFaceBlock(MineCuboid.CuboidDirection up) {
        return this.faces.get((Object)up);
    }

    public void setFaceBlock(MineCuboid.CuboidDirection cd, Material a) {
        this.faces.put(cd, a);
        this.saveData(MineData.FACES);
    }

    public void removeFaceblock(MineCuboid.CuboidDirection d) {
        this.faces.remove((Object)d);
        this.saveData(MineData.FACES);
    }

    public Map<MineCuboid.CuboidDirection, Material> getFaces() {
        return this.faces;
    }

    public abstract Type getType();

    public abstract void clearContents();

    public boolean isFreezed() {
        return this.freezed;
    }

    public void setFreezed(boolean freezed) {
        this.freezed = freezed;
    }

    public String getBreakPermission() {
        return "realmines." + this.getName() + ".break";
    }

    public static enum BlockSetsMode {
        INCREMENTAL("&aIncremental"),
        RANDOM("&eRandom"),
        NONE("&fNone");

        final String displayName;

        private BlockSetsMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public BlockSetsMode next() {
            return BlockSetsMode.values()[(this.ordinal() + 1) % BlockSetsMode.values().length];
        }
    }

    public static enum Type {
        BLOCKS,
        SCHEMATIC,
        FARM;

    }

    public static enum MineData {
        BLOCKS,
        ICON,
        RESET,
        COUNTDOWN,
        TELEPORT,
        SIGNS,
        POS,
        NAME,
        DISPLAYNAME,
        FACES,
        COLOR,
        MINE_TYPE,
        ALL;

    }

    public static enum Reset {
        PERCENTAGE,
        TIME;

    }

    public static enum ResetCause {
        COMMAND,
        PLUGIN,
        TIMER,
        CREATION,
        IMPORT;

    }
}

