/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.components;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joserodpt.realmines.api.mine.components.items.MineItem;
import joserodpt.realmines.api.utils.Items;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RMBlockSet {
    private String key;
    private String description;
    private Material icon;
    private Map<Material, MineItem> items;

    public RMBlockSet() {
        this("set-" + System.currentTimeMillis(), "New block set-" + System.currentTimeMillis(), Material.CAULDRON, new HashMap<Material, MineItem>());
    }

    public RMBlockSet(String key) {
        this(key, "Description for block set: " + key, Material.CAULDRON, new HashMap<Material, MineItem>());
    }

    public RMBlockSet(String key, String description, Material icon, Map<Material, MineItem> items) {
        this.key = key;
        this.description = description;
        this.icon = icon;
        this.items = items;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<Material, MineItem> getItems() {
        return this.items;
    }

    public ItemStack getIcon(boolean sel) {
        return sel ? Items.createItemLoreEnchanted(this.icon, this.getAmount(), "&f" + this.key, this.getLore()) : Items.createItem(this.icon, this.getAmount(), "&f" + this.key, this.getLore());
    }

    private int getAmount() {
        return Math.min(64, Math.max(1, this.items.size()));
    }

    private List<String> getLore() {
        return Arrays.asList("&7Description: " + this.description, "&6", "&a&nLeft-click&r&f to view it's contents", "&a&nShift-Left-click&r&f to change it's icon", "&e&nRight-click&r&f to change the name", "&e&nShift-Right-click&r&f to change the description", "&c&nQ (Drop)&r&f to delete this set");
    }

    public boolean isDefault() {
        return this.key.equalsIgnoreCase("default");
    }

    public Material getIconMaterial() {
        return this.icon;
    }

    public void setIcon(Material mat) {
        this.icon = mat;
    }

    public void setKey(String s) {
        this.key = s;
    }

    public boolean contains(MineItem mi) {
        return this.items.containsKey(mi.getMaterial());
    }

    public void remove(MineItem mb) {
        this.items.remove(mb.getMaterial());
    }

    public void add(MineItem mineBlock) {
        this.items.put(mineBlock.getMaterial(), mineBlock);
    }
}

