/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.components.actions;

import java.util.stream.Collectors;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.mine.RMine;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class MineAction {
    private String id;
    private String mineID;
    private Double chance = 0.0;
    private boolean interactable = true;

    public MineAction() {
        this.interactable = false;
    }

    public MineAction(String mineID, Double chance) {
        this.id = this.getNewBreakActionCode();
        this.mineID = mineID;
        this.chance = chance;
    }

    public MineAction(String id, String mineID, Double chance) {
        this.id = id;
        this.mineID = mineID;
        this.chance = chance;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public String getID() {
        return this.id;
    }

    public Double getChance() {
        return this.chance;
    }

    public RMine getMine() {
        return RealMinesAPI.getInstance().getMineManager().getMine(this.mineID);
    }

    public void setChance(Double d) {
        this.chance = d;
    }

    public abstract void execute(Player var1, Location var2);

    public abstract MineActionType getType();

    public abstract String getValueString();

    public abstract Object getValue();

    public abstract ItemStack getIcon();

    public String getNewBreakActionCode() {
        String characters = "abcdefghijklmnopqrstuvwxyz";
        return "action-" + RealMinesAPI.getRand().ints(8L, 0, "abcdefghijklmnopqrstuvwxyz".length()).mapToObj("abcdefghijklmnopqrstuvwxyz"::charAt).map(Object::toString).collect(Collectors.joining()) + "-" + System.currentTimeMillis() / 1000L;
    }

    public String toString() {
        return "MineAction{id='" + this.id + "', chance=" + this.chance + ", type=" + this.getType().name() + ", mine=" + this.mineID + "}";
    }

    public static enum MineActionType {
        GIVE_MONEY("&a&lGive Money", "&aMoney"),
        DROP_ITEM("&e&lDrop Item", "&eDrop"),
        GIVE_ITEM("&b&lGive Item", "&bGive"),
        EXECUTE_COMMAND("&c&lExecute Command", "&cCommand"),
        DUMMY("&d&lDummy", "&dDummy");

        private final String displayName;
        private final String shortName;

        private MineActionType(String displayName, String shortName) {
            this.displayName = displayName;
            this.shortName = shortName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getShortName() {
            return this.shortName;
        }
    }
}

