/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.components.actions;

import java.util.Arrays;
import joserodpt.realmines.api.mine.components.actions.MineAction;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.Text;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MineActionCommand
extends MineAction {
    private final CommandSender cmdSndr = Bukkit.getServer().getConsoleSender();
    private String command;

    public MineActionCommand(String id, String mineID, Double chance, String command) {
        super(id, mineID, chance);
        this.command = command;
    }

    public MineActionCommand(String mineID, Double chance, String command) {
        super(mineID, chance);
        this.command = command;
    }

    @Override
    public void execute(Player p, Location l) {
        if (super.getMine() == null) {
            return;
        }
        String cmd2Exec = this.command.replace("%player%", p.getName()).replace("%blockloc%", Text.location2Command(l));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            cmd2Exec = PlaceholderAPI.setPlaceholders((Player)p, (String)cmd2Exec);
        }
        Bukkit.getServer().dispatchCommand(this.cmdSndr, cmd2Exec);
    }

    @Override
    public MineAction.MineActionType getType() {
        return MineAction.MineActionType.EXECUTE_COMMAND;
    }

    @Override
    public String getValueString() {
        return this.command;
    }

    @Override
    public String getValue() {
        return this.command;
    }

    @Override
    public ItemStack getIcon() {
        return Items.createItem(Material.COMMAND_BLOCK, 1, this.getType().getDisplayName() + " &r&f- " + Text.formatPercentages(super.getChance() / 100.0) + "%", Arrays.asList("&fCommand: &b/" + this.command, "", "&b&nLeft-Click&r&f to change the chance.", "&e&nRight-Click&r&f to change the command.", "&c&nQ (Drop)&r&f to remove this action.", "&8ID: " + this.getID()));
    }

    public void setCommand(String s) {
        this.command = s;
    }

    @Override
    public String toString() {
        return "MineActionCommand{command='" + this.command + "'}";
    }
}

