/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.components.actions;

import java.util.Arrays;
import java.util.Objects;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.mine.components.RMineSettings;
import joserodpt.realmines.api.mine.components.actions.MineAction;
import joserodpt.realmines.api.utils.ItemStackSpringer;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MineActionDropItem
extends MineAction {
    private ItemStack i;

    public MineActionDropItem(String id, String mineID, Double chance, ItemStack i) {
        super(id, mineID, chance);
        this.i = i;
    }

    public MineActionDropItem(String mineID, Double chance, ItemStack i) {
        super(mineID, chance);
        this.i = i;
    }

    @Override
    public void execute(Player p, Location l) {
        if (super.getMine() == null) {
            return;
        }
        Objects.requireNonNull(l.getWorld()).dropItemNaturally(l, this.i.clone());
        if (!super.getMine().getSettingBool(RMineSettings.DISCARD_BREAK_ACTION_MESSAGES)) {
            TranslatableLine.MINE_BREAK_ACTION_DROP_ITEM.send((CommandSender)p);
        }
    }

    @Override
    public MineAction.MineActionType getType() {
        return MineAction.MineActionType.DROP_ITEM;
    }

    @Override
    public String getValueString() {
        return "x" + this.i.getAmount() + " " + Text.beautifyMaterialName(this.i.getType());
    }

    @Override
    public String getValue() {
        return ItemStackSpringer.getItemSerializedJSON(this.i);
    }

    @Override
    public ItemStack getIcon() {
        return Items.createItem(Material.DROPPER, 1, this.getType().getDisplayName() + " &r&f- " + Text.formatPercentages(super.getChance() / 100.0) + "%", Arrays.asList("&fItem: &bx" + this.i.getAmount() + " " + Text.beautifyMaterialName(this.i.getType()), "", "&b&nLeft-Click&r&f to change the chance.", "&e&nRight-Click&r&f to change the item.", "&c&nQ (Drop)&r&f to remove this action.", "&8ID: " + this.getID()));
    }

    public void setItem(ItemStack itemInMainHand) {
        if (itemInMainHand == null || itemInMainHand.getType() == Material.AIR) {
            return;
        }
        this.i = itemInMainHand;
    }

    @Override
    public String toString() {
        return "MineActionItem{i=" + String.valueOf(this.i) + ", chance=" + super.getChance() + "}";
    }
}

