/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.components.actions;

import java.util.Arrays;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.mine.components.RMineSettings;
import joserodpt.realmines.api.mine.components.actions.MineAction;
import joserodpt.realmines.api.utils.ItemStackSpringer;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MineActionGiveItem
extends MineAction {
    private ItemStack i;

    public MineActionGiveItem(String id, String mineID, Double chance, ItemStack i) {
        super(id, mineID, chance);
        this.i = i;
    }

    public MineActionGiveItem(String mineID, Double chance, ItemStack i) {
        super(mineID, chance);
        this.i = i;
    }

    @Override
    public void execute(Player p, Location l) {
        ItemStack item;
        if (super.getMine() == null) {
            return;
        }
        if (!super.getMine().getSettingBool(RMineSettings.DISCARD_BREAK_ACTION_MESSAGES)) {
            TranslatableLine.MINE_BREAK_ACTION_GIVE_ITEM.send((CommandSender)p);
        }
        if (this.hasSpace(p, item = this.getClonedItem())) {
            p.getInventory().addItem(new ItemStack[]{item});
        } else {
            p.getWorld().dropItemNaturally(l, item);
            Text.send((CommandSender)p, "&cYour inventory is full. &fThe item was dropped!");
        }
    }

    private boolean hasSpace(Player p, ItemStack item) {
        for (int i = 0; i < p.getInventory().getContents().length; ++i) {
            if (i == 36 || i == 37 || i == 38 || i == 39) continue;
            ItemStack slot = p.getInventory().getItem(i);
            if (slot == null || slot.getType() == Material.AIR) {
                return true;
            }
            if (!slot.isSimilar(item) || slot.getAmount() + item.getAmount() > slot.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    @Override
    public MineAction.MineActionType getType() {
        return MineAction.MineActionType.GIVE_ITEM;
    }

    @Override
    public String getValueString() {
        ItemStack tmp = this.getClonedItem();
        return "x" + tmp.getAmount() + " " + Text.beautifyMaterialName(tmp.getType());
    }

    @Override
    public String getValue() {
        return ItemStackSpringer.getItemSerializedJSON(this.getClonedItem().clone());
    }

    @Override
    public ItemStack getIcon() {
        ItemStack tmp = this.getClonedItem();
        return Items.createItem(Material.CHEST, 1, this.getType().getDisplayName() + " &r&f- " + Text.formatPercentages(super.getChance() / 100.0) + "%", Arrays.asList("&fItem: &bx" + tmp.getAmount() + " " + Text.beautifyMaterialName(tmp.getType()), "", "&b&nLeft-Click&r&f to change the chance.", "&e&nRight-Click&r&f to change the item.", "&c&nQ (Drop)&r&f to remove this action.", "&8ID: " + this.getID()));
    }

    public void setItem(ItemStack itemInMainHand) {
        if (itemInMainHand == null || itemInMainHand.getType() == Material.AIR) {
            return;
        }
        this.i = itemInMainHand.clone();
    }

    @Override
    public String toString() {
        return "MineActionItem{i=" + String.valueOf(this.getClonedItem()) + ", chance=" + super.getChance() + "}";
    }

    private ItemStack getClonedItem() {
        return this.i.clone();
    }
}

