/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.components.actions;

import java.util.Arrays;
import joserodpt.realmines.api.RealMinesAPI;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.mine.components.RMineSettings;
import joserodpt.realmines.api.mine.components.actions.MineAction;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MineActionMoney
extends MineAction {
    private Double money;

    public MineActionMoney(String id, String mineID, Double chance, Double money) {
        super(id, mineID, chance);
        this.money = money;
    }

    public MineActionMoney(String mineID, Double chance, Double money) {
        super(mineID, chance);
        this.money = money;
    }

    @Override
    public void execute(Player p, Location l) {
        if (super.getMine() == null) {
            return;
        }
        if (RealMinesAPI.getInstance().getEconomy() != null) {
            RealMinesAPI.getInstance().getEconomy().depositPlayer((OfflinePlayer)p, this.money.doubleValue());
            if (!super.getMine().getSettingBool(RMineSettings.DISCARD_BREAK_ACTION_MESSAGES)) {
                Text.send((CommandSender)p, TranslatableLine.MINE_BREAK_ACTION_GIVE_MONEY.setV1(TranslatableLine.ReplacableVar.MONEY.eq(Text.formatNumber(this.money))).get());
            }
        } else {
            RealMinesAPI.getInstance().getLogger().warning("Economy not found or Vault not installed. Please install a compatible economy plugin. Skipping break action ID " + this.getID());
        }
    }

    @Override
    public MineAction.MineActionType getType() {
        return MineAction.MineActionType.GIVE_MONEY;
    }

    @Override
    public String getValueString() {
        return Text.formatNumber(this.money);
    }

    @Override
    public Double getValue() {
        return this.money;
    }

    @Override
    public ItemStack getIcon() {
        return Items.createItem(Material.EMERALD, 1, this.getType().getDisplayName() + " &r&f- " + Text.formatPercentages(super.getChance() / 100.0) + "%", Arrays.asList("&fAmount: &b" + Text.formatNumber(this.money), "", "&b&nLeft-Click&r&f to change the chance.", "&e&nRight-Click&r&f to change the amount.", "&c&nQ (Drop)&r&f to remove this action.", "&8ID: " + this.getID()));
    }

    public void setAmount(Double d) {
        this.money = d;
    }

    @Override
    public String toString() {
        return "MineActionMoney{money=" + this.money + ", chance=" + super.getChance() + "}";
    }
}

