/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.components.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import joserodpt.realmines.api.config.RMLanguageConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.mine.components.actions.MineAction;
import joserodpt.realmines.api.mine.components.items.MineBlockItem;
import joserodpt.realmines.api.mine.components.items.farm.MineFarmItem;
import joserodpt.realmines.api.mine.types.farm.FarmItem;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MineItem {
    private Material material = null;
    private Double percentage;
    private Boolean disabledVanillaDrop = false;
    private Boolean disabledBlockMining = false;
    private List<MineAction> breakActions;

    public MineItem() {
    }

    public MineItem(Material material) {
        if (this instanceof MineBlockItem && !material.isBlock()) {
            throw new IllegalArgumentException("Material " + String.valueOf(material) + " is not a block.");
        }
        if (this instanceof MineFarmItem && FarmItem.valueOf(material) == null) {
            throw new IllegalArgumentException("Material " + String.valueOf(material) + " is not a farm item.");
        }
        this.material = material;
        this.percentage = 0.1;
        this.breakActions = new ArrayList<MineAction>();
    }

    public MineItem(Material material, Double percentage) {
        this.material = material;
        this.percentage = percentage;
        this.breakActions = new ArrayList<MineAction>();
    }

    public MineItem(Material material, Double percentage, boolean disabledVanillaDrop, boolean disabledBlockMining, List<MineAction> breakActions) {
        this.material = material;
        this.percentage = percentage;
        this.breakActions = breakActions;
        this.disabledVanillaDrop = disabledVanillaDrop;
        this.disabledBlockMining = disabledBlockMining;
    }

    public void toggleVanillaBlockDrop() {
        this.disabledVanillaDrop = this.areVanillaDropsDisabled() == false;
    }

    public Boolean areVanillaDropsDisabled() {
        return this.disabledVanillaDrop;
    }

    public void toggleBlockMining() {
        this.disabledBlockMining = this.disabledBlockMining == false;
    }

    public Boolean isBlockMiningDisabled() {
        return this.disabledBlockMining;
    }

    public ItemStack getItem() {
        return Items.createItem(Material.DEAD_BUSH, 1, TranslatableLine.GUI_NO_BLOCKS_NAME.get(), RMLanguageConfig.file().getStringList("GUI.Items.No-Blocks.Description"));
    }

    public List<MineAction> getBreakActions() {
        return this.breakActions;
    }

    @NotNull
    protected List<String> getBreakActionsTextList() {
        return this.getBreakActions().stream().map(action -> "&7- " + action.getType().getShortName() + "&r&f: " + action.getValueString() + " &f(&e" + Text.formatPercentages(action.getChance() / 100.0) + "%&f)").collect(Collectors.toList());
    }

    public boolean hasBreakActions() {
        return !this.breakActions.isEmpty();
    }

    public boolean isInteractable() {
        return this.material != null;
    }

    public Material getMaterial() {
        return this.material;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double d) {
        this.percentage = d;
    }

    public Type getType() {
        return Type.NONE;
    }

    public String toString() {
        return "MineItem{material=" + String.valueOf(this.material) + ", percentage=" + this.percentage + ", breakActions=" + String.valueOf(this.breakActions) + "}";
    }

    public static enum Type {
        SCHEMATIC_BLOCK,
        BLOCK,
        FARM,
        NONE;

    }
}

