/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realmines.api.mine.components.items.farm;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import joserodpt.realmines.api.config.RMLanguageConfig;
import joserodpt.realmines.api.config.TranslatableLine;
import joserodpt.realmines.api.mine.components.actions.MineAction;
import joserodpt.realmines.api.mine.components.items.MineItem;
import joserodpt.realmines.api.mine.types.farm.FarmItem;
import joserodpt.realmines.api.utils.Items;
import joserodpt.realmines.api.utils.Text;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MineFarmItem
extends MineItem {
    private final FarmItem fi;
    private int age = 0;

    public MineFarmItem(FarmItem c, Double percentage, Boolean disabledVanillaDrop, Boolean disabledBlockMining, int age, List<MineAction> breakActions) {
        super(c.getIcon(), percentage, disabledVanillaDrop, disabledBlockMining, breakActions);
        this.fi = c;
        this.age = age;
    }

    public MineFarmItem(FarmItem c, Double percentage, int age) {
        super(c.getIcon(), percentage, false, false, new ArrayList<MineAction>());
        this.fi = c;
        this.age = age;
    }

    public MineFarmItem(FarmItem fi, Double percentage) {
        super(fi.getIcon(), percentage, false, false, new ArrayList<MineAction>());
        this.fi = fi;
    }

    public MineFarmItem(FarmItem fi) {
        super(fi.getIcon(), 0.1, false, false, new ArrayList<MineAction>());
        this.fi = fi;
    }

    public MineFarmItem(Material m) {
        this(FarmItem.valueOf(m));
    }

    public MineFarmItem() {
        this.fi = FarmItem.AIR;
    }

    @Override
    public ItemStack getItem() {
        return Items.createItem(super.getMaterial(), 1, TranslatableLine.GUI_FARM_ITEM_NAME.setV1(TranslatableLine.ReplacableVar.MATERIAL.eq(Text.beautifyMaterialName(this.fi.getIcon()))).setV2(TranslatableLine.ReplacableVar.AGE.eq(String.valueOf(this.getAge()))).get() + (super.areVanillaDropsDisabled() != false ? " &c&lNo-DROP" : "") + (super.isBlockMiningDisabled() != false ? " &c&lUnbreakable" : ""), RMLanguageConfig.file().getStringList("GUI.Items.Farm-Item.Description").stream().map(s -> Text.color(s.replaceAll("%percentage%", Text.formatPercentages(super.getPercentage())))).collect(Collectors.toList()));
    }

    public int getAge() {
        return this.age;
    }

    public FarmItem getFarmItem() {
        return this.fi;
    }

    @Override
    public MineItem.Type getType() {
        return MineItem.Type.FARM;
    }

    public void addAge(int i) {
        if (this.getFarmItem().getFarmItemGrowth() != null) {
            this.age = Math.min(this.getFarmItem().getFarmItemGrowth().getMax(), Math.max(this.getFarmItem().getFarmItemGrowth().getMin(), this.age + i));
        }
    }
}

